/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.logistics.item.guide.brewing;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveGuide;
import plus.dragons.createcentralkitchen.entry.capability.FRCapabilityEntries;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;

public class BrewingGuide
extends BlazeStoveGuide {
    private final LazyOptional<BrewingGuide> capability = LazyOptional.of(() -> this);
    private boolean needWater;

    public BrewingGuide(ItemStack owner) {
        super(owner, 2);
    }

    public static BrewingGuide of(ItemStack stack) {
        return (BrewingGuide)stack.getCapability(FRCapabilityEntries.BREWING_GUIDE).orElseThrow(() -> new UnsupportedOperationException("Requested Item " + stack.m_41720_() + " is not a Brewing Guide"));
    }

    public boolean needWater() {
        return this.needWater;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128379_("NeedWater", this.needWater);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.needWater = tag.m_128471_("NeedWater");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == FRCapabilityEntries.BREWING_GUIDE) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void updateRecipe(Level level) {
        level.m_7465_().m_44015_((RecipeType)FRRecipeTypes.BREWING.get(), (Container)this.recipeWrapper, level).ifPresentOrElse(recipe -> {
            this.inventory.setStackInSlot(this.ingredientSize, recipe.m_8043_());
            this.container = recipe.getOutputContainer();
            this.needWater = recipe.getNeedWater();
        }, () -> {
            this.inventory.setStackInSlot(this.ingredientSize, ItemStack.f_41583_);
            this.container = ItemStack.f_41583_;
            this.needWater = false;
        });
    }
}

