/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.mojang.blaze3d.platform.NativeImage;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.entity.model.predicates.AltitudeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.AndEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BabyEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BiomeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.DimensionEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicateRegistry;
import com.supermartijn642.fusion.entity.model.predicates.NotEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.OrEntityModelPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.CountItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.DurabilityItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.EnchantmentItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.model.modifiers.item.predicates.NotItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.OrItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.PotionItemPredicate;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.predicates.AndConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsDirectionConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.NotConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.OrConnectionPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionClient {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fusion");
    public static final RenderType USE_ORIGINAL_RENDER_TYPE_MARKER = RenderType.m_173215_((String)"fusion:ignore", null, null, (int)0, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110691_(false));
    public static final ThreadLocal<Boolean> IS_RENDERING_BREAKING_OVERLAY = new ThreadLocal();
    private static NativeImage dummyImage;
    private static String fusionVersion;

    public static NativeImage getDummyImage() {
        if (dummyImage == null) {
            dummyImage = new NativeImage(NativeImage.Format.RGBA, 1, 1, false);
            dummyImage.m_84988_(0, 0, -1);
        }
        return dummyImage;
    }

    public static void init() {
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "base"), DefaultTextureTypes.BASE);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "scrolling"), DefaultTextureTypes.SCROLLING);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "random"), DefaultTextureTypes.RANDOM);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "continuous"), DefaultTextureTypes.CONTINUOUS);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "base"), DefaultModelTypes.BASE);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_direction"), IsDirectionConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_block_in_front"), MatchBlockInFrontConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_state"), MatchStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_state_in_front"), MatchStateInFrontConnectionPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "and"), AndItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "or"), OrItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "not"), NotItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "count"), CountItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "durability"), DurabilityItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "enchantment"), EnchantmentItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "potion"), PotionItemPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new ResourceLocation("fusion", "and"), AndEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new ResourceLocation("fusion", "or"), OrEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new ResourceLocation("fusion", "not"), NotEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new ResourceLocation("fusion", "altitude"), AltitudeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new ResourceLocation("fusion", "is_baby"), BabyEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new ResourceLocation("fusion", "biome"), BiomeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(new ResourceLocation("fusion", "dimension"), DimensionEntityModelPredicate.SERIALIZER);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> InterModComms.sendTo((String)"framedblocks", (String)"add_ct_property", () -> ConnectingBakedModel.PREDICATES_EVALUATION_PROPERTY));
    }

    public static RenderType getRenderTypeMaterial(BaseTextureData.RenderType renderType) {
        if (renderType == null) {
            return USE_ORIGINAL_RENDER_TYPE_MARKER;
        }
        return switch (renderType) {
            case BaseTextureData.RenderType.OPAQUE -> RenderType.m_110451_();
            case BaseTextureData.RenderType.CUTOUT -> RenderType.m_110463_();
            case BaseTextureData.RenderType.TRANSLUCENT -> RenderType.m_110466_();
            default -> throw new AssertionError();
        };
    }

    public static String getFusionVersion() {
        if (fusionVersion == null) {
            String version = ((ModContainer)ModList.get().getModContainerById("fusion").orElseThrow()).getModInfo().getVersion().toString();
            if (!version.matches("\\d+\\.\\d+\\.\\d+")) {
                version = version.substring(0, version.length() - version.replaceFirst("\\d+\\.\\d+\\.\\d+\\D", "").length() - 1);
            }
            fusionVersion = version;
        }
        return fusionVersion;
    }
}

