/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.google.common.collect.Iterators;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.machines.TraceQuarryWork;
import com.yogpc.qp.utils.MapMulti;
import com.yogpc.qp.utils.MapStreamSyntax;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class MachineStorage {
    protected Map<ItemKey, Long> itemMap = new LinkedHashMap<ItemKey, Long>();
    protected Map<FluidKey, Long> fluidMap = new LinkedHashMap<FluidKey, Long>();
    protected LazyOptional<IItemHandler> itemHandler;
    protected LazyOptional<IFluidHandler> fluidHandler;
    private static final int MAX_TRANSFER = 4;
    @VisibleForTesting
    static final List<Direction> INSERT_ORDER = List.of(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST, Direction.DOWN, Direction.UP);

    public MachineStorage() {
        this.setHandler();
    }

    protected void setHandler() {
        this.itemHandler = LazyOptional.of(() -> new StorageItemHandler());
        this.fluidHandler = LazyOptional.of(() -> new StorageFluidHandler());
    }

    public void addItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ItemKey key = new ItemKey(stack);
        this.itemMap.merge(key, Long.valueOf(stack.m_41613_()), Long::sum);
    }

    public void addAllItems(Map<ItemKey, Long> drops) {
        drops.forEach((itemKey, count) -> {
            if (itemKey.item() != null && itemKey.item() != Items.f_41852_) {
                this.itemMap.merge((ItemKey)itemKey, (Long)count, Long::sum);
            }
        });
    }

    public void addFluid(ItemStack bucketItem) {
        FluidUtil.getFluidContained((ItemStack)bucketItem).filter(Predicate.not(FluidStack::isEmpty)).ifPresent(f -> {
            FluidKey key = new FluidKey((FluidStack)f);
            this.fluidMap.merge(key, Long.valueOf(f.getAmount()), Long::sum);
        });
    }

    public void addFluid(Fluid fluid, long amount) {
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return;
        }
        FluidKey key = new FluidKey(fluid, null);
        this.fluidMap.merge(key, amount, (l1, l2) -> {
            long a = l1 + l2;
            if (a > 0L) {
                return a;
            }
            return null;
        });
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag itemTag = this.itemMap.entrySet().stream().map(MapStreamSyntax.toAny(ItemKey::createNbt)).collect(Collectors.toCollection(ListTag::new));
        ListTag fluidTag = this.fluidMap.entrySet().stream().map(MapStreamSyntax.toAny(FluidKey::createNbt)).collect(Collectors.toCollection(ListTag::new));
        tag.m_128365_("items", (Tag)itemTag);
        tag.m_128365_("fluids", (Tag)fluidTag);
        return tag;
    }

    public void readNbt(CompoundTag tag) {
        ListTag itemTag = tag.m_128437_("items", 10);
        this.itemMap = itemTag.stream().mapMulti(MapMulti.cast(CompoundTag.class)).map(MapStreamSyntax.toEntry(ItemKey::fromNbt, n -> n.m_128454_("count"))).filter(MapStreamSyntax.byKey(k -> k.item() != Items.f_41852_)).collect(MapStreamSyntax.entryToMap());
        ListTag fluidTag = tag.m_128437_("fluids", 10);
        this.fluidMap = fluidTag.stream().mapMulti(MapMulti.cast(CompoundTag.class)).map(MapStreamSyntax.toEntry(FluidKey::fromNbt, n -> n.m_128454_("amount"))).filter(MapStreamSyntax.byKey(k -> k.fluid() != Fluids.f_76191_)).collect(MapStreamSyntax.entryToMap());
    }

    public Map<FluidKey, Long> getFluidMap() {
        return Map.copyOf(this.fluidMap);
    }

    private void putFluid(FluidKey key, long amount) {
        if (amount <= 0L) {
            this.fluidMap.remove(key);
        } else {
            this.fluidMap.put(key, amount);
        }
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> passItems() {
        return (world, pos, state, blockEntity) -> {
            MachineStorage storage = ((HasStorage)blockEntity).getStorage();
            int count = 0;
            for (Direction direction : INSERT_ORDER) {
                Optional<BlockEntity> destination = Optional.ofNullable(world.m_7702_(pos.m_121945_(direction)));
                IItemHandler handler = destination.flatMap(d -> d.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).resolve()).orElse(null);
                if (handler == null) continue;
                ArrayList<Map.Entry<ItemKey, Long>> itemMap = new ArrayList<Map.Entry<ItemKey, Long>>(storage.itemMap.entrySet());
                for (Map.Entry<ItemKey, Long> entry : itemMap) {
                    ItemStack rest;
                    ItemKey key;
                    int itemCount;
                    long beforeCount = entry.getValue();
                    while (beforeCount > 0L && (itemCount = (int)Math.min((long)(key = entry.getKey()).toStack(1).m_41741_(), beforeCount)) != (rest = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)key.toStack(itemCount), (boolean)false)).m_41613_()) {
                        long remain;
                        int transferred = itemCount - rest.m_41613_();
                        TraceQuarryWork.transferItem(blockEntity, handler, key, transferred);
                        beforeCount = remain = beforeCount - (long)transferred;
                        if (remain > 0L) {
                            storage.itemMap.put(key, remain);
                        } else {
                            storage.itemMap.remove(key);
                        }
                        if (++count < 4) continue;
                        return;
                    }
                }
            }
        };
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> passFluid() {
        return (world, pos, state, blockEntity) -> {
            MachineStorage storage = ((HasStorage)blockEntity).getStorage();
            int count = 0;
            for (Direction direction : INSERT_ORDER) {
                BlockPos destPos = pos.m_121945_(direction);
                IFluidHandler handler = Optional.ofNullable(world.m_7702_(destPos)).flatMap(d -> d.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).resolve()).orElse(null);
                if (handler == null) continue;
                ArrayList<Map.Entry<FluidKey, Long>> fluidMap = new ArrayList<Map.Entry<FluidKey, Long>>(storage.getFluidMap().entrySet());
                for (Map.Entry<FluidKey, Long> entry : fluidMap) {
                    int filled = handler.fill(entry.getKey().toStack((int)Math.min(entry.getValue(), Integer.MAX_VALUE)), IFluidHandler.FluidAction.EXECUTE);
                    if (filled <= 0) continue;
                    TraceQuarryWork.transferFluid(blockEntity, handler, entry.getKey(), filled);
                    storage.putFluid(entry.getKey(), entry.getValue() - (long)filled);
                    if (++count <= 4) continue;
                    return;
                }
            }
        };
    }

    public static interface HasStorage {
        public MachineStorage getStorage();
    }

    private final class StorageFluidHandler
    implements IFluidHandler {
        private StorageFluidHandler() {
        }

        public int getTanks() {
            return MachineStorage.this.fluidMap.size();
        }

        private Optional<Map.Entry<FluidKey, Long>> getByIndex(int index) {
            if (0 <= index && index < this.getTanks()) {
                return Optional.of((Map.Entry)Iterators.get(MachineStorage.this.fluidMap.entrySet().iterator(), (int)index));
            }
            return Optional.empty();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.getByIndex(tank).map(MapStreamSyntax.values(count -> (int)Math.min(count, Integer.MAX_VALUE))).map(MapStreamSyntax.toAny(FluidKey::toStack)).orElse(FluidStack.EMPTY);
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidKey key = new FluidKey(resource);
            return Optional.ofNullable(MachineStorage.this.fluidMap.get(key)).map(l -> this.drainInternal(Map.entry(key, l), resource.getAmount(), action)).orElse(FluidStack.EMPTY);
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            Iterator<Map.Entry<FluidKey, Long>> iterator = MachineStorage.this.fluidMap.entrySet().iterator();
            if (iterator.hasNext()) {
                return this.drainInternal(iterator.next(), maxDrain, action);
            }
            return FluidStack.EMPTY;
        }

        private FluidStack drainInternal(Map.Entry<FluidKey, Long> entry, int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drained = entry.getKey().toStack((int)Math.min(entry.getValue(), (long)maxDrain));
            if (action.execute()) {
                TraceQuarryWork.transferFluid(null, null, entry.getKey(), drained.getAmount());
                MachineStorage.this.putFluid(entry.getKey(), entry.getValue() - (long)drained.getAmount());
            }
            return drained;
        }
    }

    private class StorageItemHandler
    implements IItemHandler {
        private StorageItemHandler() {
        }

        public int getSlots() {
            return MachineStorage.this.itemMap.size();
        }

        private Optional<Map.Entry<ItemKey, Long>> getByIndex(int index) {
            if (0 <= index && index < this.getSlots()) {
                return Optional.of((Map.Entry)Iterators.get(MachineStorage.this.itemMap.entrySet().iterator(), (int)index));
            }
            return Optional.empty();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.getByIndex(slot).map(MapStreamSyntax.values(count -> (int)Math.min(count, Integer.MAX_VALUE))).map(MapStreamSyntax.toAny(ItemKey::toStack)).filter(Predicate.not(ItemStack::m_41619_)).orElse(ItemStack.f_41583_);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            Map.Entry entry = this.getByIndex(slot).orElse(null);
            if (entry != null) {
                ItemStack stack;
                ItemKey key = (ItemKey)entry.getKey();
                long storageCount = (Long)entry.getValue();
                int size = (int)Math.min((long)amount, storageCount);
                if (!simulate) {
                    TraceQuarryWork.transferItem(null, null, key, size);
                    if (storageCount > (long)amount) {
                        MachineStorage.this.itemMap.put(key, storageCount - (long)amount);
                    } else {
                        MachineStorage.this.itemMap.remove(key);
                    }
                }
                if ((stack = key.toStack(size)).m_41619_()) {
                    return ItemStack.f_41583_;
                }
                return stack;
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

