/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.RenderMarker;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TileFlexMarker
extends BlockEntity
implements QuarryMarker,
CheckerLog,
ClientSync {
    private BlockPos min;
    private BlockPos max;
    @Nullable
    public Box[] boxes;
    @Nullable
    public Box directionBox;
    public Direction direction;

    public TileFlexMarker(BlockPos pos, BlockState state) {
        super(Holder.FLEX_MARKER_TYPE, pos, state);
        this.min = pos;
        this.max = pos;
    }

    public void init(Direction facing) {
        this.direction = facing;
        this.min = this.m_58899_();
        this.max = this.m_58899_();
        this.move(Movable.LEFT, 5);
        this.move(Movable.RIGHT, 5);
        this.move(Movable.FORWARD, 10);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.setRender();
        }
    }

    private int getMaxRange() {
        return (Integer)QuarryPlus.config.common.flexMarkerMaxDistance.get();
    }

    void move(Movable movable, int amount) {
        assert (this.f_58857_ != null);
        Direction facing = movable.getActualFacing(this.direction);
        BlockPos offset = this.m_58899_();
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            this.max = this.max.m_5484_(facing, amount);
            int d = TileFlexMarker.getDistance(this.max, offset, facing.m_122434_());
            if (d > this.getMaxRange()) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, 0);
            }
            if (facing == Direction.UP && this.max.m_123342_() >= this.f_58857_.m_151558_()) {
                this.max = new BlockPos(this.max.m_123341_(), this.f_58857_.m_151558_() - 1, this.max.m_123343_());
            }
        } else {
            this.min = this.min.m_5484_(facing, amount);
            int d = TileFlexMarker.getDistance(offset, this.min, facing.m_122434_());
            if (d > this.getMaxRange()) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, 0);
            }
            if (facing == Direction.DOWN && this.min.m_123342_() < this.f_58857_.m_141937_()) {
                this.min = new BlockPos(this.min.m_123341_(), this.f_58857_.m_141937_(), this.min.m_123343_());
            }
        }
    }

    private void setRender() {
        if (this.f_58857_ == null) {
            return;
        }
        Area area = new Area((Vec3i)this.min, (Vec3i)this.max, this.direction);
        this.boxes = RenderMarker.getRenderBox(area);
        double a = 0.5;
        double c = 0.375;
        AABB bb = this.direction == null ? new AABB((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) : (this.direction.m_122434_() == Direction.Axis.X ? new AABB((double)this.m_58899_().m_123341_() - 0.375 + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, (double)this.m_58899_().m_123341_() + 0.375 + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) : new AABB((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() - 0.375 + 0.5, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.375 + 0.5));
        this.directionBox = Box.apply(bb.m_82383_(Vec3.m_82528_((Vec3i)this.direction.m_122436_()).m_82490_(0.5)), 0.125, 0.125, 0.125, true, true);
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128356_("min", this.min.m_121878_());
        compound.m_128356_("max", this.max.m_121878_());
        compound.m_128359_("direction", Optional.ofNullable(this.direction).map(Direction::toString).orElse(""));
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.min = BlockPos.m_122022_((long)compound.m_128454_("min"));
        this.max = BlockPos.m_122022_((long)compound.m_128454_("max"));
        this.direction = Direction.m_122402_((String)compound.m_128461_("direction"));
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.setRender();
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.min, this.max);
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("Direction: " + this.direction, "Min: " + this.min, "Max: " + this.max).map(Component::m_237113_).toList();
    }

    @Override
    public Optional<Area> getArea() {
        if (this.direction == null) {
            return Optional.empty();
        }
        return Optional.of(new Area((Vec3i)this.min, (Vec3i)this.max, this.direction));
    }

    @Override
    public List<ItemStack> removeAndGetItems() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7471_(this.m_58899_(), false);
        return List.of(new ItemStack((ItemLike)this.m_58900_().m_60734_()));
    }

    @Override
    public void fromClientTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag) {
        this.m_183515_(tag);
        return tag;
    }

    public static int getDistance(BlockPos to, BlockPos from, Direction.Axis axis) {
        return to.m_123304_(axis) - from.m_123304_(axis);
    }

    public static BlockPos getLimited(BlockPos to, BlockPos from, Direction facing, int limit) {
        return switch (facing.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new BlockPos(from.m_123341_(), to.m_123342_(), to.m_123343_()).m_5484_(facing, limit);
            case Direction.Axis.Y -> new BlockPos(to.m_123341_(), from.m_123342_(), to.m_123343_()).m_5484_(facing, limit);
            case Direction.Axis.Z -> new BlockPos(to.m_123341_(), to.m_123342_(), from.m_123343_()).m_5484_(facing, limit);
        };
    }

    public static enum Movable {
        UP(facing -> Direction.UP),
        LEFT(Direction::m_122428_),
        FORWARD(UnaryOperator.identity()),
        RIGHT(Direction::m_122427_),
        DOWN(facing -> Direction.DOWN);

        private final UnaryOperator<Direction> operator;
        public final String transName;

        private Movable(UnaryOperator<Direction> operator) {
            this.operator = operator;
            this.transName = "gui." + this.name().toLowerCase(Locale.US);
        }

        public Direction getActualFacing(Direction facing) {
            return (Direction)this.operator.apply(facing);
        }

        public static Movable valueOf(int i) {
            return Movable.values()[i];
        }

        public int distanceFromOrigin(BlockPos origin, BlockPos areaMin, BlockPos areaMax, Direction facing) {
            Direction actualFacing = this.getActualFacing(facing);
            BlockPos relative = actualFacing.m_122421_() == Direction.AxisDirection.POSITIVE ? areaMax : areaMin;
            return Math.abs(TileFlexMarker.getDistance(origin, relative, actualFacing.m_122434_()));
        }
    }
}

