/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModLoadingContext;
import org.jetbrains.annotations.ApiStatus;

public class GeneratorRegistrationHandler {
    private static final Map<String, GeneratorRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, GeneratorRegistrationHandler>();
    private final String modid;
    private final List<Either<Function<ResourceCache, ResourceGenerator>, BiFunction<DataGenerator, ExistingFileHelper, DataProvider>>> generatorsAndProviders = new ArrayList<Either<Function<ResourceCache, ResourceGenerator>, BiFunction<DataGenerator, ExistingFileHelper, DataProvider>>>();
    private boolean hasEventBeenFired;

    @ApiStatus.Internal
    public static boolean hasHandlerForModid(String modid) {
        return REGISTRATION_HELPER_MAP.containsKey(modid);
    }

    public static synchronized GeneratorRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, GeneratorRegistrationHandler::new);
    }

    private GeneratorRegistrationHandler(String modid) {
        this.modid = modid;
    }

    public void addGenerator(Function<ResourceCache, ResourceGenerator> generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator must not be null!");
        }
        if (this.hasEventBeenFired) {
            throw new RuntimeException("Generators supplier must be added before the GatherDataEvent gets fired!");
        }
        this.generatorsAndProviders.add(Either.left(generator));
    }

    public void addGenerator(Supplier<ResourceGenerator> generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator supplier must not be null!");
        }
        this.addGenerator((ResourceCache cache) -> (ResourceGenerator)generator.get());
    }

    public void addGenerator(ResourceGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator must not be null!");
        }
        this.addGenerator((ResourceCache cache) -> generator);
    }

    public void addProvider(BiFunction<DataGenerator, ExistingFileHelper, DataProvider> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        if (this.hasEventBeenFired) {
            throw new RuntimeException("Providers supplier must be added before the GatherDataEvent gets fired!");
        }
        this.generatorsAndProviders.add(Either.right(provider));
    }

    public void addProvider(Function<DataGenerator, DataProvider> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.addProvider((DataGenerator generator, ExistingFileHelper existingFileHelper) -> (DataProvider)provider.apply((DataGenerator)generator));
    }

    public void addProvider(Supplier<DataProvider> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.addProvider((DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) -> (DataProvider)provider.get());
    }

    public void addProvider(DataProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.addProvider((DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) -> provider);
    }

    @ApiStatus.Internal
    public void registerProviders(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper, ResourceCache cache) {
        this.hasEventBeenFired = true;
        this.generatorsAndProviders.stream().map(either -> either.mapLeft(generator -> (ResourceGenerator)generator.apply(cache))).map(either -> either.mapLeft(ResourceGenerator::createDataProvider)).map(either -> either.mapRight(provider -> (DataProvider)provider.apply(dataGenerator, existingFileHelper))).map(either -> either.leftOrElseGet(either::right)).forEach(provider -> dataGenerator.m_236039_(true, provider));
    }
}

