/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util.client;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import java.time.Duration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public final class ModelCache {
    public static final Duration DEFAULT_CACHE_DURATION = Duration.ofMinutes(10L);
    private static final LoadingCache<BlockState, BakedModel> modelCache = Caffeine.newBuilder().expireAfterAccess(DEFAULT_CACHE_DURATION).build((CacheLoader)new ModelCacheLoader());
    private static ModelBakery modelBakery = null;

    public static void clear(ModelBakery bakery) {
        modelCache.invalidateAll();
        modelBakery = bakery;
    }

    public static BakedModel getModel(BlockState state) {
        return (BakedModel)modelCache.get((Object)state);
    }

    public static ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource random, ModelData data) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{ItemBlockRenderTypes.m_109287_((FluidState)state.m_60819_())});
        }
        return ((BakedModel)modelCache.get((Object)state)).getRenderTypes(state, random, data);
    }

    public static ChunkRenderTypeSet getCamoRenderTypes(BlockState state, RandomSource random, ModelData data) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{ItemBlockRenderTypes.m_109287_((FluidState)state.m_60819_())});
        }
        BakedModel model = (BakedModel)modelCache.get((Object)state);
        data = ModelUtils.getCamoModelData(model, state, data);
        return model.getRenderTypes(state, random, data);
    }

    public static ModelBakery getModelBakery() {
        Preconditions.checkNotNull((Object)modelBakery, (Object)"ModelBakery requested before first resource reload");
        return modelBakery;
    }

    private ModelCache() {
    }

    private static class ModelCacheLoader
    implements CacheLoader<BlockState, BakedModel> {
        private ModelCacheLoader() {
        }

        public BakedModel load(BlockState key) {
            Block block = key.m_60734_();
            if (block instanceof LiquidBlock) {
                LiquidBlock fluid = (LiquidBlock)block;
                return FramedBlocksClientAPI.getInstance().createFluidModel((Fluid)fluid.getFluid());
            }
            return Minecraft.m_91087_().m_91289_().m_110910_(key);
        }
    }
}

