/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public final class QuadTable {
    private static final int LAYER_COUNT = RenderType.m_110506_().size();
    private static final int SIDE_COUNT = Direction.values().length + 1;
    private static final Direction[] SIDES = Direction.values();
    private final QuadList[][] quads = new QuadList[LAYER_COUNT][];

    public List<BakedQuad> getQuads(RenderType renderType, Direction side) {
        QuadList[] bySide = this.quads[renderType.getChunkLayerId()];
        if (bySide != null) {
            return bySide[QuadTable.maskNull((Direction)side)].quads;
        }
        return Collections.emptyList();
    }

    public void put(RenderType renderType, Map<Direction, List<BakedQuad>> bySide) {
        QuadList[] bySideArr = new QuadList[SIDE_COUNT];
        bySideArr[QuadTable.maskNull(null)] = new QuadList(bySide.getOrDefault(null, List.of()));
        for (Direction side : SIDES) {
            bySideArr[QuadTable.maskNull((Direction)side)] = new QuadList(bySide.getOrDefault(side, List.of()));
        }
        this.quads[renderType.getChunkLayerId()] = bySideArr;
    }

    private static int maskNull(Direction side) {
        if (side == null) {
            return 6;
        }
        return side.m_122411_();
    }

    private record QuadList(List<BakedQuad> quads) {
    }
}

