/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration.forge;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftblibrary.FTBLibraryClient;
import dev.ftb.mods.ftblibrary.config.ui.ItemSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import java.util.Collection;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIIntegration
implements IModPlugin,
IGlobalGuiHandler {
    public static IJeiRuntime runtime = null;
    private static final ItemSearchMode JEI_ITEMS = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42410_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.jei");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            if (runtime == null) {
                return Collections.emptySet();
            }
            return runtime.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
        }
    };

    public void onRuntimeAvailable(IJeiRuntime r) {
        runtime = r;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ftblibrary", "jei");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (ModList.get().isLoaded("roughlyenoughitems")) {
            return;
        }
        registration.addGlobalGuiHandler((IGlobalGuiHandler)this);
    }

    @NotNull
    public Collection<Rect2i> getGuiExtraAreas() {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (FTBLibraryClient.areButtonsVisible(currentScreen)) {
            return Collections.singleton(SidebarGroupGuiButton.lastDrawnArea);
        }
        return Collections.emptySet();
    }

    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof IScreenWrapper) {
            Object o = WrappedIngredient.unwrap(((IScreenWrapper)currentScreen).getGui().getIngredientUnderMouse());
            if (o instanceof FluidStack) {
                FluidStack archFluidStack = (FluidStack)o;
                return new net.minecraftforge.fluids.FluidStack(archFluidStack.getFluid(), (int)archFluidStack.getAmount(), archFluidStack.getTag());
            }
            return o;
        }
        return null;
    }

    static {
        if (!ModList.get().isLoaded("roughlyenoughitems")) {
            SelectItemStackScreen.modes.add(0, JEI_ITEMS);
        }
    }
}

