/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import thetadev.constructionwand.items.ModItems;

public class ConfigServer {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue LIMIT_CREATIVE;
    public static final ForgeConfigSpec.IntValue MAX_RANGE;
    public static final ForgeConfigSpec.IntValue UNDO_HISTORY;
    public static final ForgeConfigSpec.BooleanValue ANGEL_FALLING;
    public static final ForgeConfigSpec.ConfigValue<List<?>> SIMILAR_BLOCKS;
    private static final String[] SIMILAR_BLOCKS_DEFAULT;
    public static final ForgeConfigSpec.BooleanValue TE_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<?>> TE_LIST;
    private static final String[] TE_LIST_DEFAULT;
    private static final HashMap<ResourceLocation, WandProperties> wandProperties;

    public static WandProperties getWandProperties(Item wand) {
        return wandProperties.getOrDefault(ForgeRegistries.ITEMS.getKey((Object)wand), WandProperties.DEFAULT);
    }

    static {
        SIMILAR_BLOCKS_DEFAULT = new String[]{"minecraft:dirt;minecraft:grass_block;minecraft:coarse_dirt;minecraft:podzol;minecraft:mycelium;minecraft:farmland;minecraft:dirt_path;minecraft:rooted_dirt"};
        TE_LIST_DEFAULT = new String[]{"chiselsandbits"};
        wandProperties = new HashMap();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(new String[]{"This is the Server config for ConstructionWand.", "If you're not familiar with Forge's new split client/server config, let me explain:", "Client config is stored in the /config folder and only contains client specific settings like graphics and keybinds.", "Mod behavior is configured in the Server config, which is world-specific and thus located", "in the /saves/myworld/serverconfig folder. If you want to change the serverconfig for all", "new worlds, copy the config files in the /defaultconfigs folder."});
        new WandProperties(builder, ModItems.WAND_STONE, Tiers.STONE.m_6609_(), 9, 0, 0, false);
        new WandProperties(builder, ModItems.WAND_IRON, Tiers.IRON.m_6609_(), 27, 2, 9, true);
        new WandProperties(builder, ModItems.WAND_DIAMOND, Tiers.DIAMOND.m_6609_(), 128, 8, 25, true);
        new WandProperties(builder, ModItems.WAND_INFINITY, 0, 1024, 16, 81, true);
        builder.push("misc");
        builder.comment("Block limit for Infinity Wand used in creative mode");
        LIMIT_CREATIVE = builder.defineInRange("InfinityWandCreative", 2048, 1, Integer.MAX_VALUE);
        builder.comment("Maximum placement range (0: unlimited). Affects all wands and is meant for lag prevention, not game balancing.");
        MAX_RANGE = builder.defineInRange("MaxRange", 100, 0, Integer.MAX_VALUE);
        builder.comment("Number of operations that can be undone");
        UNDO_HISTORY = builder.defineInRange("UndoHistory", 3, 0, Integer.MAX_VALUE);
        builder.comment("Place blocks below you while falling > 10 blocks with angel core (Can be used to save you from drops/the void)");
        ANGEL_FALLING = builder.define("AngelFalling", false);
        builder.comment("Blocks to treat equally when in Similar mode. Enter block IDs seperated by ;");
        SIMILAR_BLOCKS = builder.defineList("SimilarBlocks", Arrays.asList(SIMILAR_BLOCKS_DEFAULT), obj -> true);
        builder.pop();
        builder.push("tileentity");
        builder.comment(new String[]{"White/Blacklist for Tile Entities. Allow/Prevent blocks with TEs from being placed by wand.", "You can either add block ids like minecraft:chest or mod ids like minecraft"});
        TE_LIST = builder.defineList("TEList", Arrays.asList(TE_LIST_DEFAULT), obj -> true);
        builder.comment("If set to TRUE, treat TEList as a whitelist, otherwise blacklist");
        TE_WHITELIST = builder.define("TEWhitelist", false);
        builder.pop();
        SPEC = builder.build();
    }

    public static class WandProperties {
        public static final WandProperties DEFAULT = new WandProperties(null, null, null, null, null);
        private final ForgeConfigSpec.IntValue durability;
        private final ForgeConfigSpec.IntValue limit;
        private final ForgeConfigSpec.IntValue angel;
        private final ForgeConfigSpec.IntValue destruction;
        private final ForgeConfigSpec.BooleanValue upgradeable;

        private WandProperties(ForgeConfigSpec.IntValue durability, ForgeConfigSpec.IntValue limit, ForgeConfigSpec.IntValue angel, ForgeConfigSpec.IntValue destruction, ForgeConfigSpec.BooleanValue upgradeable) {
            this.durability = durability;
            this.limit = limit;
            this.angel = angel;
            this.destruction = destruction;
            this.upgradeable = upgradeable;
        }

        public WandProperties(ForgeConfigSpec.Builder builder, RegistryObject<Item> wandSupplier, int defDurability, int defLimit, int defAngel, int defDestruction, boolean defUpgradeable) {
            ResourceLocation registryName = wandSupplier.getId();
            builder.push(registryName.m_135815_());
            if (defDurability > 0) {
                builder.comment("Wand durability");
                this.durability = builder.defineInRange("durability", defDurability, 1, Integer.MAX_VALUE);
            } else {
                this.durability = null;
            }
            builder.comment("Wand block limit");
            this.limit = builder.defineInRange("limit", defLimit, 1, Integer.MAX_VALUE);
            builder.comment("Max placement distance with angel core (0 to disable angel core)");
            this.angel = builder.defineInRange("angel", defAngel, 0, Integer.MAX_VALUE);
            builder.comment("Wand destruction block limit (0 to disable destruction core)");
            this.destruction = builder.defineInRange("destruction", defDestruction, 0, Integer.MAX_VALUE);
            builder.comment("Allow wand upgrading by putting the wand together with a wand core in a crafting grid.");
            this.upgradeable = builder.define("upgradeable", defUpgradeable);
            builder.pop();
            wandProperties.put(registryName, this);
        }

        public int getDurability() {
            return this.durability == null ? -1 : (Integer)this.durability.get();
        }

        public int getLimit() {
            return this.limit == null ? 0 : (Integer)this.limit.get();
        }

        public int getAngel() {
            return this.angel == null ? 0 : (Integer)this.angel.get();
        }

        public int getDestruction() {
            return this.destruction == null ? 0 : (Integer)this.destruction.get();
        }

        public boolean isUpgradeable() {
            return this.upgradeable != null && (Boolean)this.upgradeable.get() != false;
        }
    }
}

