/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.data;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.crafting.RecipeWandUpgrade;
import thetadev.constructionwand.data.Inp;
import thetadev.constructionwand.items.ModItems;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.wandRecipe(consumer, (ItemLike)ModItems.WAND_STONE.get(), Inp.fromTag((TagKey<Item>)ItemTags.f_13165_));
        this.wandRecipe(consumer, (ItemLike)ModItems.WAND_IRON.get(), Inp.fromTag((TagKey<Item>)Tags.Items.INGOTS_IRON));
        this.wandRecipe(consumer, (ItemLike)ModItems.WAND_DIAMOND.get(), Inp.fromTag((TagKey<Item>)Tags.Items.GEMS_DIAMOND));
        this.wandRecipe(consumer, (ItemLike)ModItems.WAND_INFINITY.get(), Inp.fromTag((TagKey<Item>)Tags.Items.NETHER_STARS));
        this.coreRecipe(consumer, (ItemLike)ModItems.CORE_ANGEL.get(), Inp.fromTag((TagKey<Item>)Tags.Items.FEATHERS), Inp.fromTag((TagKey<Item>)Tags.Items.INGOTS_GOLD));
        this.coreRecipe(consumer, (ItemLike)ModItems.CORE_DESTRUCTION.get(), Inp.fromTag((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND), Inp.fromItem((ItemLike)Items.f_42390_));
        this.specialRecipe(consumer, RecipeWandUpgrade.SERIALIZER);
    }

    private void wandRecipe(Consumer<FinishedRecipe> consumer, ItemLike wand, Inp material) {
        ShapedRecipeBuilder.m_126116_((ItemLike)wand).m_126124_(Character.valueOf('X'), material.ingredient).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126130_("  X").m_126130_(" # ").m_126130_("#  ").m_126132_("has_item", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{material.predicate})).m_176498_(consumer);
    }

    private void coreRecipe(Consumer<FinishedRecipe> consumer, ItemLike core, Inp item1, Inp item2) {
        ShapedRecipeBuilder.m_126116_((ItemLike)core).m_126124_(Character.valueOf('O'), item1.ingredient).m_126124_(Character.valueOf('X'), item2.ingredient).m_206416_(Character.valueOf('#'), Tags.Items.GLASS_PANES).m_126130_(" #X").m_126130_("#O#").m_126130_("X# ").m_126132_("has_item", (CriterionTriggerInstance)RecipeGenerator.m_126011_((ItemPredicate[])new ItemPredicate[]{item1.predicate})).m_176498_(consumer);
    }

    private void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer) {
        ResourceLocation name = ForgeRegistries.RECIPE_SERIALIZERS.getKey(serializer);
        SpecialRecipeBuilder.m_126357_(serializer).m_126359_(consumer, ConstructionWand.loc("dynamic/" + name.m_135815_()).toString());
    }

    @Nonnull
    public String m_6055_() {
        return "constructionwand crafting recipes";
    }
}

