/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.LightDetectorBlockEntity;
import appeng.helpers.AEMaterials;
import appeng.helpers.MetaRotation;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightDetectorBlock
extends AEBaseEntityBlock<LightDetectorBlockEntity>
implements IOrientableBlock {
    public static final BooleanProperty ODD = BooleanProperty.m_61465_((String)"odd");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public LightDetectorBlock() {
        super(LightDetectorBlock.defaultProps(AEMaterials.FIXTURE).m_60910_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)ODD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
        builder.m_61104_(new Property[]{ODD});
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (level instanceof Level && ((LightDetectorBlockEntity)this.getBlockEntity(level, pos)).isReady()) {
            return ((Level)level).m_46803_(pos) - 6;
        }
        return 0;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        LightDetectorBlockEntity tld = (LightDetectorBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (tld != null) {
            tld.updateLight();
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
    }

    @Override
    public boolean isValidOrientation(LevelAccessor level, BlockPos pos, Direction forward, Direction up) {
        return this.canPlaceAt((LevelReader)level, pos, up.m_122424_());
    }

    private boolean canPlaceAt(LevelReader level, BlockPos pos, Direction dir) {
        return LightDetectorBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(dir), (Direction)dir.m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction up = this.getOrientable(level, pos).getUp();
        double xOff = -0.3 * (double)up.m_122429_();
        double yOff = -0.3 * (double)up.m_122430_();
        double zOff = -0.3 * (double)up.m_122431_();
        return Shapes.m_83064_((AABB)new AABB(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction up = this.getOrientable((BlockGetter)level, pos).getUp();
        if (!this.canPlaceAt((LevelReader)level, pos, up.m_122424_())) {
            this.dropTorch(level, pos);
        }
    }

    private void dropTorch(Level level, BlockPos pos) {
        BlockState prev = level.m_8055_(pos);
        level.m_46961_(pos, true);
        level.m_7260_(pos, prev, level.m_8055_(pos), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.canPlaceAt(level, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOrientable getOrientable(BlockGetter level, BlockPos pos) {
        return new MetaRotation(level, pos, (Property<Direction>)BlockStateProperties.f_61372_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return blockState;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, facing, facingState, level, currentPos, facingPos);
    }
}

