/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.unlikepaladin.pfm.menus.WorkbenchScreenHandler;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class WorkbenchScreen
extends AbstractContainerScreen<WorkbenchScreenHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("pfm:textures/gui/container/working_table.png");
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int RECIPE_LIST_COLUMNS = 6;
    private static final int RECIPE_LIST_ROWS = 3;
    private static final int RECIPE_ENTRY_WIDTH = 16;
    private static final int RECIPE_ENTRY_HEIGHT = 18;
    private static final int SCROLLBAR_AREA_HEIGHT = 54;
    private static final int RECIPE_LIST_OFFSET_X = 20;
    private static final int RECIPE_LIST_OFFSET_Y = 30;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;
    private boolean canCraft;
    private EditBox searchBox;
    private final Set<TagKey<Item>> searchResultTags = new HashSet<TagKey<Item>>();

    public WorkbenchScreen(WorkbenchScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        this.canCraft = handler.canCraft();
    }

    protected void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this.f_96547_);
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 20, this.f_97736_ + 18, 110, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.f_97727_ = 180;
        this.f_97726_ = 176;
        this.f_97731_ = this.f_97727_ - 92;
    }

    public void m_6574_(Minecraft client, int width, int height) {
        String string = this.searchBox.m_94155_();
        this.m_6575_(client, width, height);
        this.searchBox.m_94144_(string);
        if (!this.searchBox.m_94155_().isEmpty()) {
            this.search();
        }
    }

    public boolean m_5534_(char chr, int modifiers) {
        String string = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(chr, modifiers)) {
            if (!Objects.equals(string, this.searchBox.m_94155_())) {
                this.search();
            }
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean bl2 = InputConstants.m_84827_((int)keyCode, (int)scanCode).m_84876_().isPresent();
        if (bl2 && this.m_97805_(keyCode, scanCode)) {
            return true;
        }
        String string = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(string, this.searchBox.m_94155_())) {
                this.search();
            }
            return true;
        }
        if (this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void search() {
        ((WorkbenchScreenHandler)this.f_97732_).getSearchableRecipes().clear();
        this.searchResultTags.clear();
        String string = this.searchBox.m_94155_();
        if (string.isEmpty()) {
            ((WorkbenchScreenHandler)this.f_97732_).updateInput();
            ((WorkbenchScreenHandler)this.f_97732_).searching = false;
        } else {
            SearchTree searchable;
            ((WorkbenchScreenHandler)this.f_97732_).updateInput();
            if (string.startsWith("#")) {
                string = string.substring(1);
                searchable = this.f_96541_.m_231372_(SearchRegistry.f_119942_);
                this.searchForTags(string);
            } else {
                searchable = this.f_96541_.m_231372_(SearchRegistry.f_119941_);
            }
            ArrayList items = new ArrayList();
            searchable.m_6293_(string.toLowerCase(Locale.ROOT)).forEach(itemStack -> items.add(itemStack.m_41720_()));
            ((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().forEach(furnitureRecipe -> {
                if (items.contains(furnitureRecipe.m_8043_().m_41720_())) {
                    ((WorkbenchScreenHandler)this.f_97732_).getSearchableRecipes().add((FurnitureRecipe.CraftableFurnitureRecipe)furnitureRecipe);
                }
            });
            ((WorkbenchScreenHandler)this.f_97732_).searching = true;
        }
        this.scrollAmount = 0.0f;
        this.scrollOffset = 0;
    }

    private void searchForTags(String id) {
        Predicate<ResourceLocation> predicate;
        int i = id.indexOf(58);
        if (i == -1) {
            predicate = idx -> idx.m_135815_().contains(id);
        } else {
            String string = id.substring(0, i).trim();
            String string2 = id.substring(i + 1).trim();
            predicate = idx -> idx.m_135827_().contains(string) && idx.m_135815_().contains(string2);
        }
        Stream<TagKey> keyStream = Registry.f_122827_.m_203613_().filter(tagKey -> predicate.test(tagKey.f_203868_()));
        keyStream.forEach(this.searchResultTags::add);
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        this.m_7333_(matrices);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.m_93228_(matrices, x, y, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollAmount);
        this.m_93228_(matrices, x + 119, y + 31 + k, 176 + (this.shouldScroll() ? 0 : 12), 0, 12, 15);
        int xOffSetForIcons = this.f_97735_ + 20;
        int yOffsetForIcons = this.f_97736_ + 30;
        int scrollOffsetForIcons = this.scrollOffset + 18;
        this.renderRecipeBackground(matrices, mouseX, mouseY, xOffSetForIcons, yOffsetForIcons, scrollOffsetForIcons);
        this.renderRecipeIcons(xOffSetForIcons, yOffsetForIcons, scrollOffsetForIcons);
        this.searchBox.m_6305_(matrices, mouseX, mouseY, delta);
    }

    protected void m_7025_(PoseStack matrices, int x, int y) {
        super.m_7025_(matrices, x, y);
        int xOffsetForTooltip = this.f_97735_ + 20;
        int yOffsetForTooltip = this.f_97736_ + 30;
        int scrollOffsetForTooltip = this.scrollOffset + 18;
        for (int recipeIndex = this.scrollOffset; recipeIndex < scrollOffsetForTooltip && recipeIndex < ((WorkbenchScreenHandler)this.f_97732_).getVisibleRecipeCount(); ++recipeIndex) {
            int m = recipeIndex - this.scrollOffset;
            int n = xOffsetForTooltip + m % 6 * 16;
            int o = yOffsetForTooltip + m / 6 * 18 + 2;
            if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            int iCopy = recipeIndex;
            if (((WorkbenchScreenHandler)this.f_97732_).searching) {
                iCopy = ((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.f_97732_).getSearchableRecipes().get(iCopy));
            }
            tooltip.add((Component)this.m_96555_(((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().get(iCopy).m_8043_()).get(0));
            tooltip.add(Component.m_237115_((String)"container.pfm.working_table.ingredient_required").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
            HashMap<Item, Integer> itemStackCountMap = new HashMap<Item, Integer>();
            for (Ingredient ingredient : ((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().get(iCopy).getIngredients()) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    if (!itemStackCountMap.containsKey(stack.m_41720_())) {
                        itemStackCountMap.put(stack.m_41720_(), stack.m_41613_());
                        continue;
                    }
                    itemStackCountMap.put(stack.m_41720_(), (Integer)itemStackCountMap.get(stack.m_41720_()) + stack.m_41613_());
                }
            }
            itemStackCountMap.forEach((item, integer) -> {
                int itemCount = ((WorkbenchScreenHandler)this.f_97732_).getPlayerInventory().m_18947_(item);
                Style style = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
                if (itemCount < integer) {
                    style = style.m_131140_(ChatFormatting.RED);
                }
                tooltip.add(Component.m_237113_((String)(integer + " ")).m_7220_((Component)Component.m_237113_((String)((Component)this.m_96555_(item.m_7968_()).get(0)).getString())).m_6270_(style));
            });
            this.m_96597_(matrices, tooltip, x, y);
        }
    }

    private void renderRecipeBackground(PoseStack matrices, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((WorkbenchScreenHandler)this.f_97732_).getVisibleRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 6 * 16;
            int l = j / 6;
            int m = y + l * 18 + 2;
            int v = this.f_97727_;
            int iCopy = i;
            if (((WorkbenchScreenHandler)this.f_97732_).searching) {
                iCopy = ((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.f_97732_).getSearchableRecipes().get(iCopy));
            }
            if (iCopy == ((WorkbenchScreenHandler)this.f_97732_).getSelectedRecipe()) {
                v += 55;
            } else if (!((WorkbenchScreenHandler)this.f_97732_).getAvailableRecipes().contains(((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().get(iCopy))) {
                v += 18;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                v += 36;
            }
            this.m_93228_(matrices, k, m - 1, 0, v, 16, 18);
        }
    }

    private void renderRecipeIcons(int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((WorkbenchScreenHandler)this.f_97732_).getVisibleRecipeCount(); ++i) {
            int iMinusScrollOffset = i - this.scrollOffset;
            int xOffset = x + iMinusScrollOffset % 6 * 16;
            int l = iMinusScrollOffset / 6;
            int yOffset = y + l * 18 + 2;
            int iCopy = i;
            if (((WorkbenchScreenHandler)this.f_97732_).searching) {
                iCopy = ((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.f_97732_).getSearchableRecipes().get(iCopy));
            }
            this.f_96541_.m_91291_().m_115203_(((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().get(iCopy).m_8043_(), xOffset, yOffset);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int xOffsetForMouseClick = this.f_97735_ + 20;
            int yOffsetForMouseClick = this.f_97736_ + 30;
            int scrollOffsetForMouseClick = this.scrollOffset + 18;
            for (int clickedRecipeId = this.scrollOffset; clickedRecipeId < scrollOffsetForMouseClick; ++clickedRecipeId) {
                int m = clickedRecipeId - this.scrollOffset;
                double d = mouseX - (double)(xOffsetForMouseClick + m % 6 * 16);
                double e = mouseY - (double)(yOffsetForMouseClick + m / 6 * 18);
                int clickedRecipeIdCopy = clickedRecipeId;
                if (((WorkbenchScreenHandler)this.f_97732_).searching) {
                    clickedRecipeIdCopy = clickedRecipeIdCopy < ((WorkbenchScreenHandler)this.f_97732_).getSearchableRecipes().size() ? ((WorkbenchScreenHandler)this.f_97732_).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.f_97732_).getSearchableRecipes().get(clickedRecipeIdCopy)) : -1;
                }
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WorkbenchScreenHandler)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, clickedRecipeIdCopy))) continue;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((WorkbenchScreenHandler)this.f_97732_).f_38840_, clickedRecipeIdCopy);
                return true;
            }
            xOffsetForMouseClick = this.f_97735_ + 119;
            yOffsetForMouseClick = this.f_97736_ + 9;
            if (mouseX >= (double)xOffsetForMouseClick && mouseX < (double)(xOffsetForMouseClick + 12) && mouseY >= (double)yOffsetForMouseClick && mouseY < (double)(yOffsetForMouseClick + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.f_97736_ + 30;
            int j = i + 54;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = Mth.m_14036_((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 6;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            this.scrollAmount = (float)((double)this.scrollAmount - amount / (double)i);
            this.scrollAmount = Mth.m_14036_((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 6;
        }
        return true;
    }

    private boolean shouldScroll() {
        return ((WorkbenchScreenHandler)this.f_97732_).getVisibleRecipeCount() > 18;
    }

    protected int getMaxScroll() {
        return (((WorkbenchScreenHandler)this.f_97732_).getVisibleRecipeCount() + 6 - 1) / 6 - 3;
    }

    private void onInventoryChange() {
        this.canCraft = ((WorkbenchScreenHandler)this.f_97732_).canCraft();
        if (!this.canCraft) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }
}

