/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.client.screens.PFMConfigScreen;
import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.BooleanConfigOption;
import com.unlikepaladin.pfm.config.option.Side;
import com.unlikepaladin.pfm.runtime.PFMAssetGenerator;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PFMOptionListWidget
extends ContainerObjectSelectionList<Entry> {
    final PFMConfigScreen parent;
    int maxKeyNameLength;
    public BitSet hasChanges;
    public Map<AbstractConfigOption, Boolean> newConfigValues;
    public Map<AbstractConfigOption, Integer> configOptionToIndexForHasChanges;

    public PFMOptionListWidget(PFMConfigScreen parent, Minecraft client) {
        super(client, parent.f_96543_ + 125, parent.f_96544_, 43, parent.f_96544_ - 32, 20);
        this.parent = parent;
        String string = null;
        int index = 0;
        this.hasChanges = new BitSet(PaladinFurnitureMod.getPFMConfig().options.size());
        this.newConfigValues = new HashMap<AbstractConfigOption, Boolean>(PaladinFurnitureMod.getPFMConfig().options.size());
        this.configOptionToIndexForHasChanges = new HashMap<AbstractConfigOption, Integer>(PaladinFurnitureMod.getPFMConfig().options.size());
        for (Map.Entry<String, AbstractConfigOption> configOptionEntry : PaladinFurnitureMod.getPFMConfig().options.entrySet()) {
            Component text;
            int i;
            String configOptionCategory = configOptionEntry.getValue().getCategory();
            if (!configOptionCategory.equals(string)) {
                string = configOptionCategory;
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry(Component.m_237115_((String)configOptionCategory)));
            }
            if ((i = client.f_91062_.m_92852_((FormattedText)(text = configOptionEntry.getValue().getTitle()))) > this.maxKeyNameLength) {
                this.maxKeyNameLength = i;
            }
            if (configOptionEntry.getValue().getType() == Boolean.class) {
                this.newConfigValues.put(configOptionEntry.getValue(), (Boolean)configOptionEntry.getValue().getValue());
                this.m_7085_((AbstractSelectionList.Entry)new BooleanEntry((BooleanConfigOption)configOptionEntry.getValue(), text, index));
            } else {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Unsupported Config Type!");
            }
            this.configOptionToIndexForHasChanges.put(configOptionEntry.getValue(), index);
            ++index;
        }
        this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry(Component.m_237113_((String)"")));
        this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry(Side.CLIENT, (Component)Component.m_237115_((String)"pfm.option.regenAssets"), (Component)Component.m_237115_((String)"pfm.config.regen"), (Component)Component.m_237115_((String)"pfm.option.regenAssets.tooltip"), button -> {
            PFMFileUtil.deleteDir(PFMRuntimeResources.getAssetPackDirectory().toFile());
            PFMAssetGenerator.FROZEN = false;
            PFMRuntimeResources.prepareAndRunAssetGen(true);
            Minecraft.m_91087_().m_91088_();
        }));
        ButtonEntry entry = new ButtonEntry(Side.SERVER, (Component)Component.m_237115_((String)"pfm.option.regenData"), (Component)Component.m_237115_((String)"pfm.config.regen"), (Component)Component.m_237115_((String)"pfm.option.regenData.tooltip"), button -> {
            PFMFileUtil.deleteDir(PFMRuntimeResources.getDataPackDirectory().toFile());
            PFMDataGenerator.FROZEN = false;
            PFMRuntimeResources.prepareAndRunDataGen(true);
        });
        entry.button.f_93623_ = !PFMConfigScreen.isOnServer;
        this.m_7085_((AbstractSelectionList.Entry)entry);
    }

    public void save() {
        for (Map.Entry<AbstractConfigOption, Boolean> entry : this.newConfigValues.entrySet()) {
            if (entry.getKey().getType() != Boolean.class) continue;
            entry.getKey().setValue(entry.getValue());
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 15;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        final MutableComponent text;
        private final int textWidth;

        public CategoryEntry(MutableComponent text) {
            this.text = text;
            this.textWidth = ((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_.m_92852_((FormattedText)this.text);
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font font = ((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_;
            MutableComponent mutableComponent = this.text.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
            float f = ((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91080_.f_96543_ / 2 - this.textWidth / 2;
            Objects.requireNonNull(((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_);
            font.m_92889_(matrices, (Component)mutableComponent, f, (float)(y + entryHeight - 9 - 1), 0xFFFFFF);
        }

        public boolean m_5755_(boolean lookForwards) {
            return false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput builder) {
                    builder.m_169146_(NarratedElementType.TITLE, (Component)CategoryEntry.this.text);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BooleanEntry
    extends Entry {
        private final BooleanConfigOption configOption;
        private final Component optionName;
        private final Button valueButton;
        private final Button resetButton;
        private final Button.OnTooltip supplier;
        int index;
        boolean hasChanges = false;

        BooleanEntry(final BooleanConfigOption configOption, final Component optionName, int index) {
            this.configOption = configOption;
            this.optionName = optionName;
            this.index = index;
            this.supplier = new Button.OnTooltip(){
                final MutableComponent sideText;
                final MutableComponent styledTooltip;
                final MutableComponent combinedText;
                {
                    this.sideText = configOption.getSide() == Side.CLIENT ? Component.m_237115_((String)"pfm.option.client").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(true)).m_178520_(16219956)) : Component.m_237115_((String)"pfm.option.server").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(true)).m_178520_(16219956));
                    this.styledTooltip = ((MutableComponent)configOption.getToolTip()).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
                    this.combinedText = Component.m_237113_((String)"").m_7220_((Component)this.sideText).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)this.styledTooltip);
                }

                public void m_93752_(Button button, PoseStack matrices, int mouseX, int mouseY) {
                    PFMOptionListWidget.this.parent.m_96617_(matrices, ((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_.m_92923_((FormattedText)this.combinedText, Math.max(PFMOptionListWidget.this.f_93388_ / 2 - 43, 170)), mouseX, mouseY);
                }

                public void m_142753_(Consumer<Component> consumer) {
                    consumer.accept((Component)this.combinedText);
                    super.m_142753_(consumer);
                }
            };
            this.valueButton = new Button(0, 0, 75, 20, optionName, button -> {
                PFMOptionListWidget.this.parent.focusedConfigOption = configOption;
                PFMOptionListWidget.this.newConfigValues.put(configOption, PFMOptionListWidget.this.newConfigValues.get(configOption) == false);
                this.hasChanges = !this.hasChanges;
                PFMOptionListWidget.this.hasChanges.set(index, this.hasChanges);
            }, this.supplier);
            this.resetButton = new Button(0, 0, 50, 20, (Component)Component.m_237115_((String)"controls.reset"), button -> {
                PFMOptionListWidget.this.newConfigValues.put(configOption, configOption.getDefaultValue());
                this.hasChanges = true;
                PFMOptionListWidget.this.hasChanges.set(index, true);
            }){

                protected MutableComponent m_5646_() {
                    return Component.m_237110_((String)"narrator.controls.reset", (Object[])new Object[]{optionName});
                }
            };
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font font = ((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_;
            float f = x + 90 - PFMOptionListWidget.this.maxKeyNameLength;
            int n = y + entryHeight / 2;
            Objects.requireNonNull(((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_);
            font.m_92889_(matrices, this.optionName, f, (float)(n - 9 / 2), 0xFFFFFF);
            this.resetButton.f_93620_ = x + 190;
            this.resetButton.f_93621_ = y;
            this.resetButton.f_93623_ = this.configOption.getSide() == Side.SERVER ? !PFMConfigScreen.isOnServer && this.configOption.getDefaultValue() != PFMOptionListWidget.this.newConfigValues.get(this.configOption) : this.configOption.getDefaultValue() != PFMOptionListWidget.this.newConfigValues.get(this.configOption);
            this.resetButton.m_6305_(matrices, mouseX, mouseY, tickDelta);
            this.valueButton.f_93620_ = x + 105;
            this.valueButton.f_93621_ = y;
            this.valueButton.m_93666_(PFMOptionListWidget.this.newConfigValues.get(this.configOption) != false ? CommonComponents.f_130657_ : CommonComponents.f_130658_);
            this.valueButton.f_93623_ = this.configOption.getSide() != Side.SERVER || !PFMConfigScreen.isOnServer;
            this.valueButton.m_6305_(matrices, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.valueButton, (Object)this.resetButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.valueButton, (Object)this.resetButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.valueButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return this.resetButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.valueButton.m_6348_(mouseX, mouseY, button) || this.resetButton.m_6348_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ButtonEntry
    extends Entry {
        private final Component optionName;
        private final Button button;
        private final Button.OnTooltip supplier;
        private final Side side;

        ButtonEntry(final Side side, final Component optionName, Component buttonText, final Component tooltip, Button.OnPress pressAction) {
            this.optionName = optionName;
            this.side = side;
            this.supplier = new Button.OnTooltip(){
                final MutableComponent sideText;
                final MutableComponent styledTooltip;
                final MutableComponent combinedText;
                {
                    this.sideText = side == Side.CLIENT ? Component.m_237115_((String)"pfm.option.client").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(true)).m_178520_(16219956)) : Component.m_237115_((String)"pfm.option.server").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(true)).m_178520_(16219956));
                    this.styledTooltip = ((MutableComponent)tooltip).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)));
                    this.combinedText = Component.m_237113_((String)"").m_7220_((Component)this.sideText).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)this.styledTooltip);
                }

                public void m_93752_(Button button, PoseStack matrices, int mouseX, int mouseY) {
                    PFMOptionListWidget.this.parent.m_96617_(matrices, ((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_.m_92923_((FormattedText)this.combinedText, Math.max(PFMOptionListWidget.this.f_93388_ / 2 - 43, 170)), mouseX, mouseY);
                }

                public void m_142753_(Consumer<Component> consumer) {
                    consumer.accept((Component)this.combinedText);
                    super.m_142753_(consumer);
                }
            };
            this.button = new Button(0, 0, 135, 20, buttonText, pressAction, this.supplier){

                protected MutableComponent m_5646_() {
                    return (MutableComponent)optionName;
                }
            };
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Font font = ((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_;
            float f = x + 90 - PFMOptionListWidget.this.maxKeyNameLength;
            int n = y + entryHeight / 2;
            Objects.requireNonNull(((PFMOptionListWidget)PFMOptionListWidget.this).f_93386_.f_91062_);
            font.m_92889_(matrices, this.optionName, f, (float)(n - 9 / 2), 0xFFFFFF);
            this.button.f_93620_ = x + 105;
            this.button.f_93621_ = y;
            this.button.m_6305_(matrices, mouseX, mouseY, tickDelta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.button);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.button.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.button.m_6348_(mouseX, mouseY, button);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

