/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantHelper;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DynamicFurnitureRecipe
implements FurnitureRecipe {
    private final ResourceLocation id;
    private final String group;
    private final FurnitureOutput furnitureOutput;
    private final List<ResourceLocation> supportedVariants;
    private final FurnitureIngredients ingredients;
    Map<ResourceLocation, List<FurnitureInnerRecipe>> furnitureInnerRecipes = Maps.newHashMap();
    Map<ItemStack, FurnitureInnerRecipe> outputToInnerRecipe = new HashMap<ItemStack, FurnitureInnerRecipe>();
    Map<Item, FurnitureInnerRecipe> outputItemToInnerRecipe = new HashMap<Item, FurnitureInnerRecipe>();

    public DynamicFurnitureRecipe(ResourceLocation id, String group, FurnitureOutput furnitureOutput, List<ResourceLocation> supportedVariants, FurnitureIngredients furnitureIngredients) {
        this.id = id;
        this.group = group;
        this.furnitureOutput = furnitureOutput;
        this.supportedVariants = supportedVariants;
        this.ingredients = furnitureIngredients;
    }

    public void constructInnerRecipes() {
        if (!this.furnitureInnerRecipes.isEmpty()) {
            return;
        }
        for (ResourceLocation id : this.supportedVariants) {
            WoodVariant woodVariant;
            Optional<Block> optionalOutput;
            CompoundTag outputCompound;
            VariantBase<?> variant = VariantHelper.getVariant(id);
            if (variant == null || this.furnitureInnerRecipes.containsKey(id)) continue;
            CompoundTag compoundTag = outputCompound = this.furnitureOutput.nbt != null ? this.furnitureOutput.nbt.m_6426_() : null;
            if (outputCompound != null && outputCompound.m_128441_("color")) {
                optionalOutput = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariantAndColor(variant, DyeColor.m_41057_((String)outputCompound.m_128461_("color"), (DyeColor)DyeColor.WHITE));
                outputCompound.m_128473_("color");
            } else {
                optionalOutput = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariant(variant);
            }
            if (optionalOutput.isEmpty()) continue;
            if (outputCompound != null && outputCompound.m_128441_("variantInNbt") && outputCompound.m_128471_("variantInNbt")) {
                CompoundTag compound;
                if (outputCompound.m_128425_("BlockEntityTag", 10)) {
                    compound = outputCompound.m_128469_("BlockEntityTag");
                } else {
                    compound = new CompoundTag();
                    outputCompound.m_128365_("BlockEntityTag", (Tag)compound);
                }
                compound.m_128359_("variant", id.toString());
            }
            ItemStack output = new ItemStack((ItemLike)optionalOutput.get().m_5456_(), this.furnitureOutput.getOutputCount());
            if (outputCompound != null && !outputCompound.m_128456_()) {
                output.m_41751_(outputCompound.m_6426_());
            }
            Map<String, Integer> childrenToCountMap = this.ingredients.variantChildren;
            boolean abortVariant = false;
            ArrayList stacks = Lists.newArrayList();
            for (Map.Entry<String, Integer> entry : childrenToCountMap.entrySet()) {
                ItemLike convertible = variant.getItemForRecipe(entry.getKey(), this.getOutputBlockClass());
                if (convertible == null || convertible.m_5456_() == Items.f_41852_) {
                    abortVariant = true;
                    break;
                }
                stacks.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)convertible.m_5456_(), entry.getValue().intValue())}));
            }
            if (abortVariant) {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Skipped constructing inner recipe for variant {} on recipe {}", (Object)variant.identifier, (Object)this.furnitureOutput.outputClass);
                continue;
            }
            ArrayList<FurnitureInnerRecipe> recipes = new ArrayList<FurnitureInnerRecipe>();
            FurnitureInnerRecipe recipe = new FurnitureInnerRecipe(this, output, stacks);
            recipes.add(recipe);
            if (variant instanceof WoodVariant && (woodVariant = (WoodVariant)variant).hasStripped()) {
                Optional<Block> strippedOptional;
                ArrayList strippedIngredients = Lists.newArrayList();
                for (Map.Entry<String, Integer> entry : childrenToCountMap.entrySet()) {
                    strippedIngredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack(woodVariant.getItemForRecipe(entry.getKey(), this.getOutputBlockClass(), true), entry.getValue().intValue())}));
                }
                if (this.getOutputBlockClass() == RawLogTableBlock.class) {
                    strippedIngredients.set(0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(Block)woodVariant.getChild("stripped_log")}));
                }
                if ((strippedOptional = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariant(variant, true)).isPresent()) {
                    ItemStack strippedOutput = new ItemStack((ItemLike)strippedOptional.get(), this.furnitureOutput.getOutputCount());
                    if (outputCompound != null && !outputCompound.m_128456_()) {
                        output.m_41751_(outputCompound.m_6426_());
                    }
                    FurnitureInnerRecipe stripped = new FurnitureInnerRecipe(this, strippedOutput, strippedIngredients);
                    recipes.add(stripped);
                }
            }
            this.furnitureInnerRecipes.put(id, recipes);
        }
    }

    public boolean matches(Inventory inventory, Level world) {
        this.constructInnerRecipes();
        for (ResourceLocation id : this.furnitureInnerRecipes.keySet()) {
            List<FurnitureInnerRecipe> recipes = this.furnitureInnerRecipes.get(id);
            for (FurnitureInnerRecipe recipe : recipes) {
                if (!recipe.matches(inventory, world)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<FurnitureRecipe.CraftableFurnitureRecipe> getAvailableOutputs(Inventory inventory) {
        this.constructInnerRecipes();
        ArrayList stacks = Lists.newArrayList();
        for (ResourceLocation id : this.furnitureInnerRecipes.keySet()) {
            List<FurnitureInnerRecipe> recipes = this.furnitureInnerRecipes.get(id);
            for (FurnitureInnerRecipe recipe : recipes) {
                if (!recipe.matches(inventory, inventory.f_35978_.f_19853_)) continue;
                stacks.add(recipe);
            }
        }
        return stacks;
    }

    @Override
    public List<FurnitureRecipe.CraftableFurnitureRecipe> getInnerRecipes() {
        this.constructInnerRecipes();
        ArrayList<FurnitureRecipe.CraftableFurnitureRecipe> outputs = new ArrayList<FurnitureRecipe.CraftableFurnitureRecipe>();
        for (List<FurnitureInnerRecipe> recipes : this.furnitureInnerRecipes.values()) {
            outputs.addAll(recipes);
        }
        return outputs;
    }

    @Override
    public String outputClass() {
        return this.furnitureOutput.outputClass;
    }

    public ItemStack craft(Inventory inventory) {
        PaladinFurnitureMod.GENERAL_LOGGER.warn("Something has tried to craft a dynamic furniture recipe without context");
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        PaladinFurnitureMod.GENERAL_LOGGER.warn("Something has tried to get the output of a dynamic furniture recipe without context");
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeTypes.DYNAMIC_FURNITURE_SERIALIZER;
    }

    protected Class<? extends Block> getOutputBlockClass() {
        try {
            return Class.forName("com.unlikepaladin.pfm.blocks." + this.furnitureOutput.getOutputClass());
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ResourceLocation> getSupportedVariants() {
        return this.supportedVariants;
    }

    @Override
    public int getOutputCount() {
        return this.furnitureOutput.getOutputCount();
    }

    @Override
    public FurnitureRecipe.CraftableFurnitureRecipe getInnerRecipeFromOutput(ItemStack stack) {
        this.constructInnerRecipes();
        if (this.outputToInnerRecipe.containsKey(stack)) {
            return this.outputToInnerRecipe.get(stack);
        }
        return this.outputItemToInnerRecipe.get(stack.m_41720_());
    }

    @Override
    public int getMaxInnerRecipeSize() {
        return this.ingredients.vanillaIngredients.size() + this.ingredients.variantChildren.size();
    }

    @Override
    public List<? extends FurnitureRecipe.CraftableFurnitureRecipe> getInnerRecipesForVariant(ResourceLocation identifier) {
        this.constructInnerRecipes();
        if (this.furnitureInnerRecipes.containsKey(identifier)) {
            return this.furnitureInnerRecipes.get(identifier);
        }
        return List.of();
    }

    @Override
    public String getName() {
        return this.outputClass().replaceAll("(?<=[a-z])(?=[A-Z])", " ");
    }

    public static class FurnitureOutput {
        private final String outputClass;
        private final int outputCount;
        private final CompoundTag nbt;

        private FurnitureOutput(String outputClass, int outputCount, CompoundTag nbt) {
            this.outputClass = outputClass;
            this.outputCount = outputCount;
            this.nbt = nbt;
        }

        public int getOutputCount() {
            return this.outputCount;
        }

        public CompoundTag getNbt() {
            return this.nbt;
        }

        public String getOutputClass() {
            return this.outputClass;
        }

        public static FurnitureOutput read(JsonObject json) {
            CompoundTag nbtCompound = null;
            if (json.has("tag")) {
                nbtCompound = new CompoundTag();
                for (Map.Entry jsonObject : json.get("tag").getAsJsonObject().entrySet()) {
                    nbtCompound.m_128365_((String)jsonObject.getKey(), (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)jsonObject.getValue()));
                }
            }
            return new FurnitureOutput(GsonHelper.m_13906_((JsonObject)json, (String)"outputClass"), GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1), nbtCompound);
        }

        public static FurnitureOutput read(FriendlyByteBuf buf) {
            String outputClass = buf.m_130277_();
            int count = buf.readInt();
            CompoundTag nbt = buf.m_130260_();
            return new FurnitureOutput(outputClass, count, nbt);
        }

        public static void write(FriendlyByteBuf buf, FurnitureOutput output) {
            buf.m_130070_(output.outputClass);
            buf.writeInt(output.outputCount);
            buf.m_130079_(output.nbt);
        }
    }

    public static final class FurnitureIngredients {
        private final List<Ingredient> vanillaIngredients;
        private final Map<String, Integer> variantChildren;

        public FurnitureIngredients(List<Ingredient> vanillaIngredients, Map<String, Integer> variantChildren) {
            this.vanillaIngredients = vanillaIngredients;
            this.variantChildren = variantChildren;
        }

        public static FurnitureIngredients read(JsonObject json) {
            ArrayList<Ingredient> vanillaIngredients = new ArrayList<Ingredient>();
            json.getAsJsonArray("vanillaIngredients").forEach(element -> vanillaIngredients.add(Ingredient.m_43917_((JsonElement)element)));
            Map<String, Integer> variantChildren = FurnitureIngredients.readChildrenCount(json.get("variantChildren").getAsJsonObject());
            return new FurnitureIngredients(vanillaIngredients, variantChildren);
        }

        public static FurnitureIngredients read(FriendlyByteBuf buf) {
            List vanillaIngredients = (List)buf.m_236838_(Lists::newArrayListWithCapacity, Ingredient::m_43940_);
            Map variantChildren = buf.m_236847_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::readInt);
            return new FurnitureIngredients(vanillaIngredients, variantChildren);
        }

        private static Map<String, Integer> readChildrenCount(JsonObject json) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : json.entrySet()) {
                map.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
            }
            return map;
        }

        public static void write(FriendlyByteBuf buf, FurnitureIngredients ingredients) {
            buf.m_236828_(ingredients.vanillaIngredients, (packetByteBuf, ingredient) -> ingredient.m_43923_(buf));
            buf.m_236831_(ingredients.variantChildren, FriendlyByteBuf::m_130070_, FriendlyByteBuf::writeInt);
        }
    }

    public static final class FurnitureInnerRecipe
    implements FurnitureRecipe.CraftableFurnitureRecipe {
        private final DynamicFurnitureRecipe parentRecipe;
        private final ItemStack output;
        private final List<Ingredient> ingredients;
        private final List<Ingredient> combinedIngredients;

        public FurnitureInnerRecipe(DynamicFurnitureRecipe parentRecipe, ItemStack output, List<Ingredient> ingredients) {
            this.parentRecipe = parentRecipe;
            this.output = output;
            this.ingredients = ingredients;
            this.combinedIngredients = Lists.newArrayList();
            this.combinedIngredients.addAll(ingredients);
            this.combinedIngredients.addAll(parentRecipe.ingredients.vanillaIngredients);
            parentRecipe.outputToInnerRecipe.put(output, this);
            parentRecipe.outputItemToInnerRecipe.put(output.m_41720_(), this);
        }

        @Override
        public ItemStack m_8043_() {
            return this.output;
        }

        @Override
        public List<Ingredient> getIngredients() {
            return this.combinedIngredients;
        }

        @Override
        public boolean matches(Inventory inventory, Level world) {
            List<Ingredient> allIngredients = this.getIngredients();
            BitSet hasIngredient = new BitSet(allIngredients.size());
            block0: for (int i = 0; i < allIngredients.size(); ++i) {
                Ingredient ingredient = allIngredients.get(i);
                for (ItemStack stack : ingredient.m_43908_()) {
                    int countInInventory = inventory.m_18947_(stack.m_41720_());
                    if (countInInventory < stack.m_41613_()) continue;
                    hasIngredient.set(i, true);
                    continue block0;
                }
            }
            return hasIngredient.cardinality() == allIngredients.size();
        }

        @Override
        public FurnitureRecipe parent() {
            return this.parentRecipe;
        }

        @Override
        public ItemStack craft(Inventory inventory) {
            return this.output.m_41777_();
        }
    }

    public static class Serializer
    implements RecipeSerializer<DynamicFurnitureRecipe> {
        public DynamicFurnitureRecipe read(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ArrayList<ResourceLocation> supportedVariants = new ArrayList<ResourceLocation>();
            GsonHelper.m_13933_((JsonObject)json, (String)"supportedVariants").forEach(jsonElement -> supportedVariants.add(ResourceLocation.m_135820_((String)jsonElement.getAsString())));
            FurnitureIngredients ingredients = FurnitureIngredients.read(json.getAsJsonObject("ingredients"));
            return new DynamicFurnitureRecipe(id, group, FurnitureOutput.read(json.getAsJsonObject("result")), supportedVariants, ingredients);
        }

        public DynamicFurnitureRecipe read(ResourceLocation id, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            List supportedVariants = buf.m_236845_(FriendlyByteBuf::m_130281_);
            FurnitureIngredients ingredients = FurnitureIngredients.read(buf);
            FurnitureOutput output = FurnitureOutput.read(buf);
            return new DynamicFurnitureRecipe(id, group, output, supportedVariants, ingredients);
        }

        public void write(FriendlyByteBuf buf, DynamicFurnitureRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.m_236828_(recipe.supportedVariants, FriendlyByteBuf::m_130085_);
            FurnitureIngredients.write(buf, recipe.ingredients);
            FurnitureOutput.write(buf, recipe.furnitureOutput);
        }
    }
}

