/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface FurnitureRecipe
extends Recipe<Inventory> {
    default public RecipeType<?> m_6671_() {
        return RecipeTypes.FURNITURE_RECIPE;
    }

    public List<CraftableFurnitureRecipe> getInnerRecipes();

    public String outputClass();

    default public List<CraftableFurnitureRecipe> getAvailableOutputs(Inventory inventory) {
        return this.getInnerRecipes();
    }

    default public CraftableFurnitureRecipe getInnerRecipeFromOutput(ItemStack stack) {
        return this.getInnerRecipes().get(0);
    }

    public static int getSlotWithStackIgnoreNBT(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            if (((ItemStack)inventory.f_35974_.get(i)).m_41619_() || !stack.m_150930_(((ItemStack)inventory.f_35974_.get(i)).m_41720_())) continue;
            return i;
        }
        return -1;
    }

    default public int getMaxInnerRecipeSize() {
        return this.m_7527_().size();
    }

    default public int getOutputCount() {
        return this.m_8043_().m_41613_();
    }

    default public List<? extends CraftableFurnitureRecipe> getInnerRecipesForVariant(ResourceLocation identifier) {
        return Collections.singletonList(this.getInnerRecipes().get(0));
    }

    default public String getName() {
        return this.m_8043_().m_41786_().getString();
    }

    public static interface CraftableFurnitureRecipe
    extends Comparable<CraftableFurnitureRecipe> {
        public List<Ingredient> getIngredients();

        public ItemStack m_8043_();

        public ItemStack craft(Inventory var1);

        public boolean matches(Inventory var1, Level var2);

        public FurnitureRecipe parent();

        @Override
        default public int compareTo(@NotNull CraftableFurnitureRecipe o) {
            return this.m_8043_().toString().compareTo(o.m_8043_().toString());
        }

        default public ItemStack craftAndRemoveItems(Inventory playerInventory) {
            ItemStack output = this.m_8043_().m_41777_();
            List<Ingredient> ingredients = this.getIngredients();
            block0: for (Ingredient ingredient : ingredients) {
                for (ItemStack stack : ingredient.m_43908_()) {
                    int indexOfStack = FurnitureRecipe.getSlotWithStackIgnoreNBT(playerInventory, stack);
                    int count = stack.m_41613_();
                    if (indexOfStack == -1) continue;
                    if (playerInventory.m_8020_(indexOfStack).m_41613_() >= stack.m_41613_()) {
                        ItemStack stack1 = playerInventory.m_8020_(indexOfStack);
                        stack1.m_41774_(stack.m_41613_());
                        playerInventory.m_6836_(indexOfStack, stack1);
                        playerInventory.m_6596_();
                        continue block0;
                    }
                    int remainingCount = count - playerInventory.m_8020_(indexOfStack).m_41613_();
                    playerInventory.m_6836_(indexOfStack, ItemStack.f_41583_);
                    while (remainingCount > 0) {
                        indexOfStack = FurnitureRecipe.getSlotWithStackIgnoreNBT(playerInventory, stack);
                        if (indexOfStack != -1) {
                            ItemStack stack1 = playerInventory.m_8020_(indexOfStack);
                            if (stack1.m_41613_() >= remainingCount) {
                                stack1.m_41774_(remainingCount);
                                playerInventory.m_6836_(indexOfStack, stack1);
                                break;
                            }
                            int stackSize = stack1.m_41613_();
                            remainingCount = Math.max(remainingCount - stackSize, 0);
                            playerInventory.m_6836_(indexOfStack, ItemStack.f_41583_);
                            continue;
                        }
                        PaladinFurnitureMod.GENERAL_LOGGER.warn("Unable to craft recipe, this should never happen");
                        return ItemStack.f_41583_;
                    }
                    playerInventory.m_6596_();
                }
            }
            return output;
        }
    }
}

