/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.assets;

import com.google.gson.JsonElement;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSinkBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskCabinetBlock;
import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicBedBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.ClassicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicNightstandBlock;
import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.blocks.ClassicTableBlock;
import com.unlikepaladin.pfm.blocks.DinnerChairBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.KitchenCabinetBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.ModernChairBlock;
import com.unlikepaladin.pfm.blocks.ModernCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ModernDinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ModernStoolBlock;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.SimpleBunkLadderBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.blocks.models.basicLamp.UnbakedBasicLampModel;
import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMTextureKeyFactory;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.TriFunc;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PFMBlockstateModelProvider
extends PFMProvider {
    public static Map<Block, ResourceLocation> modelPathMap = new HashMap<Block, ResourceLocation>();

    public PFMBlockstateModelProvider(PFMGenerator parent) {
        super(parent, "PFM Blockstates and Models");
        parent.setProgress("Generating Blockstates and Models");
    }

    @Override
    public void run() {
        this.startProviderRun();
        this.createWriter();
        Path path = this.getParent().getOutput();
        Consumer<BlockStateGenerator> blockStateSupplierConsumer = blockStateSupplier -> {
            Path jsonPath = PFMBlockstateModelProvider.getBlockStateJsonPath(path, blockStateSupplier.m_6968_());
            String jsonContent = PFMDataGenerator.GSON.toJson((JsonElement)blockStateSupplier.get());
            this.enqueueJsonWrite(this.getWriteQueue(), jsonPath, jsonContent);
        };
        BiConsumer<ResourceLocation, Supplier<JsonElement>> identifierSupplierBiConsumer = (identifier, supplier) -> {
            Path jsonPath = PFMBlockstateModelProvider.getModelJsonPath(path, identifier);
            String jsonContent = PFMDataGenerator.GSON.toJson((JsonElement)supplier.get());
            this.enqueueJsonWrite(this.getWriteQueue(), jsonPath, jsonContent);
        };
        HashSet models = new HashSet();
        new PFMBlockStateModelGenerator(this, blockStateSupplierConsumer, identifierSupplierBiConsumer).registerModelsAndStates();
        modelPathMap.keySet().forEach(block -> {
            ResourceLocation identifier;
            Item item = (Item)Item.f_41373_.get(block);
            if (item != null && !models.contains(identifier = ModelLocationUtils.m_125571_((Item)item))) {
                Path jsonPath = PFMBlockstateModelProvider.getModelJsonPath(path, identifier);
                this.enqueueJsonWrite(this.getWriteQueue(), jsonPath, new DelegatedModel(modelPathMap.get(block)).get());
                models.add(identifier);
            }
        });
        this.waitForWrite();
        this.endProviderRun();
    }

    private static Path getBlockStateJsonPath(Path root, Block block) {
        ResourceLocation identifier = Registry.f_122824_.m_7981_((Object)block);
        return root.resolve("assets/" + identifier.m_135827_() + "/blockstates/" + identifier.m_135815_() + ".json");
    }

    private static Path getModelJsonPath(Path root, ResourceLocation id) {
        return root.resolve("assets/" + id.m_135827_() + "/models/" + id.m_135815_() + ".json");
    }

    static class PFMBlockStateModelGenerator {
        public static Map<ModelTemplate, ResourceLocation> ModelIDS = new HashMap<ModelTemplate, ResourceLocation>();
        final Consumer<BlockStateGenerator> blockStateCollector;
        final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector;
        final List<ResourceLocation> generatedStates = new ArrayList<ResourceLocation>();
        final PFMBlockstateModelProvider provider;
        public static final TextureSlot LOG_KEY = PFMBlockStateModelGenerator.of("log");
        public static final TextureSlot LOG_TOP_KEY = PFMBlockStateModelGenerator.of("log_top");
        public static final ModelTemplate[] TEMPLATE_CHAIR = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair/template_chair", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("chair/template_chair", "_tucked", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CHAIR_DINNER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair_dinner/template_chair_dinner", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("chair_dinner/template_chair_dinner", "_tucked", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CHAIR_CLASSIC = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair_classic/template_chair_classic", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("chair_classic/template_chair_classic", "_tucked", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CHAIR_MODERN = new ModelTemplate[]{PFMBlockStateModelGenerator.block("chair_modern/template_chair_modern", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("chair_modern/template_chair_modern", "_tucked", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_LOG_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("log_stool/log_stool", LOG_KEY, LOG_TOP_KEY), PFMBlockStateModelGenerator.block("log_stool/log_stool", "_tucked", LOG_KEY, LOG_TOP_KEY)};
        public static final ModelTemplate[] TEMPLATE_SIMPLE_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("simple_stool/simple_stool", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("simple_stool/simple_stool", "_tucked", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("classic_stool/classic_stool", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_stool/classic_stool", "_tucked", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_MODERN_STOOL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("modern_stool/modern_stool", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("modern_stool/modern_stool", "_tucked", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_BASIC_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("table_basic/table_basic", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_base", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_east", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_west", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_east", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_west", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_east_top", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_west_top", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_east_west_north", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_east_west_south", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_east_bottom", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_west_bottom", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_east", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_south_west", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_east_corner", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_north_west_corner", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_east_corner", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_basic/table_basic_south_west_corner", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("table_classic/table_classic", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_middle", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_one_uved", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_one", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_two_uved", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_classic/table_classic_two", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_LOG_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("log_table/log_table", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("log_table/log_table_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("log_table/log_table_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("log_table/log_table_middle", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_DINNER_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("dinner_table/dinner_table", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("dinner_table/dinner_table_middle", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("dinner_table/dinner_table_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("dinner_table/dinner_table_left", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_MODERN_DINNER_TABLE_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner_middle", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("table_modern_dinner/table_modern_dinner_left", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_NIGHTSTAND_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_middle", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_middle_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_right_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("classic_nightstand/classic_nightstand_left_open", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_SIMPLE_BED_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("simple_bed/template/full/simple_bed_white", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/head/simple_bed_head", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/head/simple_bed_head_left", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/head/simple_bed_head_right", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/foot/simple_bed_foot", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/foot/simple_bed_foot_right", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/foot/simple_bed_foot_left", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/bunk/foot/simple_bed_foot_left", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/bunk/foot/simple_bed_foot_right", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bed/template/bunk/head/simple_bed_head", TextureSlot.f_125868_)};
        public static final ModelTemplate[] TEMPLATE_CLASSIC_BED_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("classic_bed/template/full/classic_bed_white", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/head/classic_bed_head", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/head/classic_bed_head_left", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/head/classic_bed_head_right", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/foot/classic_bed_foot", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/foot/classic_bed_foot_right", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/foot/classic_bed_foot_left", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/bunk/foot/classic_bed_foot_left", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("classic_bed/template/bunk/foot/classic_bed_foot_right", TextureSlot.f_125868_)};
        public static final ModelTemplate[] TEMPLATE_SIMPLE_BUNK_LADDER_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("simple_bunk_ladder/template/simple_ladder", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("simple_bunk_ladder/template/simple_ladder_top", TextureSlot.f_125868_)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_COUNTER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_edge_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_edge_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_inner_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_inner_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_outer_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_outer_corner_left", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_DRAWER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_inner_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_inner_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_left_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_edge_right_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_open_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_outer_corner_open_left", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_CABINET = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_open_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_inner_corner_open_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_open_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_cabinet/kitchen_cabinet_outer_corner_open_left", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_WALL_DRAWER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_inner_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_inner_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_open_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_drawer/kitchen_drawer_middle_outer_corner_open_left", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_WALL_COUNTER = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_inner_corner_left", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_inner_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_outer_corner_right", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter/kitchen_counter_middle_outer_corner_left", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_WALL_DRAWER_SMALL = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_wall_drawer_small/kitchen_wall_drawer_small", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_wall_drawer_small/kitchen_wall_drawer_small", "_open", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_COUNTER_OVEN = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven_middle", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven", "_open", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_counter_oven/kitchen_counter_oven_middle", "_open", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_KITCHEN_SINK = new ModelTemplate[]{PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink_level1", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink_level2", TextureSlot.f_125868_, LOG_KEY), PFMBlockStateModelGenerator.block("kitchen_sink/kitchen_sink_full", TextureSlot.f_125868_, LOG_KEY)};
        public static final ModelTemplate[] TEMPLATE_LAMP_ARRAY = new ModelTemplate[]{PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_bottom", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_middle", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_single", TextureSlot.f_125868_), PFMBlockStateModelGenerator.block("basic_lamp/basic_lamp_top", TextureSlot.f_125868_)};

        PFMBlockStateModelGenerator(PFMBlockstateModelProvider provider, Consumer<BlockStateGenerator> blockStateCollector, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelCollector) {
            this.provider = provider;
            this.blockStateCollector = blockStateCollector;
            this.modelCollector = modelCollector;
        }

        public void registerModelsAndStates() {
            this.provider.getParent().log("Generating Chairs and Stools");
            this.registerTuckableChairs();
            this.provider.getParent().log("Generating Tables");
            this.registerTables();
            this.provider.getParent().log("Generating Nightstands Chairs");
            this.registerNightStands();
            this.provider.getParent().log("Generating Beds");
            this.registerBeds();
            this.provider.getParent().log("Generating Bunk Ladders");
            this.registerLadders();
            this.provider.getParent().log("Generating Kitchen Counters");
            this.registerCounters();
            this.provider.getParent().log("Generating Lamps");
            this.registerLamp();
            this.provider.getParent().log("Generating Desks");
            this.registerDesks();
        }

        public void registerTuckableChairs() {
            this.provider.getParent().log("Basic Chairs");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMap(), "chair", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMapNonBase(), "chair", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Dining Chairs");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMap(), "chair_dinner", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMapNonBase(), "chair_dinner", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Modern Chairs");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMap(), "chair_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMapNonBase(), "chair_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Classic Chairs");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMap(), "chair_classic", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMapNonBase(), "chair_classic", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Log Stools");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(LogStoolBlock.class).getVariantToBlockMap(), "log_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Simple Stools");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMap(), "simple_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMapNonBase(), "simple_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Classic Stools");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMap(), "classic_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMapNonBase(), "classic_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Modern Stools");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMap(), "modern_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMapNonBase(), "modern_stool", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
        }

        public void registerTables() {
            this.provider.getParent().log("Basic Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMap(), "table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMapNonBase(), "table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.provider.getParent().log("Classic Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMap(), "table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMapNonBase(), "table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.provider.getParent().log("Log Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMap(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMapNonBase(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.provider.getParent().log("Raw Log Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMap(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMapNonBase(), "log_table", PFMBlockStateModelGenerator::createOrientableTableBlockState);
            this.provider.getParent().log("Dining Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMap(), "dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMapNonBase(), "dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Modern Dining Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMap(), "modern_dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMapNonBase(), "modern_dinner_table", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Basic Coffee Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMap(), "coffee_table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMapNonBase(), "coffee_table_basic", PFMBlockStateModelGenerator::createAxisOrientableTableBlockState);
            this.provider.getParent().log("Modern Coffee Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMap(), "coffee_table_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMapNonBase(), "coffee_table_modern", (block, identifiers) -> PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, identifiers, 90));
            this.provider.getParent().log("Classic Coffee Tables");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMap(), "coffee_table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMapNonBase(), "coffee_table_classic", PFMBlockStateModelGenerator::createSingleStateBlockState);
        }

        public void registerDesks() {
            this.provider.getParent().log("Basic Desks");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskBlock.class).getVariantToBlockMap(), "desk_basic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskBlock.class).getVariantToBlockMapNonBase(), "desk_basic", PFMBlockStateModelGenerator::createSingleStateBlockState);
            this.provider.getParent().log("Basic Desk Cabinets");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskCabinetBlock.class).getVariantToBlockMap(), "desk_cabinet_basic", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskCabinetBlock.class).getVariantToBlockMapNonBase(), "desk_cabinet_basic", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
        }

        public void registerNightStands() {
            this.provider.getParent().log("Classic Nightstands");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMap(), "classic_nightstand", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMapNonBase(), "classic_nightstand", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableTableBlockState(block, identifiers, 90));
        }

        public void registerBeds() {
            this.provider.getParent().log("Simple Beds");
            this.generateModelAndBlockStateForBed(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariantToBlockMapList(), "simple_bed", PFMBlockStateModelGenerator::createBedBlockState);
            this.provider.getParent().log("Classic Beds");
            this.generateModelAndBlockStateForBed(PaladinFurnitureMod.furnitureEntryMap.get(ClassicBedBlock.class).getVariantToBlockMapList(), "simple_bed", PFMBlockStateModelGenerator::createBedBlockState);
        }

        public void registerLadders() {
            this.provider.getParent().log("Simple Bunk Ladders");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBunkLadderBlock.class).getVariantToBlockMap(), "simple_bunk_ladder", PFMBlockStateModelGenerator::createOrientableTableBlockState);
        }

        public void registerCounters() {
            this.provider.getParent().log("Kitchen Counters");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMap(), "kitchen_counter", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMapNonBase(), "kitchen_counter", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.provider.getParent().log("Kitchen Drawers");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMap(), "kitchen_drawer", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMapNonBase(), "kitchen_drawer", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.provider.getParent().log("Kitchen Cabinets");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMap(), "kitchen_cabinet", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMapNonBase(), "kitchen_cabinet", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.provider.getParent().log("Kitchen Wall Drawers");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMap(), "kitchen_wall_drawer", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMapNonBase(), "kitchen_wall_drawer", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.provider.getParent().log("Kitchen Wall Cabinets");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMap(), "kitchen_wall_counter", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMapNonBase(), "kitchen_wall_counter", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.provider.getParent().log("Small Kitchen Cabinets");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMap(), "kitchen_wall_small_drawer", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMapNonBase(), "kitchen_wall_small_drawer", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.provider.getParent().log("Kitchen Counter Ovens");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMap(), "kitchen_counter_oven", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableUvLockedBlock(block, identifiers, "", "", "", 180));
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMapNonBase(), "kitchen_counter_oven", (block, identifiers) -> PFMBlockStateModelGenerator.createOrientableUvLockedBlock(block, identifiers, "", "", "", 180));
            this.provider.getParent().log("Kitchen Sinks");
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMap(), "kitchen_sink", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
            this.generateBlockStateForBlock(PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMapNonBase(), "kitchen_sink", PFMBlockStateModelGenerator::createOrientableUvLockedBlock);
        }

        public void registerLamp() {
            this.provider.getParent().log("Basic Lamps");
            ResourceLocation modelID = ModelLocationUtils.m_125576_((Block)PaladinFurnitureModBlocksItems.BASIC_LAMP);
            this.blockStateCollector.accept(PFMBlockStateModelGenerator.createSingleStateBlockState(PaladinFurnitureModBlocksItems.BASIC_LAMP, List.of(modelID)));
            modelPathMap.put(PaladinFurnitureModBlocksItems.BASIC_LAMP, UnbakedBasicLampModel.getItemModelId());
        }

        public static TextureMapping createPlankBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation top = ModelHelper.getTextureId(variantBase.getBaseBlock());
            ResourceLocation legs = ModelHelper.getTextureId(variantBase.getBaseBlock());
            return new TextureMapping().m_125758_(TextureSlot.f_125868_, top).m_125758_(LOG_KEY, legs);
        }

        public static TextureMapping createRawBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation top = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            ResourceLocation legs = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            return new TextureMapping().m_125758_(TextureSlot.f_125868_, top).m_125758_(LOG_KEY, legs);
        }

        public static TextureMapping createPlankLogBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation top = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getBaseBlock());
            ResourceLocation legs = stripped != false ? ModelHelper.getTextureId(variantBase.getBaseBlock()) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            return new TextureMapping().m_125758_(TextureSlot.f_125868_, top).m_125758_(LOG_KEY, legs);
        }

        public static TextureMapping createCounterBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation counterTop;
            ResourceLocation counterBase = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getBaseBlock());
            ResourceLocation resourceLocation = counterTop = stripped != false ? ModelHelper.getTextureId(variantBase.getBaseBlock()) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            if (variantBase.identifier.m_135815_().equals("granite")) {
                counterTop = ModelHelper.getTextureId(Blocks.f_50175_);
                counterBase = ModelHelper.getTextureId(Blocks.f_50287_);
            } else if (variantBase.identifier.m_135815_().equals("calcite") || variantBase.identifier.m_135815_().equals("netherite")) {
                ResourceLocation temp = counterBase;
                counterBase = counterTop;
                counterTop = temp;
            } else if (variantBase.identifier.m_135815_().equals("andesite")) {
                counterTop = ModelHelper.getTextureId(Blocks.f_50387_);
                counterBase = ModelHelper.getTextureId(Blocks.f_50010_);
            } else if (variantBase.identifier.m_135815_().equals("deepslate")) {
                counterTop = ModelHelper.getTextureId(Blocks.f_152555_);
                counterBase = ModelHelper.getTextureId(Blocks.f_50745_);
            } else if (variantBase.identifier.m_135815_().equals("blackstone")) {
                counterTop = ModelHelper.getTextureId(Blocks.f_50734_);
                counterBase = ModelHelper.getTextureId(Blocks.f_50655_);
            }
            return new TextureMapping().m_125758_(TextureSlot.f_125868_, counterBase).m_125758_(LOG_KEY, counterTop);
        }

        public static TextureMapping createLogLogTopBlockTexture(Boolean stripped, VariantBase<?> variantBase) {
            ResourceLocation legs = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log")) : ModelHelper.getTextureId(variantBase.getSecondaryBlock());
            ResourceLocation top = stripped != false ? ModelHelper.getTextureId((Block)variantBase.getChild("stripped_log"), "_top") : ModelHelper.getTextureId(variantBase.getSecondaryBlock(), "_top");
            return new TextureMapping().m_125758_(LOG_KEY, legs).m_125758_(LOG_TOP_KEY, top);
        }

        public void generateBlockStateForBlock(Map<VariantBase<?>, ? extends Block> variantBaseHashMap, String blockName, BiFunction<Block, List<ResourceLocation>, BlockStateGenerator> stateSupplierBiFunction) {
            variantBaseHashMap.forEach((variantBase, block) -> {
                if (!this.generatedStates.contains(Registry.f_122824_.m_7981_(block))) {
                    ResourceLocation modelID = ModelLocationUtils.m_125576_((Block)block);
                    ResourceLocation id = new ResourceLocation(modelID.m_135827_(), "block/" + blockName);
                    ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(1);
                    ids.add(id);
                    this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply((Block)block, (List<ResourceLocation>)ids));
                    this.generatedStates.add(Registry.f_122824_.m_7981_(block));
                }
            });
        }

        public void generateModelAndBlockStateForBed(HashMap<VariantBase<?>, ? extends Set<?>> variantBaseHashMap, String blockName, BiFunction<Block, List<ResourceLocation>, BlockStateGenerator> stateSupplierBiFunction) {
            variantBaseHashMap.forEach((variantBase, blockList) -> blockList.forEach(block1 -> {
                Block block = (Block)block1;
                if (!this.generatedStates.contains(Registry.f_122824_.m_7981_((Object)block))) {
                    ResourceLocation modelID = ModelLocationUtils.m_125576_((Block)block);
                    ResourceLocation id = new ResourceLocation(modelID.m_135827_(), "block/" + blockName);
                    ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(1);
                    ids.add(id);
                    this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply(block, ids));
                    this.generatedStates.add(Registry.f_122824_.m_7981_((Object)block));
                }
            }));
        }

        public void generateModelAndBlockStateForVariants(Map<VariantBase<?>, ? extends Block> variantBaseHashMap, String blockName, ModelTemplate[] models, BiFunction<Block, List<ResourceLocation>, BlockStateGenerator> stateSupplierBiFunction, BiFunction<Boolean, VariantBase<?>, TextureMapping> textureBiFunction) {
            variantBaseHashMap.forEach((variantBase, block) -> {
                if (!this.generatedStates.contains(Registry.f_122824_.m_7981_(block))) {
                    String strippedprefix;
                    String blockName2 = blockName;
                    boolean stripped = block.m_7705_().contains("stripped");
                    TextureMapping blockTexture = (TextureMapping)textureBiFunction.apply(stripped, (VariantBase<?>)variantBase);
                    ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
                    String string = strippedprefix = stripped ? "stripped_" : "";
                    if (block instanceof RawLogTableBlock) {
                        blockName2 = "raw_log_table";
                    }
                    if (variantBase instanceof StoneVariant && block instanceof LogTableBlock) {
                        blockName2 = blockName2.replace("log", "natural");
                    } else if (variantBase.isNetherWood() && block instanceof LogTableBlock) {
                        blockName2 = blockName2.replace("log", "stem");
                    }
                    ResourceLocation modelID = ModelLocationUtils.m_125576_((Block)block);
                    for (ModelTemplate model : models) {
                        ResourceLocation id = new ResourceLocation(modelID.m_135827_(), ModelIDS.get(model).m_135815_().replace("template_", "").replace("template", "").replaceAll(blockName, strippedprefix + variantBase.m_7912_() + "_" + blockName2).replace("block/", "block/" + blockName + "/").replace("//", "/"));
                        model.m_125612_(id, blockTexture, this.modelCollector);
                        ids.add(id);
                    }
                    this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply((Block)block, (List<ResourceLocation>)ids));
                    modelPathMap.put((Block)block, (ResourceLocation)ids.get(0));
                    this.generatedStates.add(Registry.f_122824_.m_7981_(block));
                }
            });
        }

        public void generateModelAndBlockStateForBed(HashMap<VariantBase<?>, ? extends List<?>> variantBaseHashMap, String blockName, ModelTemplate[] models, TriFunc<Block, List<ResourceLocation>, String, BlockStateGenerator> stateSupplierBiFunction, BiFunction<Boolean, VariantBase<?>, TextureMapping> textureBiFunction) {
            variantBaseHashMap.forEach((variantBase, blockList) -> {
                ArrayList allids = new ArrayList();
                blockList.forEach(block1 -> {
                    Block block = (Block)block1;
                    if (!this.generatedStates.contains(Registry.f_122824_.m_7981_((Object)block))) {
                        boolean stripped = block.m_7705_().contains("stripped");
                        TextureMapping blockTexture = (TextureMapping)textureBiFunction.apply(stripped, (VariantBase<?>)variantBase);
                        ResourceLocation modelID = ModelLocationUtils.m_125576_((Block)block);
                        String color = block instanceof SimpleBedBlock ? ((SimpleBedBlock)block).getPFMColor().m_7912_() : "";
                        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
                        for (ModelTemplate model : models) {
                            ResourceLocation id = new ResourceLocation(modelID.m_135827_(), ModelIDS.get(model).m_135815_().replaceAll("white", color).replaceAll("template", variantBase.m_7912_()));
                            if (allids.contains(id)) continue;
                            if (model == models[0]) {
                                PFMBlockStateModelGenerator.block(blockName + "/template/full/" + blockName + "_" + color, TextureSlot.f_125868_).m_125612_(id, blockTexture, this.modelCollector);
                            } else {
                                model.m_125612_(id, blockTexture, this.modelCollector);
                            }
                            ids.add(id);
                        }
                        allids.addAll(ids);
                        this.blockStateCollector.accept((BlockStateGenerator)stateSupplierBiFunction.apply(block, ids, color));
                        modelPathMap.put(block, (ResourceLocation)ids.get(0));
                        this.generatedStates.add(Registry.f_122824_.m_7981_((Object)block));
                    }
                });
            });
        }

        private static ModelTemplate make(TextureSlot ... requiredTextures) {
            return new ModelTemplate(Optional.empty(), Optional.empty(), requiredTextures);
        }

        private static ModelTemplate block(String parent, TextureSlot ... requiredTextures) {
            ResourceLocation id = new ResourceLocation("pfm", "block/" + parent);
            ModelTemplate model = new ModelTemplate(Optional.of(id), Optional.empty(), requiredTextures);
            ModelIDS.put(model, id);
            return model;
        }

        private static ModelTemplate item(String parent, TextureSlot ... requiredTextures) {
            return new ModelTemplate(Optional.of(new ResourceLocation("pfm", "item/" + parent)), Optional.empty(), requiredTextures);
        }

        private static ModelTemplate block(String parent, String variant, TextureSlot ... requiredTextures) {
            ResourceLocation id = new ResourceLocation("pfm", "block/" + parent + variant);
            ModelTemplate model = new ModelTemplate(Optional.of(id), Optional.of(variant), requiredTextures);
            ModelIDS.put(model, id);
            return model;
        }

        private static TextureSlot of(String name) {
            return PFMTextureKeyFactory.newTextureKey(name, null);
        }

        private static TextureSlot of(String name, TextureSlot parent) {
            return PFMTextureKeyFactory.newTextureKey(name, parent);
        }

        private static BlockStateGenerator createSingleStateBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            String path = modelIdentifiers.get(0).m_135815_();
            ResourceLocation id = new ResourceLocation(modelIdentifiers.get(0).m_135827_(), path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47)));
            Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id);
            return MultiVariantGenerator.m_125256_((Block)block, (Variant)variant);
        }

        private static BlockStateGenerator createAxisOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers, int rotation) {
            HashMap<Direction.Axis, Variant> variantMap = new HashMap<Direction.Axis, Variant>();
            String path = modelIdentifiers.get(0).m_135815_();
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : new ResourceLocation(modelIdentifiers.get(0).m_135827_(), path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47)));
            Integer[] rotationArray = new Integer[]{0, 90};
            for (int i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 90) {
                    if (rotationArray[i] == 90) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            variantMap.put(Direction.Axis.Z, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
            variantMap.put(Direction.Axis.X, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61364_).m_125335_(axis -> {
                for (Direction.Axis axis1 : variantMap.keySet()) {
                    if (!axis.equals((Object)axis1)) continue;
                    return (Variant)variantMap.get(axis1);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createAxisOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createAxisOrientableTableBlockState(block, modelIdentifiers, 0);
        }

        private static BlockStateGenerator createOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createOrientableTableBlockState(block, modelIdentifiers, 0);
        }

        private static BlockStateGenerator createOrientableTableBlockState(Block block, List<ResourceLocation> modelIdentifiers, int rotation) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            String path = modelIdentifiers.get(0).m_135815_();
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : new ResourceLocation(modelIdentifiers.get(0).m_135827_(), path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47)));
            Integer[] rotationArray = new Integer[]{0, 90, 180, 270};
            for (int i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 270) {
                    if (rotationArray[i] == 270) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            variantMap.put(Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
            variantMap.put(Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
            variantMap.put(Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))));
            variantMap.put(Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))));
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125335_(facing -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createOrientableUvLockedBlock(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createOrientableUvLockedBlock(block, modelIdentifiers, "", "", "", 0);
        }

        private static BlockStateGenerator createOrientableUvLockedBlock(Block block, List<ResourceLocation> modelIdentifiers, String override, String furnitureName, String replacement, int rotation) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            String path = modelIdentifiers.get(0).m_135815_().replaceAll(override, "");
            String name = path.split(path.substring(path.lastIndexOf(47)))[0] + path.substring(path.lastIndexOf(47));
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : new ResourceLocation(modelIdentifiers.get(0).m_135827_(), name.replace(furnitureName, replacement));
            Integer[] rotationArray = new Integer[]{0, 90, 180, 270};
            for (int i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 270) {
                    if (rotationArray[i] == 180) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            variantMap.put(Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMap.put(Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMap.put(Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMap.put(Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125335_(facing -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createKitchenSink(Block block, List<ResourceLocation> modelIdentifiers) {
            HashMap<Direction, VariantProperties.Rotation> rotationMap = new HashMap<Direction, VariantProperties.Rotation>();
            Integer[] rotation = new Integer[]{0, 90, 180, 270};
            rotationMap.put(Direction.NORTH, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[0]))));
            rotationMap.put(Direction.EAST, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[1]))));
            rotationMap.put(Direction.SOUTH, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[2]))));
            rotationMap.put(Direction.WEST, VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[3]))));
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61374_, (Property)AbstractSinkBlock.LEVEL_4).m_125362_((facing, level) -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)((ResourceLocation)modelIdentifiers.get((int)level))).m_125511_(VariantProperties.f_125519_, (Object)((VariantProperties.Rotation)rotationMap.get(facing))).m_125511_(VariantProperties.f_125521_, (Object)true)));
        }

        private static BlockStateGenerator createSmallKitchenDrawer(Block block, List<ResourceLocation> modelIdentifiers, String override, String furnitureName, String replacement) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            HashMap<Direction, Variant> variantMapOpen = new HashMap<Direction, Variant>();
            Integer[] rotation = new Integer[]{0, 90, 180, 270};
            variantMap.put(Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[0])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMap.put(Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[1])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMap.put(Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[2])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMap.put(Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[3])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMapOpen.put(Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[0])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMapOpen.put(Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[1])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMapOpen.put(Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[2])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            variantMapOpen.put(Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotation[3])))).m_125511_(VariantProperties.f_125521_, (Object)true));
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61446_).m_125362_((facing, open) -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return open != false ? (Variant)variantMapOpen.get(direction) : (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createLadderBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            Condition.TerminalCondition northFalse = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition northTrue = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true));
            Condition.TerminalCondition eastFalse = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition eastTrue = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true));
            Condition.TerminalCondition westFalse = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition westTrue = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true));
            Condition.TerminalCondition southFalse = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false));
            Condition.TerminalCondition southTrue = Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true));
            return MultiPartGenerator.m_125204_((Block)block).m_125209_((Condition)northFalse, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0))).m_125209_((Condition)northTrue, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1))).m_125209_((Condition)eastFalse, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)eastTrue, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)westFalse, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125209_((Condition)westTrue, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125209_((Condition)southFalse, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(0)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125209_((Condition)southTrue, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelIdentifiers.get(1)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180));
        }

        private static BlockStateGenerator createBedBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            HashMap<Direction, Variant> variantMap = new HashMap<Direction, Variant>();
            ResourceLocation id = modelIdentifiers.size() == 1 ? modelIdentifiers.get(0) : ModelLocationUtils.m_125576_((Block)block);
            Integer[] rotationArray = new Integer[]{0, 90, 180, 270};
            variantMap.put(Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
            variantMap.put(Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
            variantMap.put(Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))));
            variantMap.put(Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))));
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125335_(facing -> {
                for (Direction direction : variantMap.keySet()) {
                    if (!facing.equals((Object)direction)) continue;
                    return (Variant)variantMap.get(direction);
                }
                return null;
            }));
        }

        private static BlockStateGenerator createOrientableTuckableBlockState(Block block, List<ResourceLocation> modelIdentifiers) {
            return PFMBlockStateModelGenerator.createOrientableTuckableBlockState(block, modelIdentifiers, 0);
        }

        private static BlockStateGenerator createOrientableTuckableBlockState(Block block, List<ResourceLocation> modelIdentifiers, int rotation) {
            int i;
            HashMap<TuckableVariant, Variant> variantList = new HashMap<TuckableVariant, Variant>();
            Integer[] rotationArray = new Integer[]{90, 270, 180, 0};
            for (i = 0; rotationArray.length > i; ++i) {
                if (rotationArray[i] + rotation > 270) {
                    if (rotationArray[i] == 270) {
                        rotationArray[i] = 0;
                        continue;
                    }
                    rotationArray[i] = 90;
                    continue;
                }
                Integer[] integerArray = rotationArray;
                int n = i;
                Integer.valueOf(integerArray[n] + rotation);
            }
            for (i = 0; i <= 1; ++i) {
                boolean tucked = i == 1;
                ResourceLocation id = tucked ? modelIdentifiers.get(1) : modelIdentifiers.get(0);
                block8: for (Direction direction2 : Direction.values()) {
                    if (direction2.m_122434_().m_122478_()) continue;
                    switch (direction2) {
                        case NORTH: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[0])))));
                            continue block8;
                        }
                        case SOUTH: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[1])))));
                            continue block8;
                        }
                        case EAST: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[2])))));
                            continue block8;
                        }
                        case WEST: {
                            variantList.put(new TuckableVariant(tucked, direction2), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)id).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.valueOf((String)("R" + String.valueOf(rotationArray[3])))));
                        }
                    }
                }
            }
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61374_, (Property)BasicChairBlock.TUCKED).m_125362_((direction, aBoolean) -> {
                for (TuckableVariant tuckableVariant : variantList.keySet()) {
                    if (!tuckableVariant.direction.equals(direction) || tuckableVariant.tucked != aBoolean) continue;
                    return (Variant)variantList.get(tuckableVariant);
                }
                return null;
            }));
        }

        private static class TuckableVariant {
            final boolean tucked;
            final Direction direction;
            static List<TuckableVariant> variants = new ArrayList<TuckableVariant>();

            private TuckableVariant(boolean tucked, Direction direction) {
                this.tucked = tucked;
                this.direction = direction;
                variants.add(this);
            }

            public static TuckableVariant get(Direction direction, Boolean tucked) {
                for (TuckableVariant tuckableVariant : variants) {
                    if (tuckableVariant.tucked != tucked || !direction.equals((Object)tuckableVariant.direction)) continue;
                    return tuckableVariant;
                }
                return null;
            }
        }
    }
}

