/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.impl.ui.ScaledTextElement;
import snownee.jade.util.PlatformProxy;

public enum FluidStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>,
IServerExtensionProvider<Object, CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        FluidStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity tile, boolean showDetails) {
        FluidStorageProvider.putData(data, player, tile, showDetails);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.UNIVERSAL_FLUID_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (!accessor.showDetails() && config.get(Identifiers.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return;
        }
        if (accessor.getServerData().m_128441_("JadeFluidStorage")) {
            Optional<IClientExtensionProvider> provider = Optional.ofNullable(ResourceLocation.m_135820_((String)accessor.getServerData().m_128461_("JadeFluidStorageUid"))).map(WailaClientRegistration.INSTANCE.fluidStorageProviders::get);
            if (provider.isPresent()) {
                List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeFluidStorage", Function.identity()));
                if (groups.isEmpty()) {
                    return;
                }
                IElementHelper helper = IElementHelper.get();
                boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
                ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                    if (renderGroup) {
                        if (group.title != null) {
                            theTooltip.add(new HorizontalLineElement());
                            theTooltip.append(new ScaledTextElement(group.title, 0.5f));
                            theTooltip.append(new HorizontalLineElement());
                        } else if (group.bgColor == 0) {
                            theTooltip.add(new HorizontalLineElement());
                        }
                    }
                    for (FluidView view : group.views) {
                        Object text = view.overrideText != null ? view.overrideText : (view.fluidName == null ? Component.m_237113_((String)view.current) : (accessor.showDetails() ? Component.m_237110_((String)"jade.fluid2", (Object[])new Object[]{IDisplayHelper.get().stripColor(view.fluidName).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)view.current).m_130940_(ChatFormatting.WHITE), view.max}).m_130940_(ChatFormatting.GRAY) : Component.m_237110_((String)"jade.fluid", (Object[])new Object[]{IDisplayHelper.get().stripColor(view.fluidName), view.current})));
                        IProgressStyle progressStyle = helper.progressStyle().overlay(view.overlay);
                        theTooltip.add(helper.progress(view.ratio, (Component)text, progressStyle, BoxStyle.DEFAULT, true));
                    }
                });
            }
        }
    }

    public static void putData(CompoundTag tag, ServerPlayer player, Object target, boolean showDetails) {
        List<IServerExtensionProvider<Object, CompoundTag>> list = WailaCommonRegistration.INSTANCE.fluidStorageProviders.get(target);
        for (IServerExtensionProvider<Object, CompoundTag> provider : list) {
            List groups = provider.getGroups(player, player.m_9236_(), target, showDetails);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeFluidStorage", groups, Function.identity())) {
                tag.m_128359_("JadeFluidStorageUid", provider.getUid().toString());
            }
            return;
        }
    }

    @Override
    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return ClientViewGroup.map(groups, FluidView::read, null);
    }

    @Override
    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer player, ServerLevel world, Object target, boolean showDetails) {
        return PlatformProxy.wrapFluidStorage(target, (Player)player);
    }
}

