/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum CropProgressProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.getBlock() == Blocks.f_50092_) {
            return IElementHelper.get().item(new ItemStack((ItemLike)Items.f_42405_));
        }
        if (accessor.getBlock() == Blocks.f_50444_) {
            return IElementHelper.get().item(new ItemStack((ItemLike)Items.f_42732_));
        }
        return null;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)crop.m_7959_())).intValue() / (float)crop.m_7419_());
        } else if (state.m_61138_((Property)BlockStateProperties.f_61409_)) {
            CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61409_)).intValue() / 7.0f);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61406_)) {
            CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61406_)).intValue() / 2.0f);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61407_) && (block instanceof SweetBerryBushBlock || block instanceof NetherWartBlock)) {
            CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.m_61143_((Property)BlockStateProperties.f_61407_)).intValue() / 3.0f);
        }
    }

    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.crop_growth", (Object[])new Object[]{String.format("%.0f%%", Float.valueOf(growthValue))}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.crop_growth", (Object[])new Object[]{Component.m_237115_((String)"tooltip.jade.crop_mature").m_130940_(ChatFormatting.GREEN)}));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_CROP_PROGRESS;
    }
}

