/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.anthonyhilyard.iceberg.Loader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.server.Main;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Main.class})
public class MainMixin {
    @Inject(method={"main"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/server/loading/ServerModLoader;load()V", remap=false)}, remap=false)
    private static void fixUpdateURLs(String[] args, CallbackInfo info) {
        for (IModInfo mod : FMLLoader.getLoadingModList().getMods()) {
            Optional authors = mod.getConfig().getConfigElement(new String[]{"authors"});
            if (!authors.isPresent()) continue;
            boolean madeByGrend = false;
            Object t = authors.get();
            if (t instanceof String) {
                String author = (String)t;
                madeByGrend = author.contentEquals("Grend");
            } else {
                t = authors.get();
                if (t instanceof ArrayList) {
                    ArrayList authorList = (ArrayList)t;
                    madeByGrend = authorList.contains("Grend");
                }
            }
            if (!madeByGrend) continue;
            ModInfo modInfo = (ModInfo)mod;
            try {
                Field updateJSONURLField = ModInfo.class.getDeclaredField("updateJSONURL");
                updateJSONURLField.setAccessible(true);
                Optional updateJSONURL = (Optional)updateJSONURLField.get(modInfo);
                if (!updateJSONURL.isPresent()) continue;
                String url = ((URL)updateJSONURL.get()).toString();
                url = url.replace("mc-curse-update-checker.herokuapp.com", "mc-update-check.anthonyhilyard.com");
                updateJSONURLField.set(modInfo, Optional.of(new URL(url)));
            }
            catch (Exception e) {
                Loader.LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

