/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.renderer.BasePreviewRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModPreviewRenderer
extends BasePreviewRenderer {
    private static final ResourceLocation DEFAULT_TEXTURE_LIGHT = new ResourceLocation("shulkerboxtooltip", "textures/gui/shulker_box_tooltip.png");
    private static final ResourceLocation DEFAULT_TEXTURE_DARK = new ResourceLocation("shulkerboxtooltip", "textures/gui/shulker_box_tooltip_dark.png");
    public static final ModPreviewRenderer INSTANCE = new ModPreviewRenderer();

    ModPreviewRenderer() {
        super(18, 18, 8, 8);
    }

    @Override
    public int getWidth() {
        return 14 + Math.min(this.getMaxRowSize(), this.getInvSize()) * 18;
    }

    @Override
    public int getHeight() {
        return 14 + (int)Math.ceil((double)this.getInvSize() / (double)this.getMaxRowSize()) * 18;
    }

    private float[] setColor() {
        ColorKey key = ShulkerBoxTooltip.config.colors.coloredPreview ? this.provider.getWindowColorKey(this.previewContext) : ColorKey.DEFAULT;
        float[] color = key.rgbComponents();
        RenderSystem.m_157429_((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        return color;
    }

    private void setTexture(float[] color) {
        ResourceLocation texture = this.textureOverride;
        if (texture == null) {
            Configuration.Theme theme = ShulkerBoxTooltip.config.preview.theme;
            texture = theme == Configuration.Theme.MOD_DARK && Arrays.equals(color, DyeColor.WHITE.m_41068_()) ? DEFAULT_TEXTURE_DARK : DEFAULT_TEXTURE_LIGHT;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    private void drawBackground(int x, int y, int z, PoseStack matrices) {
        int s;
        int size;
        int zOffset = z + 100;
        int invSize = this.getInvSize();
        int xOffset = 7;
        int yOffset = 7;
        int rowTexYPos = 7;
        int rowSize = Math.min(this.getMaxRowSize(), invSize);
        int rowWidth = rowSize * 18;
        this.setTexture(this.setColor());
        for (size = rowSize; size > 0; size -= 9) {
            s = Math.min(size, 9);
            GuiComponent.m_93143_((PoseStack)matrices, (int)(x + xOffset), (int)y, (int)zOffset, (float)7.0f, (float)0.0f, (int)(s * 18), (int)7, (int)256, (int)256);
            xOffset += s * 18;
        }
        while (invSize > 0) {
            xOffset = 7;
            GuiComponent.m_93143_((PoseStack)matrices, (int)x, (int)(y + yOffset), (int)zOffset, (float)0.0f, (float)rowTexYPos, (int)7, (int)18, (int)256, (int)256);
            for (int rSize = rowSize; rSize > 0; rSize -= 9) {
                s = Math.min(rSize, 9);
                GuiComponent.m_93143_((PoseStack)matrices, (int)(x + xOffset), (int)(y + yOffset), (int)zOffset, (float)7.0f, (float)rowTexYPos, (int)(s * 18), (int)18, (int)256, (int)256);
                xOffset += s * 18;
            }
            GuiComponent.m_93143_((PoseStack)matrices, (int)(x + xOffset), (int)(y + yOffset), (int)zOffset, (float)169.0f, (float)rowTexYPos, (int)7, (int)18, (int)256, (int)256);
            yOffset += 18;
            invSize -= rowSize;
            rowTexYPos = rowTexYPos >= 43 ? 7 : rowTexYPos + 18;
        }
        xOffset = 7;
        for (size = rowSize; size > 0; size -= 9) {
            s = Math.min(size, 9);
            GuiComponent.m_93143_((PoseStack)matrices, (int)(x + xOffset), (int)(y + yOffset), (int)zOffset, (float)7.0f, (float)61.0f, (int)(s * 18), (int)7, (int)256, (int)256);
            xOffset += s * 18;
        }
        GuiComponent.m_93143_((PoseStack)matrices, (int)x, (int)y, (int)zOffset, (float)0.0f, (float)0.0f, (int)7, (int)7, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)(x + rowWidth + 7), (int)y, (int)zOffset, (float)169.0f, (float)0.0f, (int)7, (int)7, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)(x + rowWidth + 7), (int)(y + yOffset), (int)zOffset, (float)169.0f, (float)61.0f, (int)7, (int)7, (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrices, (int)x, (int)(y + yOffset), (int)zOffset, (float)0.0f, (float)61.0f, (int)7, (int)7, (int)256, (int)256);
    }

    @Override
    public void draw(int x, int y, int z, PoseStack matrices, Font textRenderer, ItemRenderer itemRenderer, TextureManager textureManager) {
        if (this.items.isEmpty() || this.previewType == PreviewType.NO_PREVIEW) {
            return;
        }
        RenderSystem.m_69482_();
        this.drawBackground(x, y, z, matrices);
        this.drawItems(x, y, z, textRenderer, itemRenderer);
    }
}

