/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.create.mechanical_chisel;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.SawFilterSlot;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.create.RechiseledCreate;
import com.supermartijn642.rechiseled.create.mechanical_chisel.MechanicalChiselBlock;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class MechanicalChiselBlockEntity
extends KineticBlockEntity {
    public ProcessingInventory inventory;
    private int recipeIndex;
    private final LazyOptional<IItemHandler> invProvider;
    private FilteringBehaviour filtering;
    private ItemStack playEvent;

    public MechanicalChiselBlockEntity(BlockPos pos, BlockState state) {
        super(RechiseledCreate.mechanical_chisel_entity, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.invProvider = LazyOptional.of(() -> this.inventory);
        this.playEvent = ItemStack.f_41583_;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SawFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnelsWhen(this::canProcess));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("RecipeIndex", this.recipeIndex);
        super.write(compound, clientPacket);
        if (!clientPacket || this.playEvent.m_41619_()) {
            return;
        }
        compound.m_128365_("PlayEvent", (Tag)this.playEvent.serializeNBT());
        this.playEvent = ItemStack.f_41583_;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeIndex = compound.m_128451_("RecipeIndex");
        if (compound.m_128441_("PlayEvent")) {
            this.playEvent = ItemStack.m_41712_((CompoundTag)compound.m_128469_("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.m_41619_()) {
            boolean isWood = false;
            Item item = this.playEvent.m_41720_();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).m_40614_();
                isWood = block.m_49962_(block.m_49966_()) == SoundType.f_56736_;
            }
            this.spawnEventParticles(this.playEvent);
            this.playEvent = ItemStack.f_41583_;
            if (!isWood) {
                AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
            } else {
                AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.canProcess()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        float processingSpeed = Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        Vec3 itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.m_122366_((double)itemMovement.f_82479_, (double)itemMovement.f_82480_, (double)itemMovement.f_82481_);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.m_122424_(), false)) == null) continue;
            if (tryExportingToBeltFunnel.m_41613_() != stack.m_41613_()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.m_41619_()) continue;
            return;
        }
        BlockPos nextPos = this.f_58858_.m_7637_(itemMovement.f_82479_, itemMovement.f_82480_, itemMovement.f_82481_);
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_41619_() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack, false)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.m_6596_();
                this.sendData();
            }
            return;
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(itemMovement.m_82490_(0.5).m_82520_(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.m_82490_(0.0625).m_82520_(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            ItemEntity entityIn = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_, outPos.f_82481_, stack);
            entityIn.m_20256_(outMotion);
            this.f_58857_.m_7967_((Entity)entityIn);
        }
        this.inventory.clear();
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.invProvider.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        return capability == ForgeCapabilities.ITEM_HANDLER && side != Direction.DOWN ? this.invProvider.cast() : super.getCapability(capability, side);
    }

    protected void spawnEventParticles(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        Object particleData = stack.m_41720_() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_()) : new ItemParticleOption(ParticleTypes.f_123752_, stack);
        RandomSource r = this.f_58857_.f_46441_;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)new Vec3(0.0, 0.25, 0.0), (RandomSource)r, (float)0.125f);
            this.f_58857_.m_7106_((ParticleOptions)particleData, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82480_);
        }
    }

    public Vec3 getItemMovementVec() {
        boolean alongX = (Boolean)this.m_58900_().m_61143_((Property)MechanicalChiselBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vec3((double)(offset * (alongX ? 1 : 0)), 0.0, (double)(offset * (alongX ? 0 : -1)));
    }

    private void applyRecipe() {
        List<ItemStack> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        ItemStack recipe = recipes.get(this.recipeIndex);
        int rolls = this.inventory.getStackInSlot(0).m_41613_();
        this.inventory.clear();
        ItemStack output = recipe.m_41777_();
        output.m_41764_(rolls);
        this.inventory.setStackInSlot(1, output);
        this.award(AllAdvancements.SAW_PROCESSING);
    }

    private List<ItemStack> getRecipes() {
        ItemStack input = this.inventory.getStackInSlot(0);
        ChiselingRecipe recipe = ChiselingRecipes.getRecipe((ItemStack)input);
        if (recipe == null) {
            return Collections.emptyList();
        }
        if (this.filtering.isActive() && !this.filtering.getFilter().m_41619_()) {
            return recipe.getEntries().stream().flatMap(entry -> entry.hasConnectingItem() ? (entry.hasRegularItem() ? Stream.of(entry.getConnectingItem(), entry.getRegularItem()) : Stream.of(entry.getConnectingItem())) : Stream.of(entry.getRegularItem())).map(Item::m_7968_).filter(arg_0 -> ((FilteringBehaviour)this.filtering).test(arg_0)).collect(Collectors.toList());
        }
        boolean connecting = false;
        for (ChiselingEntry entry2 : recipe.getEntries()) {
            if (entry2.getConnectingItem() == input.m_41720_()) {
                connecting = true;
                break;
            }
            if (entry2.getRegularItem() != input.m_41720_()) continue;
            break;
        }
        return recipe.getEntries().stream().filter(connecting ? ChiselingEntry::hasConnectingItem : ChiselingEntry::hasRegularItem).map(connecting ? ChiselingEntry::getConnectingItem : ChiselingEntry::getRegularItem).map(Item::m_7968_).filter(arg_0 -> ((FilteringBehaviour)this.filtering).test(arg_0)).collect(Collectors.toList());
    }

    public void insertItem(ItemEntity entity) {
        if (!this.canProcess()) {
            return;
        }
        if (!this.inventory.isEmpty()) {
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.inventory.clear();
        ItemStack remainder = this.inventory.insertItem(0, entity.m_32055_().m_41777_(), false);
        if (remainder.m_41619_()) {
            entity.m_146870_();
        } else {
            entity.m_32045_(remainder);
        }
    }

    public void start(ItemStack inserted) {
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        List<ItemStack> recipes = this.getRecipes();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        this.recipeIndex = this.f_58857_.m_213780_().m_188503_(recipes.size());
        if (inserted.m_41720_() == recipes.get(this.recipeIndex).m_41720_()) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.m_41613_() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    protected boolean canProcess() {
        return this.m_58900_().m_61143_((Property)MechanicalChiselBlock.FACING) == Direction.UP;
    }
}

