/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetRenderHandler;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ZapperRenderHandler
extends ShootableGadgetRenderHandler {
    public List<LaserBeam> cachedBeams;

    @Override
    protected boolean appliesTo(ItemStack stack) {
        return stack.m_41720_() instanceof ZapperItem;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.cachedBeams == null) {
            this.cachedBeams = new LinkedList<LaserBeam>();
        }
        this.cachedBeams.removeIf(b -> b.itensity < 0.1f);
        if (this.cachedBeams.isEmpty()) {
            return;
        }
        this.cachedBeams.forEach(beam -> CreateClient.OUTLINER.endChasingLine(beam, beam.start, beam.end, 1.0f - beam.itensity, false).disableLineNormals().colored(0xFFFFFF).lineWidth(beam.itensity * 1.0f / 8.0f));
        this.cachedBeams.forEach(b -> b.itensity *= 0.6f);
    }

    @Override
    protected void transformTool(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
        ms.m_85837_((double)(flip * -0.1f), (double)0.1f, (double)-0.4f);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(flip * 5.0f));
    }

    @Override
    protected void transformHand(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
    }

    @Override
    protected void playSound(InteractionHand hand, Vec3 position) {
        float pitch = hand == InteractionHand.MAIN_HAND ? 0.1f : 0.9f;
        Minecraft mc = Minecraft.m_91087_();
        AllSoundEvents.WORLDSHAPER_PLACE.play((Level)mc.f_91073_, (Player)mc.f_91074_, position, 0.1f, pitch);
    }

    public void addBeam(LaserBeam beam) {
        Random r = new Random();
        double x = beam.end.f_82479_;
        double y = beam.end.f_82480_;
        double z = beam.end.f_82481_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Supplier<Double> randomSpeed = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        Supplier<Double> randomOffset = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        for (int i = 0; i < 10; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue());
            world.m_7106_((ParticleOptions)ParticleTypes.f_123815_, x + randomOffset.get(), y + randomOffset.get(), z + randomOffset.get(), 0.0, 0.0, 0.0);
        }
        this.cachedBeams.add(beam);
    }

    public static class LaserBeam {
        float itensity;
        Vec3 start;
        Vec3 end;

        public LaserBeam(Vec3 start, Vec3 end) {
            this.start = start;
            this.end = end;
            this.itensity = 1.0f;
        }
    }
}

