/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.depot.SharedDepotBlockMethods;
import com.simibubi.create.content.trains.station.AssemblyScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationMapData;
import com.simibubi.create.content.trains.station.StationScreen;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class StationBlock
extends Block
implements IBE<StationBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty ASSEMBLING = BooleanProperty.m_61465_((String)"assembling");

    public StationBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ASSEMBLING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{ASSEMBLING, WATERLOGGED}));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.withWater(super.m_5573_(pContext), pContext);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return this.getBlockEntityOptional((BlockGetter)pLevel, pPos).map(ste -> ste.trainPresent ? 15 : 0).orElse(0);
    }

    public void m_49811_(CreativeModeTab pTab, NonNullList<ItemStack> pItems) {
        pItems.add((Object)AllItems.SCHEDULE.asStack());
        super.m_49811_(pTab, pItems);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove(state, worldIn, pos, newState);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        SharedDepotBlockMethods.onLanded(worldIn, entityIn);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null || pPlayer.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (AllItems.WRENCH.isIn(itemInHand)) {
            return InteractionResult.PASS;
        }
        if (itemInHand.m_41720_() == Items.f_42573_) {
            return this.onBlockEntityUse((BlockGetter)pLevel, pPos, station -> {
                if (pLevel.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (station.getStation() == null || station.getStation().getId() == null) {
                    return InteractionResult.FAIL;
                }
                MapItemSavedData savedData = MapItem.m_42853_((ItemStack)itemInHand, (Level)pLevel);
                if (!(savedData instanceof StationMapData)) {
                    return InteractionResult.FAIL;
                }
                StationMapData stationMapData = (StationMapData)savedData;
                if (!stationMapData.toggleStation((LevelAccessor)pLevel, pPos, (StationBlockEntity)station)) {
                    return InteractionResult.FAIL;
                }
                return InteractionResult.SUCCESS;
            });
        }
        InteractionResult result = this.onBlockEntityUse((BlockGetter)pLevel, pPos, station -> {
            ItemStack autoSchedule = station.getAutoSchedule();
            if (autoSchedule.m_41619_()) {
                return InteractionResult.PASS;
            }
            if (pLevel.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            pPlayer.m_150109_().m_150079_(autoSchedule.m_41777_());
            station.depotBehaviour.removeHeldItem();
            station.notifyUpdate();
            AllSoundEvents.playItemPickup(pPlayer);
            return InteractionResult.SUCCESS;
        });
        if (result == InteractionResult.PASS) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> this.displayScreen((StationBlockEntity)be, pPlayer)));
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(StationBlockEntity be, Player player) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        GlobalStation station = be.getStation();
        BlockState blockState = be.m_58900_();
        if (station == null || blockState == null) {
            return;
        }
        boolean assembling = blockState.m_60734_() == this && (Boolean)blockState.m_61143_((Property)ASSEMBLING) != false;
        ScreenOpener.open(assembling ? new AssemblyScreen(be, station) : new StationScreen(be, station));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.STATION;
    }

    @Override
    public Class<StationBlockEntity> getBlockEntityClass() {
        return StationBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends StationBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.TRACK_STATION.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

