/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.flat_pane;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.foundation.copycat.CCWaterloggedCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICustomCTBlocking;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BackportUtils;
import com.copycatsplus.copycats.utility.InteractionUtils;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatFlatPaneBlock
extends CCWaterloggedCopycatBlock
implements IStateType,
ICustomCTBlocking {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatFlatPaneBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult ray) {
        return InteractionUtils.sequential(() -> InteractionUtils.usePlacementHelper(placementHelperId, state, world, pos, player, hand, ray), () -> super.m_6227_(state, world, pos, player, hand, ray));
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return switch (pType) {
            case PathComputationType.LAND -> ((Direction.Axis)pState.m_61143_(AXIS)).m_122479_();
            default -> false;
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        Direction.Axis axis = context.m_7820_().m_122434_();
        return (BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{AXIS}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return CCShapes.HORIZONTAL_PANE.get(pState.m_61143_(AXIS)).toShape();
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.rotationAxis != null) {
            state = (BlockState)state.m_61124_(AXIS, (Comparable)transform.rotateAxis((Direction.Axis)state.m_61143_(AXIS)));
        }
        return state;
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState fromState, Direction face, BlockPos fromPos, BlockPos toPos, BlockState toState) {
        toState = reader.m_8055_(toPos);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return false;
        }
        Direction facing = BackportUtils.directionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (toState.m_60734_() instanceof IronBarsBlock) {
            if (facing == null) {
                return true;
            }
            return face.m_122434_().m_122478_() || fromState.m_61143_(AXIS) == facing.m_122434_();
        }
        if (toState.m_60713_((Block)this)) {
            if (facing == null) {
                return true;
            }
            return toState.m_61143_(AXIS) != fromState.m_61143_(AXIS) || fromState.m_61143_(AXIS) == facing.m_122434_();
        }
        return true;
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState fromState) {
        BlockState toState = reader.m_8055_(toPos);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction facing = BackportUtils.directionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (toState.m_60734_() instanceof IronBarsBlock) {
            if (facing == null) {
                return false;
            }
            return fromState.m_61143_(AXIS) != facing.m_122434_();
        }
        if (toState.m_60713_((Block)this)) {
            if (facing == null) {
                return false;
            }
            return toState.m_61143_(AXIS) == fromState.m_61143_(AXIS) && fromState.m_61143_(AXIS) != facing.m_122434_();
        }
        return false;
    }

    @Override
    public Optional<Boolean> blockCTTowards(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos ctPos, BlockPos connectingPos, Direction face) {
        return Optional.of(false);
    }

    @Override
    public Optional<Boolean> isCTBlocked(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos connectingPos, BlockPos blockingPos, Direction face) {
        return Optional.of(false);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CCBlocks.COPYCAT_FLAT_PANE.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CCBlocks.COPYCAT_FLAT_PANE.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), dir -> world.m_8055_(pos.m_121945_(dir)).m_60767_().m_76336_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)s.m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS))));
        }
    }
}

