/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.wall;

import com.copycatsplus.copycats.CCBlockEntityTypes;
import com.copycatsplus.copycats.foundation.copycat.CCCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BackportUtils;
import com.copycatsplus.copycats.utility.InteractionUtils;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatWallBlock
extends WallBlock
implements ICopycatBlock,
IBE<CCCopycatBlockEntity>,
IStateType {
    public CopycatWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level level, BlockState state, BlockEntityType<S> type) {
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionUtils.sequential(() -> ICopycatBlock.super.m_6227_(state, level, pos, player, hand, hit), () -> super.m_6227_(state, level, pos, player, hand, hit));
    }

    @Override
    public boolean isAcceptedRegardless(BlockState material) {
        return material.m_60734_() instanceof WallBlock;
    }

    @Override
    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        ICopycatBlock.super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        ICopycatBlock.super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving, (x$0, x$1, x$2, x$3, x$4) -> super.m_6810_(x$0, x$1, x$2, x$3, x$4));
    }

    @Override
    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        ICopycatBlock.super.m_5707_(pLevel, pPos, pState, pPlayer);
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public Class<CCCopycatBlockEntity> getBlockEntityClass() {
        return CCCopycatBlockEntity.class;
    }

    public BlockEntityType<? extends CCCopycatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.COPYCAT.get();
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos, BlockState toState) {
        if (CopycatWallBlock.isPole(state)) {
            return ICopycatBlock.super.isIgnoredConnectivitySide(reader, state, face, fromPos, toPos, toState);
        }
        if (!toState.m_60713_((Block)this) || !state.m_60713_((Block)this)) {
            return true;
        }
        boolean isCross = true;
        for (Direction direction : Iterate.horizontalDirections) {
            if (toState.m_61143_(CopycatWallBlock.byDirection(direction)) != WallSide.NONE) continue;
            isCross = false;
            break;
        }
        return isCross;
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        if (CopycatWallBlock.isPole(state)) {
            return ICopycatBlock.super.canConnectTexturesToward(reader, fromPos, toPos, state);
        }
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        long sideCount = Arrays.stream(Iterate.horizontalDirections).filter(s -> state.m_61143_(CopycatWallBlock.byDirection(s)) != WallSide.NONE).count();
        if (sideCount > 2L) {
            return false;
        }
        if (sideCount == 2L && (state.m_61143_((Property)f_57951_) != state.m_61143_((Property)f_57952_) || state.m_61143_((Property)f_57950_) != state.m_61143_((Property)f_57953_))) {
            return false;
        }
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = BackportUtils.directionFromDelta(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (face == null) {
            if (diff.m_123333_(Vec3i.f_123288_) > 2) {
                return false;
            }
            if (diff.m_123342_() == 0) {
                return false;
            }
            Direction horizontalDiff = Direction.m_122387_((Direction.Axis)(diff.m_123341_() == 0 ? Direction.Axis.Z : Direction.Axis.X), (Direction.AxisDirection)(diff.m_123341_() + diff.m_123343_() > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
            if (diff.m_123342_() > 0) {
                if (state.m_61143_(CopycatWallBlock.byDirection(horizontalDiff)) != WallSide.TALL) {
                    return false;
                }
                if (toState.m_61143_(CopycatWallBlock.byDirection(horizontalDiff.m_122424_())) == WallSide.NONE) {
                    return false;
                }
            } else {
                if (state.m_61143_(CopycatWallBlock.byDirection(horizontalDiff)) == WallSide.NONE) {
                    return false;
                }
                if (toState.m_61143_(CopycatWallBlock.byDirection(horizontalDiff.m_122424_())) != WallSide.TALL) {
                    return false;
                }
            }
            return true;
        }
        if (face == Direction.DOWN || face == Direction.UP) {
            return this.canConnectVertically(state) && this.canConnectVertically(toState);
        }
        if (((Boolean)state.m_61143_((Property)WallBlock.f_57949_)).booleanValue()) {
            return false;
        }
        return state.m_61143_(CopycatWallBlock.byDirection(face)) != WallSide.NONE;
    }

    private static boolean isPole(BlockState state) {
        return Arrays.stream(Iterate.horizontalDirections).allMatch(s -> state.m_61143_(CopycatWallBlock.byDirection(s)) == WallSide.NONE);
    }

    private boolean canConnectVertically(BlockState state) {
        if (!((Boolean)state.m_61143_((Property)WallBlock.f_57949_)).booleanValue()) {
            return false;
        }
        for (Direction direction : Iterate.horizontalDirections) {
            WallSide side = (WallSide)state.m_61143_(CopycatWallBlock.byDirection(direction));
            if (side == WallSide.NONE) continue;
            return false;
        }
        return true;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    public static EnumProperty<WallSide> byDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> f_57951_;
            case Direction.SOUTH -> f_57952_;
            case Direction.WEST -> f_57953_;
            case Direction.EAST -> f_57950_;
            default -> throw new IllegalArgumentException("Vertical directions not supported");
        };
    }
}

