/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.CCBlockEntityTypes;
import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.config.CCConfigs;
import com.copycatsplus.copycats.foundation.copycat.CCCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.CCCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlockEntity;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MigrationManager {
    public static boolean migrationDisabled() {
        return CCConfigs.safeGetter(() -> (Boolean)CCConfigs.common().disableMigration.get(), false).get();
    }

    public static StructureTemplate.StructureBlockInfo migrateStructure(StructureTemplate.StructureBlockInfo info) {
        if (MigrationManager.migrationDisabled()) {
            return info;
        }
        BlockState state = info.f_74676_;
        CompoundTag nbt = info.f_74677_;
        if (state.m_60734_() instanceof MultiStateCopycatBlock && nbt != null && nbt.m_128441_("Material")) {
            BlockPos pos = info.f_74675_;
            CopycatBlockEntity be = (CopycatBlockEntity)AllBlockEntityTypes.COPYCAT.create(pos, state);
            be.m_142466_(nbt);
            MultiStateCopycatBlockEntity multiBe = (MultiStateCopycatBlockEntity)CCBlockEntityTypes.MULTI_STATE_COPYCAT.create(pos, state);
            multiBe.migrateData((ICopycatBlockEntity)be);
            nbt = multiBe.m_187481_();
            return new StructureTemplate.StructureBlockInfo(pos, state, nbt);
        }
        if (state.m_60734_() instanceof CCCopycatBlock && nbt != null && nbt.m_128441_("id") && nbt.m_128461_("id").equals(AllBlockEntityTypes.COPYCAT.getId().toString())) {
            BlockPos pos = info.f_74675_;
            CCCopycatBlockEntity be = (CCCopycatBlockEntity)CCBlockEntityTypes.COPYCAT.create(pos, state);
            be.m_142466_(nbt);
            nbt = be.m_187481_();
            return new StructureTemplate.StructureBlockInfo(pos, state, nbt);
        }
        return info;
    }

    public static BlockEntity migrateBlockEntity(LevelChunk chunk, BlockEntity blockEntity) {
        if (MigrationManager.migrationDisabled()) {
            return blockEntity;
        }
        BlockPos pos = blockEntity.m_58899_();
        BlockState state = chunk.m_8055_(pos);
        if (MigrationManager.isCopycatAndNeedingConversion(state, blockEntity)) {
            if (CCBlocks.getAllRegisteredMultiStateBlocks().stream().map(RegistryEntry::get).collect(Collectors.toSet()).contains(state.m_60734_())) {
                CompoundTag oldTag = blockEntity.m_187480_();
                MultiStateCopycatBlockEntity newBlockEntity = (MultiStateCopycatBlockEntity)CCBlockEntityTypes.MULTI_STATE_COPYCAT.create(pos, state);
                newBlockEntity.m_142466_(oldTag);
                newBlockEntity.migrateData((ICopycatBlockEntity)blockEntity);
                return newBlockEntity;
            }
            CompoundTag oldTag = blockEntity.m_187480_();
            CCCopycatBlockEntity newBlockEntity = (CCCopycatBlockEntity)CCBlockEntityTypes.COPYCAT.create(pos, state);
            newBlockEntity.m_142466_(oldTag);
            return newBlockEntity;
        }
        return blockEntity;
    }

    private static boolean isCopycatAndNeedingConversion(BlockState state, BlockEntity blockEntity) {
        ResourceLocation id = Registry.f_122830_.m_7981_((Object)blockEntity.m_58903_());
        if (id == null) {
            return false;
        }
        ResourceKey resourceKey = state.m_60734_().m_204297_().m_205785_();
        return id.toString().equalsIgnoreCase("create:copycat") && resourceKey.m_135782_().m_135827_().equalsIgnoreCase("copycats");
    }
}

