/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.jozufozu.flywheel.core.StitchedSprite;
import com.railwayteam.railways.Railways;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BufferModelUtils {
    public static final StitchedSprite SPRUCE_PLANKS_TEMPLATE = new StitchedSprite(new ResourceLocation("block/spruce_planks"));
    public static final StitchedSprite BIG_BUFFER_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/big_buffer"));
    public static final StitchedSprite SMALL_BUFFER_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/small_buffer"));
    public static final StitchedSprite SMALL_BUFFER_MONORAIL_TEMPLATE = new StitchedSprite(Railways.asResource("block/buffer/small_buffer_monorail"));
    public static final EnumMap<DyeColor, StitchedSprite> BIG_BUFFER_COLORS = new EnumMap(DyeColor.class);
    public static final EnumMap<DyeColor, StitchedSprite> SMALL_BUFFER_COLORS = new EnumMap(DyeColor.class);

    public static UnaryOperator<TextureAtlasSprite> getSwapper(@Nullable BlockState planksState) {
        if (planksState == null) {
            return sprite -> null;
        }
        Block planksBlock = planksState.m_60734_();
        ResourceLocation id = RegisteredObjects.getKeyOrThrow((Block)planksBlock);
        String path = id.m_135815_();
        if (path.endsWith("_planks")) {
            return sprite -> {
                if (sprite == SPRUCE_PLANKS_TEMPLATE.get()) {
                    return BufferModelUtils.getSpriteOnSide(planksState, Direction.UP);
                }
                return null;
            };
        }
        return sprite -> null;
    }

    @SafeVarargs
    public static UnaryOperator<TextureAtlasSprite> combineSwappers(UnaryOperator<TextureAtlasSprite> ... swappers) {
        return sprite -> {
            for (UnaryOperator swapper : swappers) {
                TextureAtlasSprite newSprite;
                if (swapper == null || (newSprite = (TextureAtlasSprite)swapper.apply(sprite)) == null) continue;
                return newSprite;
            }
            return null;
        };
    }

    public static UnaryOperator<TextureAtlasSprite> getSwapper(@Nullable DyeColor color) {
        if (color == null) {
            return sprite -> null;
        }
        return sprite -> {
            if (sprite == SMALL_BUFFER_TEMPLATE.get() || sprite == SMALL_BUFFER_MONORAIL_TEMPLATE.get()) {
                return SMALL_BUFFER_COLORS.get(color).get();
            }
            if (sprite == BIG_BUFFER_TEMPLATE.get()) {
                return BIG_BUFFER_COLORS.get(color).get();
            }
            return null;
        };
    }

    private static TextureAtlasSprite getSpriteOnSide(BlockState state, Direction side) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        if (model == null) {
            return null;
        }
        RandomSource random = RandomSource.m_216327_();
        random.m_188584_(42L);
        List quads = model.m_213637_(state, side, random);
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        random.m_188584_(42L);
        quads = model.m_213637_(state, null, random);
        if (!quads.isEmpty()) {
            for (BakedQuad quad : quads) {
                if (quad.m_111306_() != side) continue;
                return quad.m_173410_();
            }
        }
        return model.m_6160_();
    }

    public static void register() {
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            BIG_BUFFER_COLORS.put(color, new StitchedSprite(Railways.asResource("block/buffer/big_buffer/big_buffer_" + color.m_41065_())));
            SMALL_BUFFER_COLORS.put(color, new StitchedSprite(Railways.asResource("block/buffer/small_buffer/small_buffer_" + color.m_41065_())));
        }
    }
}

