/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.WoodVariantTrackBufferBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyBlock;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MonoTrackBufferBlock
extends WoodVariantTrackBufferBlock {
    public static final EnumProperty<Style> STYLE = EnumProperty.m_61587_((String)"style", Style.class);
    public static final BooleanProperty UPSIDE_DOWN = MonoBogeyBlock.UPSIDE_DOWN;

    public MonoTrackBufferBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(STYLE, (Comparable)((Object)Style.STANDARD))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{STYLE, UPSIDE_DOWN}));
    }

    @Override
    protected BlockState getCycledStyle(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.m_61122_(STYLE);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        boolean hanging = context.m_43719_() == Direction.DOWN;
        Style style = context.m_43719_().m_122434_().m_122479_() ? Style.SIDE : Style.STANDARD;
        return (BlockState)((BlockState)state.m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(hanging))).m_61124_(STYLE, (Comparable)((Object)style));
    }

    public static enum Style implements StringRepresentable
    {
        STANDARD("monorail_buffer_stop"),
        MONO("monorail_mono_buffer_stop"),
        SIDE("monorail_side_buffer_stop");

        private final String model;

        private Style(String model) {
            this.model = model;
        }

        public ResourceLocation getModel() {
            return Railways.asResource("block/buffer/" + this.model);
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

