/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.forge;

import com.railwayteam.railways.content.buffer.BufferModelUtils;
import com.railwayteam.railways.content.buffer.IDyedBuffer;
import com.railwayteam.railways.content.buffer.IMaterialAdaptingBuffer;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class BufferModel
implements BakedModel {
    private final BakedModel wrapped;
    private static final ModelProperty<@Nullable BlockState> MATERIAL = new ModelProperty();
    private static final ModelProperty<@Nullable DyeColor> COLOR = new ModelProperty();
    private static final Matrix3d diagonalTransform = new Matrix3d().asYRotation((float)Math.toRadians(-45.0));

    public BufferModel(BakedModel wrapped) {
        this.wrapped = wrapped;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        Object be;
        BlockState material = null;
        DyeColor color = null;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IDyedBuffer) {
            be = (IDyedBuffer)blockEntity;
            color = be.getColor();
        }
        if ((blockEntity = level.m_7702_(pos)) instanceof IMaterialAdaptingBuffer) {
            be = (IMaterialAdaptingBuffer)blockEntity;
            material = be.getMaterial();
        }
        return modelData.derive().with(MATERIAL, material).with(COLOR, (Object)color).build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        BlockState material = (BlockState)data.get(MATERIAL);
        DyeColor color = (DyeColor)data.get(COLOR);
        if (material != null || color != null) {
            return BakedModelHelper.swapSprites(this.transformQuads(this.wrapped.m_213637_(state, side, rand), state), BufferModelUtils.combineSwappers(BufferModelUtils.getSwapper(material), BufferModelUtils.getSwapper(color)));
        }
        return this.transformQuads(this.wrapped.m_213637_(state, side, rand), state);
    }

    private BakedQuad applyDiagonalTransform(BakedQuad quad) {
        BakedQuad newQuad = BakedQuadHelper.clone((BakedQuad)quad);
        int[] vertexData = newQuad.m_111303_();
        for (int vertex = 0; vertex < 4; ++vertex) {
            Vec3 vertexPos = BakedQuadHelper.getXYZ((int[])vertexData, (int)vertex);
            vertexPos = vertexPos.m_82492_(0.5, 0.5, 0.5);
            vertexPos = diagonalTransform.transform(vertexPos);
            vertexPos = vertexPos.m_82520_(0.5, 0.5, 0.5);
            BakedQuadHelper.setXYZ((int[])vertexData, (int)vertex, (Vec3)vertexPos);
        }
        return newQuad;
    }

    private List<BakedQuad> transformQuads(List<BakedQuad> quads, @Nullable BlockState state) {
        if (state == null) {
            return quads;
        }
        boolean isDiagonal = false;
        if (state.m_60734_() instanceof TrackBufferBlock) {
            isDiagonal = (Boolean)state.m_61143_((Property)TrackBufferBlock.DIAGONAL);
        }
        if (!isDiagonal) {
            return quads;
        }
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            transformedQuads.add(this.applyDiagonalTransform(quad));
        }
        return transformedQuads;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
        return Collections.emptyList();
    }

    public List<BakedModel> getRenderPasses(@NotNull ItemStack stack, boolean fabulous) {
        CompoundTag tag;
        UnaryOperator<TextureAtlasSprite> materialSwapper = null;
        UnaryOperator<TextureAtlasSprite> colorSwapper = null;
        if (stack.m_41782_() && (tag = stack.m_41783_()).m_128425_("BlockEntityTag", 10)) {
            CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
            if (blockEntityTag.m_128425_("Material", 10)) {
                materialSwapper = BufferModelUtils.getSwapper(NbtUtils.m_129241_((CompoundTag)blockEntityTag.m_128469_("Material")));
            }
            if (blockEntityTag.m_128425_("Color", 3)) {
                colorSwapper = BufferModelUtils.getSwapper(DyeColor.m_41053_((int)blockEntityTag.m_128451_("Color")));
            }
        }
        final UnaryOperator<TextureAtlasSprite> finalMaterialSwapper = materialSwapper;
        final UnaryOperator<TextureAtlasSprite> finalColorSwapper = colorSwapper;
        return List.of(new BufferModel(this.wrapped){

            @Override
            public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction direction, @NotNull RandomSource random) {
                if (finalMaterialSwapper != null || finalColorSwapper != null) {
                    return BakedModelHelper.swapSprites((List)BufferModel.this.wrapped.m_213637_(state, direction, random), BufferModelUtils.combineSwappers(finalMaterialSwapper, finalColorSwapper));
                }
                return BufferModel.this.wrapped.m_213637_(state, direction, random);
            }
        });
    }

    public boolean m_7541_() {
        return this.wrapped.m_7541_();
    }

    public boolean m_7539_() {
        return this.wrapped.m_7539_();
    }

    public boolean m_7547_() {
        return this.wrapped.m_7547_();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.wrapped.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    public ItemOverrides m_7343_() {
        return this.wrapped.m_7343_();
    }

    public ItemTransforms m_7442_() {
        return this.wrapped.m_7442_();
    }
}

