/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.railwayteam.railways.content.buffer.DyeableBlockEntity;
import com.railwayteam.railways.content.buffer.IMaterialAdaptingBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HeadstockBlockEntity
extends DyeableBlockEntity
implements IMaterialAdaptingBuffer {
    protected BlockState material = Blocks.f_50741_.m_49966_();

    public HeadstockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @NotNull
    public BlockState getMaterial() {
        return this.material;
    }

    public InteractionResult applyMaterialIfValid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState material = blockItem.m_40614_().m_49966_();
        if (material == this.material) {
            return InteractionResult.PASS;
        }
        if (!material.m_204336_(BlockTags.f_13090_)) {
            return InteractionResult.PASS;
        }
        if (this.f_58857_.m_5776_() && !this.isVirtual()) {
            return InteractionResult.SUCCESS;
        }
        this.material = material;
        this.notifyUpdate();
        this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)material));
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        BlockState prevMaterial = this.material;
        if (!compound.m_128441_("Material")) {
            return;
        }
        this.material = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("Material"));
        if (this.material.m_60795_()) {
            this.material = Blocks.f_50741_.m_49966_();
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Material", (Tag)NbtUtils.m_129202_((BlockState)this.material));
    }
}

