/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.smokestack.SmokeType;
import com.railwayteam.railways.content.smokestack.block.AbstractSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.be.SmokeStackBlockEntity;
import com.railwayteam.railways.content.smokestack.particles.legacy.SmokeParticleData;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticleData;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.util.ShapeWrapper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SmokeStackBlock
extends AbstractSmokeStackBlock<SmokeStackBlockEntity> {
    public final SmokeStackType type;
    public boolean createsStationarySmoke;

    public SmokeStackBlock(BlockBehaviour.Properties properties, SmokeStackType type, ShapeWrapper shape, boolean createsStationarySmoke, String variant) {
        super(properties, shape, variant);
        this.m_49959_(this.makeDefaultState());
        this.type = type;
        this.createsStationarySmoke = createsStationarySmoke;
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Item item = pPlayer.m_21120_(pHand).m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor color = dyeItem.m_41089_();
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, te -> te.setColor(color));
            if (!pPlayer.m_7500_()) {
                pPlayer.m_21120_(pHand).m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (pPlayer.m_21120_(pHand).m_204117_(ItemTags.f_13154_)) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, te -> te.setSoul(true));
            if (!pPlayer.m_7500_()) {
                pPlayer.m_21120_(pHand).m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (pPlayer.m_6144_()) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, te -> {
                te.setSoul(false);
                te.setColor(null);
            });
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public static void makeParticlesStationary(Level level, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta) {
        SmokeStackBlock.makeParticles(level, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0, true);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, false);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary) {
        DyeColor color = null;
        boolean isSoul = false;
        BlockEntity blockEntity = level.m_7702_(new BlockPos(pos));
        if (blockEntity instanceof SmokeStackBlockEntity) {
            SmokeStackBlockEntity be = (SmokeStackBlockEntity)blockEntity;
            isSoul = be.isSoul();
            color = be.getColor();
        }
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, null, isSoul);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary, @Nullable DyeColor color) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, null);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary, @Nullable DyeColor color, @Nullable Boolean small) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, small, false);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary, @Nullable DyeColor color, @Nullable Boolean small, boolean isSoul) {
        RandomSource random = level.m_213780_();
        SmokeType smokeType = (SmokeType)((Object)CRConfigs.client().smokeType.get());
        if (small == null) {
            small = random.m_188500_() < 0.33;
        }
        switch (smokeType) {
            case VANILLA: {
                SimpleParticleType particleType = isSignalFire ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
                level.m_6485_((ParticleOptions)particleType, true, pos.m_7096_() + spawnOffset.f_82479_ + random.m_188500_() * spawnDelta.f_82479_ * (double)(random.m_188499_() ? 1 : -1), pos.m_7098_() + random.m_188500_() * spawnDelta.f_82480_ + spawnOffset.f_82480_, pos.m_7094_() + spawnOffset.f_82481_ + random.m_188500_() * spawnDelta.f_82481_ * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07 * speedMultiplier / (stationary ? 1.0 : 25.0), 0.0);
                break;
            }
            case OLD: {
                SmokeParticleData particleType;
                if (color != null) {
                    float[] c = color.m_41068_();
                    particleType = new SmokeParticleData(stationary, c[0], c[1], c[2]);
                } else {
                    particleType = new SmokeParticleData(stationary);
                }
                level.m_6485_((ParticleOptions)particleType, true, pos.m_7096_() + spawnOffset.f_82479_ + random.m_188500_() * spawnDelta.f_82479_ * (random.m_188500_() * 2.0 - 1.0), pos.m_7098_() + random.m_188500_() * spawnDelta.f_82480_ + spawnOffset.f_82480_ + 0.5, pos.m_7094_() + spawnOffset.f_82481_ + random.m_188500_() * spawnDelta.f_82481_ * (random.m_188500_() * 2.0 - 1.0), 0.0, 0.07 * speedMultiplier * (double)(stationary ? 25 : 1), 0.0);
                break;
            }
            case CARTOON: {
                PuffSmokeParticleData<?> particleType = isSoul ? PuffSmokeParticleData.create(small, stationary, -2.0f, -2.0f, -2.0f) : (color != null ? PuffSmokeParticleData.create(small, stationary, color) : PuffSmokeParticleData.create(small, stationary));
                level.m_6485_(particleType, true, pos.m_7096_() + spawnOffset.f_82479_ + random.m_188500_() * spawnDelta.f_82479_ * (random.m_188500_() * 2.0 - 1.0), pos.m_7098_() + random.m_188500_() * spawnDelta.f_82480_ + spawnOffset.f_82480_ + 0.5, pos.m_7094_() + spawnOffset.f_82481_ + random.m_188500_() * spawnDelta.f_82481_ * (random.m_188500_() * 2.0 - 1.0), 0.0, Mth.m_14082_((double)speedMultiplier, (double)-1.0) ? 42.0 : 2.1, 0.0);
            }
        }
        if (spawnExtraSmoke && smokeType != SmokeType.CARTOON) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.m_7096_() + spawnOffset.f_82479_ + random.m_188500_() * spawnDelta.f_82479_ * 0.75 * (double)(random.m_188499_() ? 1 : -1), pos.m_7098_() + spawnOffset.f_82480_ - 0.1, pos.m_7094_() + spawnOffset.f_82481_ + random.m_188500_() * spawnDelta.f_82481_ * 0.75 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005 * speedMultiplier, 0.0);
        }
    }

    public void blockEntityAnimateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() && (double)random.m_188501_() < this.type.particleSpawnChance * 1.5 && this.createsStationarySmoke) {
            for (int i = 0; i < random.m_188503_(this.type.maxParticles - this.type.minParticles) + this.type.minParticles; ++i) {
                SmokeStackBlock.makeParticlesStationary(level, pos, random.m_188499_(), true, this.type.getParticleSpawnOffset(), this.type.getParticleSpawnDelta());
            }
        }
    }

    public Class<SmokeStackBlockEntity> getBlockEntityClass() {
        return SmokeStackBlockEntity.class;
    }

    public BlockEntityType<? extends SmokeStackBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.SMOKE_STACK.get();
    }

    public static class SmokeStackType {
        public Vec3 particleSpawnOffset;
        public Vec3 particleSpawnDelta;
        public double particleSpawnChance;
        public int minParticles;
        public int maxParticles;

        public SmokeStackType(double xOffset, double yOffset, double zOffset) {
            this(new Vec3(xOffset, yOffset, zOffset));
        }

        public SmokeStackType(Vec3 particleSpawnOffset) {
            this(particleSpawnOffset, new Vec3(0.3, 2.0, 0.3));
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta) {
            this(particleSpawnOffset, particleSpawnDelta, 2, 4);
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta, int minParticles, int maxParticles) {
            this(particleSpawnOffset, particleSpawnDelta, minParticles, maxParticles, 1.0);
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta, int minParticles, int maxParticles, double particleSpawnChance) {
            this.particleSpawnOffset = particleSpawnOffset;
            this.particleSpawnDelta = particleSpawnDelta;
            this.minParticles = minParticles;
            this.maxParticles = maxParticles;
            this.particleSpawnChance = particleSpawnChance;
        }

        public Vec3 getParticleSpawnOffset() {
            return this.particleSpawnOffset;
        }

        public Vec3 getParticleSpawnDelta() {
            return this.particleSpawnDelta;
        }
    }

    public static enum RotationType {
        NONE,
        AXIS,
        FACING;

    }
}

