/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.BuilderTransformers;
import com.railwayteam.railways.content.buffer.BlockStateBlockItem;
import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import com.railwayteam.railways.content.buffer.MonoTrackBufferBlock;
import com.railwayteam.railways.content.buffer.NarrowTrackBufferBlock;
import com.railwayteam.railways.content.buffer.StandardTrackBufferBlock;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.railwayteam.railways.content.buffer.TrackBufferBlockItem;
import com.railwayteam.railways.content.buffer.WideTrackBufferBlock;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBarsBlock;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.HeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.HeadstockStyle;
import com.railwayteam.railways.content.buffer.single_deco.GenericDyeableSingleBufferBlock;
import com.railwayteam.railways.content.buffer.single_deco.LinkPinBlock;
import com.railwayteam.railways.content.conductor.vent.CopycatVentModel;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleItem;
import com.railwayteam.railways.content.coupling.TrackCouplerDisplaySource;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockItem;
import com.railwayteam.railways.content.custom_bogeys.blocks.narrow.NarrowGaugeBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.DoubleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.SingleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.TripleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle0100BogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle0120BogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle040BogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle060BogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.large.LargeCreateStyle080BogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.Medium202TrailingBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.Medium404TrailingBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.MediumBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.MediumQuadrupleWheelBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.MediumQuintupleWheelBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.standard.medium.MediumTripleWheelBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.wide.WideGaugeBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.blocks.wide.WideGaugeComicallyLargeBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.invisible.InvisibleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.special.monobogey.MonoBogeyBlock;
import com.railwayteam.railways.content.custom_tracks.CustomTrackBlockStateGenerator;
import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionBlock;
import com.railwayteam.railways.content.custom_tracks.generic_crossing.GenericCrossingBlock;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailBlockStateGenerator;
import com.railwayteam.railways.content.custom_tracks.narrow_gauge.NarrowGaugeTrackBlockStateGenerator;
import com.railwayteam.railways.content.custom_tracks.wide_gauge.WideGaugeTrackBlockStateGenerator;
import com.railwayteam.railways.content.distant_signals.SemaphoreDisplayTarget;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.content.handcar.HandcarControlsInteractionBehaviour;
import com.railwayteam.railways.content.handcar.HandcarItem;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.content.semaphore.SemaphoreItem;
import com.railwayteam.railways.content.smokestack.SmokeStackMovementBehaviour;
import com.railwayteam.railways.content.smokestack.SmokestackStyle;
import com.railwayteam.railways.content.smokestack.block.AbstractSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.AxisSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.DieselSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.FacingSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.railwayteam.railways.content.switches.SwitchDisplaySource;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockItem;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRItems;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.registry.forge.CRBlocksImpl;
import com.railwayteam.railways.util.ShapeWrapper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackModel;
import com.simibubi.create.foundation.block.ItemUseOverrides;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class CRBlocks {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();
    public static final HashMap<String, BlockStateBlockItemGroup<Couple<String>, SmokestackStyle>> SMOKESTACK_GROUP = new HashMap();
    public static final BlockEntry<SemaphoreBlock> SEMAPHORE = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("semaphore", SemaphoreBlock::new).initialProperties(SharedProperties::softMetal).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/semaphore/block" + ((Boolean)state.m_61143_((Property)SemaphoreBlock.FULL) != false ? "_full" : "") + ((Boolean)state.m_61143_((Property)SemaphoreBlock.FLIPPED) != false ? "_flipped" : "") + ((Boolean)state.m_61143_((Property)SemaphoreBlock.UPSIDE_DOWN) != false ? "_down" : "")))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build())).properties(p -> p.m_155949_(MaterialColor.f_76419_)).properties(p -> p.m_60918_(SoundType.f_56725_)).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SemaphoreDisplayTarget(), (String[])new String[0]))).item(SemaphoreItem::new).transform(ModelGen.customItemModel())).transform(TagGen.axeOnly())).addLayer(() -> RenderType::m_110466_).register();
    public static final BlockEntry<TrackCouplerBlock> TRACK_COUPLER = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_coupler", TrackCouplerBlock::create).initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_60918_(SoundType.f_56725_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{((TrackCouplerBlockEntity.AllowedOperationMode)((Object)((Object)((Object)state.m_61143_(TrackCouplerBlock.MODE))))).m_7912_()})).build(), new Property[]{TrackCouplerBlock.POWERED})).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new TrackCouplerDisplaySource(), (String[])new String[]{"track_coupler_info"}))).lang("Train Coupler").item(TrackCouplerBlockItem.ofType(CREdgePointTypes.COUPLER)).transform(ModelGen.customItemModel((String[])new String[]{"_", "block_both"}))).register();
    public static final BlockEntry<TrackSwitchBlock> ANDESITE_SWITCH = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_switch_andesite", TrackSwitchBlock::manual).initialProperties(SharedProperties::softMetal).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/track_switch_andesite/block"))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build(), new Property[]{TrackSwitchBlock.LOCKED})).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SwitchDisplaySource(), (String[])new String[0]))).onRegister(ItemUseOverrides::addBlock)).lang("Andesite Track Switch").item(TrackSwitchBlockItem.ofType(CREdgePointTypes.SWITCH)).transform(ModelGen.customItemModel())).register();
    public static final BlockEntry<TrackSwitchBlock> BRASS_SWITCH = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_switch_brass", TrackSwitchBlock::automatic).initialProperties(SharedProperties::softMetal).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/track_switch_brass/block"))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build(), new Property[]{TrackSwitchBlock.LOCKED})).properties(p -> p.m_155949_(MaterialColor.f_76384_)).properties(BlockBehaviour.Properties::m_60955_).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SwitchDisplaySource(), (String[])new String[0]))).onRegister(ItemUseOverrides::addBlock)).lang("Brass Track Switch").item(TrackSwitchBlockItem.ofType(CREdgePointTypes.SWITCH)).transform(ModelGen.customItemModel())).register();
    public static final BlockEntry<CasingCollisionBlock> CASING_COLLISION = REGISTRATE.block("casing_collision", CasingCollisionBlock::create).initialProperties(new Material.Builder(MaterialColor.f_76404_).m_76356_().m_76359_()).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().withExistingParent(c.getName(), p.mcLoc("block/air")))).lang("Track Casing Collision Block").register();
    public static final BlockEntry<TrackBlock> ACACIA_TRACK;
    public static final BlockEntry<TrackBlock> BIRCH_TRACK;
    public static final BlockEntry<TrackBlock> CRIMSON_TRACK;
    public static final BlockEntry<TrackBlock> DARK_OAK_TRACK;
    public static final BlockEntry<TrackBlock> JUNGLE_TRACK;
    public static final BlockEntry<TrackBlock> OAK_TRACK;
    public static final BlockEntry<TrackBlock> SPRUCE_TRACK;
    public static final BlockEntry<TrackBlock> WARPED_TRACK;
    public static final BlockEntry<TrackBlock> BLACKSTONE_TRACK;
    public static final BlockEntry<TrackBlock> ENDER_TRACK;
    public static final BlockEntry<TrackBlock> TIELESS_TRACK;
    public static final BlockEntry<TrackBlock> PHANTOM_TRACK;
    public static final BlockEntry<TrackBlock> MANGROVE_TRACK;
    public static final Map<TrackMaterial, NonNullSupplier<TrackBlock>> WIDE_GAUGE_TRACKS;
    public static final Map<TrackMaterial, NonNullSupplier<TrackBlock>> NARROW_GAUGE_TRACKS;
    public static final BlockEntry<TrackBlock> MONORAIL_TRACK;
    public static final BlockEntry<MonoBogeyBlock> MONO_BOGEY;
    public static final BlockEntry<InvisibleBogeyBlock> INVISIBLE_BOGEY;
    public static final BlockEntry<InvisibleMonoBogeyBlock> INVISIBLE_MONO_BOGEY;
    public static final BlockEntry<SingleAxleBogeyBlock> SINGLEAXLE_BOGEY;
    public static final BlockEntry<DoubleAxleBogeyBlock> DOUBLEAXLE_BOGEY;
    @Deprecated
    public static final BlockEntry<DoubleAxleBogeyBlock> LARGE_PLATFORM_DOUBLEAXLE_BOGEY;
    public static final BlockEntry<TripleAxleBogeyBlock> TRIPLEAXLE_BOGEY;
    public static final BlockEntry<WideGaugeBogeyBlock> WIDE_DOUBLEAXLE_BOGEY;
    public static final BlockEntry<WideGaugeBogeyBlock> WIDE_SCOTCH_BOGEY;
    public static final BlockEntry<WideGaugeComicallyLargeBogeyBlock> WIDE_COMICALLY_LARGE_BOGEY;
    public static final BlockEntry<NarrowGaugeBogeyBlock> NARROW_SMALL_BOGEY;
    public static final BlockEntry<NarrowGaugeBogeyBlock> NARROW_SCOTCH_BOGEY;
    public static final BlockEntry<NarrowGaugeBogeyBlock> NARROW_DOUBLE_SCOTCH_BOGEY;
    public static final BlockEntry<HandcarBlock> HANDCAR;
    public static final BlockEntry<MediumBogeyBlock> MEDIUM_BOGEY;
    public static final BlockEntry<MediumTripleWheelBogeyBlock> MEDIUM_TRIPLE_WHEEL;
    public static final BlockEntry<MediumQuadrupleWheelBogeyBlock> MEDIUM_QUADRUPLE_WHEEL;
    public static final BlockEntry<MediumQuintupleWheelBogeyBlock> MEDIUM_QUINTUPLE_WHEEL;
    public static final BlockEntry<Medium202TrailingBogeyBlock> MEDIUM_2_0_2_TRAILING;
    public static final BlockEntry<Medium404TrailingBogeyBlock> MEDIUM_4_0_4_TRAILING;
    public static final BlockEntry<LargeCreateStyle040BogeyBlock> LARGE_CREATE_STYLE_0_4_0;
    public static final BlockEntry<LargeCreateStyle060BogeyBlock> LARGE_CREATE_STYLE_0_6_0;
    public static final BlockEntry<LargeCreateStyle080BogeyBlock> LARGE_CREATE_STYLE_0_8_0;
    public static final BlockEntry<LargeCreateStyle0100BogeyBlock> LARGE_CREATE_STYLE_0_10_0;
    public static final BlockEntry<LargeCreateStyle0120BogeyBlock> LARGE_CREATE_STYLE_0_12_0;
    public static final BlockEntry<ConductorWhistleFlagBlock> CONDUCTOR_WHISTLE_FLAG;
    public static final BlockEntry<SmokeStackBlock> CABOOSESTYLE_STACK;
    public static final BlockEntry<SmokeStackBlock> LONG_STACK;
    public static final BlockEntry<SmokeStackBlock> COALBURNER_STACK;
    public static final BlockEntry<SmokeStackBlock> OILBURNER_STACK;
    public static final BlockEntry<SmokeStackBlock> STREAMLINED_STACK;
    public static final BlockEntry<SmokeStackBlock> WOODBURNER_STACK;
    public static final BlockEntry<DieselSmokeStackBlock> DIESEL_STACK;
    public static final BlockEntry<VentBlock> CONDUCTOR_VENT;
    public static final BlockEntry<StandardTrackBufferBlock> TRACK_BUFFER;
    public static final BlockEntry<NarrowTrackBufferBlock> TRACK_BUFFER_NARROW;
    public static final BlockEntry<MonoTrackBufferBlock> TRACK_BUFFER_MONO;
    public static final BlockEntry<WideTrackBufferBlock> TRACK_BUFFER_WIDE;
    public static final BlockEntry<LinkPinBlock> LINK_AND_PIN;
    public static final BlockStateBlockItemGroup<Void, LinkPinBlock.Style> LINK_AND_PIN_GROUP;
    public static final BlockEntry<GenericDyeableSingleBufferBlock> BIG_BUFFER;
    public static final BlockEntry<GenericDyeableSingleBufferBlock> SMALL_BUFFER;
    public static final BlockEntry<HeadstockBlock> HEADSTOCK;
    public static final BlockStateBlockItemGroup<Boolean, HeadstockStyle> HEADSTOCK_GROUP;
    public static final BlockEntry<CopycatHeadstockBarsBlock> COPYCAT_HEADSTOCK_BARS;
    public static final BlockEntry<CopycatHeadstockBlock> COPYCAT_HEADSTOCK;
    public static final BlockStateBlockItemGroup<Boolean, HeadstockStyle> COPYCAT_HEADSTOCK_GROUP;
    public static final BlockEntry<GenericCrossingBlock> GENERIC_CROSSING;

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material) {
        return CRBlocks.makeTrack(material, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CustomTrackBlockStateGenerator)new CustomTrackBlockStateGenerator()).generate(arg_0, arg_1)));
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen) {
        return CRBlocks.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}));
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister) {
        return CRBlocks.makeTrack(material, blockstateGen, onRegister, p -> p);
    }

    private static BlockEntry<TrackBlock> makeTrack(NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        return CRBlocks.makeTrack(CRTrackMaterials.MONORAIL, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), collectProperties);
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        ArrayList<TagKey> trackTags = new ArrayList<TagKey>();
        trackTags.add(AllTags.AllBlockTags.TRACKS.tag);
        if (material.trackType != CRTrackMaterials.CRTrackType.MONORAIL) {
            trackTags.add(AllTags.AllBlockTags.GIRDABLE_TRACKS.tag);
        }
        ArrayList<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
        if (material == CRTrackMaterials.PHANTOM || material == CRTrackMaterials.getWide(CRTrackMaterials.PHANTOM) || material == CRTrackMaterials.getNarrow(CRTrackMaterials.PHANTOM)) {
            itemTags.add(CRTags.AllItemTags.PHANTOM_TRACK_REVEALING.tag);
        }
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_" + material.resourceName(), arg_0 -> ((TrackMaterial)material).createBlock(arg_0)).initialProperties(Material.f_76278_).properties(p -> ((BlockBehaviour.Properties)collectProperties.apply((BlockBehaviour.Properties)p)).m_155949_(MaterialColor.f_76404_).m_60978_(0.8f).m_60918_(SoundType.f_56743_).m_60955_()).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).blockstate(blockstateGen).tag(new TagKey[]{CommonTags.RELOCATION_NOT_SUPPORTED.forge, CommonTags.RELOCATION_NOT_SUPPORTED.fabric}).tag((TagKey[])trackTags.toArray(TagKey[]::new)).lang(material.langName + " Train Track").onRegister(onRegister)).onRegister(CreateRegistrate.blockModel(() -> TrackModel::new))).onRegister(CRTrackMaterials::addToBlockEntityType)).item(TrackBlockItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Railways.asResource("item/track/" + c.getName())})).tag((TagKey[])itemTags.toArray(TagKey[]::new)).tag(new TagKey[]{AllTags.AllItemTags.TRACKS.tag}).build()).register();
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, VoxelShape shape, boolean emitStationarySmoke) {
        return CRBlocks.makeSmokeStack(variant, type, description, SmokeStackBlock.RotationType.NONE, ShapeWrapper.wrapped(shape), true, emitStationarySmoke);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, VoxelShape shape, boolean spawnExtraSmoke, boolean emitStationarySmoke) {
        return CRBlocks.makeSmokeStack(variant, type, description, SmokeStackBlock.RotationType.NONE, ShapeWrapper.wrapped(shape), spawnExtraSmoke, emitStationarySmoke);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, SmokeStackBlock.RotationType rotType, ShapeWrapper shape, boolean spawnExtraSmoke, boolean emitStationarySmoke) {
        SmokeStackFunction<SmokeStackBlock> blockFunction = SmokeStackBlock::new;
        switch (rotType) {
            case NONE: {
                blockFunction = SmokeStackBlock::new;
                break;
            }
            case AXIS: {
                blockFunction = AxisSmokeStackBlock::new;
                break;
            }
            case FACING: {
                blockFunction = FacingSmokeStackBlock::new;
            }
        }
        return CRBlocks.makeSmokeStack(variant, type, description, shape, spawnExtraSmoke, emitStationarySmoke, (NonNullBiConsumer<DataGenContext<Block, SmokeStackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + ((SmokestackStyle)((Object)state.m_61143_((Property)SmokeStackBlock.STYLE))).getBlockId(), Railways.asResource("block/smokestack/block_" + variant))).texture("0", ((SmokestackStyle)((Object)state.m_61143_((Property)SmokeStackBlock.STYLE))).getTexture(variant))).texture("particle", "#0")).rotationY(rotType == SmokeStackBlock.RotationType.FACING ? ((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360 : (rotType == SmokeStackBlock.RotationType.AXIS ? (state.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X ? 90 : 0) : 0)).build(), new Property[]{AbstractSmokeStackBlock.ENABLED, AbstractSmokeStackBlock.POWERED, AbstractSmokeStackBlock.WATERLOGGED})), blockFunction);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, ShapeWrapper shape, boolean spawnExtraSmoke, boolean emitStationarySmoke, NonNullBiConsumer<DataGenContext<Block, SmokeStackBlock>, RegistrateBlockstateProvider> blockStateProvider, SmokeStackFunction<SmokeStackBlock> blockFunction) {
        TagKey<Item> cycleTag = SmokestackStyle.variantToTagKey(variant);
        BlockEntry BLOCK = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("smokestack_" + variant, p -> blockFunction.create((BlockBehaviour.Properties)p, type, shape, emitStationarySmoke, variant)).initialProperties(SharedProperties::softMetal).blockstate(blockStateProvider).properties(p -> p.m_155949_(MaterialColor.f_76419_)).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new SmokeStackMovementBehaviour(spawnExtraSmoke)))).lang(description).item(BlockStateBlockItem.create(SmokeStackBlock.STYLE, SmokestackStyle.STEEL, true)).lang(description).tab(() -> CRItems.mainCreativeTab).model((c, p) -> p.withExistingParent(c.getName(), Railways.asResource("block/smokestack_" + variant + "_steel"))).tag(new TagKey[]{cycleTag}).onRegisterAfter(Registry.f_122904_, v -> {
            if (!variant.equals("caboosestyle")) {
                ItemDescription.useKey((ItemLike)v, (String)"block.railways.smokestack");
            }
        })).build()).register();
        if (!variant.equals("caboosestyle")) {
            BlockStateBlockItemGroup group = new BlockStateBlockItemGroup((Object)Couple.create((Object)("smokestack_" + variant + "_"), (Object)description), (Property)SmokeStackBlock.STYLE, (BlockStateBlockItemGroup.IStyle[])SmokestackStyle.values(), BLOCK, i -> (ItemBuilder)i.tab(() -> null).onRegisterAfter(Registry.f_122904_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.railways.smokestack")), cycleTag, (BlockStateBlockItemGroup.IStyle)SmokestackStyle.STEEL, null);
            SMOKESTACK_GROUP.put(variant, group);
            group.registerDefaultEntry(SmokestackStyle.STEEL, ItemEntry.cast((RegistryEntry)REGISTRATE.get("smokestack_" + variant, Registry.f_122904_)));
        }
        return BLOCK;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void platformBasedRegistration() {
        CRBlocksImpl.platformBasedRegistration();
    }

    public static void register() {
        CRBlocks.platformBasedRegistration();
    }

    static {
        Railways.registrate().creativeModeTab(() -> CRItems.tracksCreativeTab, "Create Steam 'n' Rails: Tracks");
        ACACIA_TRACK = CRBlocks.makeTrack(CRTrackMaterials.ACACIA);
        BIRCH_TRACK = CRBlocks.makeTrack(CRTrackMaterials.BIRCH);
        CRIMSON_TRACK = CRBlocks.makeTrack(CRTrackMaterials.CRIMSON);
        DARK_OAK_TRACK = CRBlocks.makeTrack(CRTrackMaterials.DARK_OAK);
        JUNGLE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.JUNGLE);
        OAK_TRACK = CRBlocks.makeTrack(CRTrackMaterials.OAK);
        SPRUCE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.SPRUCE);
        WARPED_TRACK = CRBlocks.makeTrack(CRTrackMaterials.WARPED);
        BLACKSTONE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.BLACKSTONE);
        ENDER_TRACK = CRBlocks.makeTrack(CRTrackMaterials.ENDER);
        TIELESS_TRACK = CRBlocks.makeTrack(CRTrackMaterials.TIELESS);
        PHANTOM_TRACK = CRBlocks.makeTrack(CRTrackMaterials.PHANTOM);
        MANGROVE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.MANGROVE);
        WIDE_GAUGE_TRACKS = new HashMap<TrackMaterial, NonNullSupplier<TrackBlock>>();
        NARROW_GAUGE_TRACKS = new HashMap<TrackMaterial, NonNullSupplier<TrackBlock>>();
        ArrayList<TrackMaterial> wideMaterials = new ArrayList<TrackMaterial>(CRTrackMaterials.WIDE_GAUGE.values());
        wideMaterials.sort(Comparator.comparing(t -> t.id));
        for (TrackMaterial wideMaterial : wideMaterials) {
            WIDE_GAUGE_TRACKS.put(wideMaterial, (NonNullSupplier<TrackBlock>)CRBlocks.makeTrack(wideMaterial, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((WideGaugeTrackBlockStateGenerator)new WideGaugeTrackBlockStateGenerator()).generate(arg_0, arg_1))));
        }
        ArrayList<TrackMaterial> narrowMaterials = new ArrayList<TrackMaterial>(CRTrackMaterials.NARROW_GAUGE.values());
        narrowMaterials.sort(Comparator.comparing(t -> t.id));
        for (TrackMaterial narrowMaterial : narrowMaterials) {
            NARROW_GAUGE_TRACKS.put(narrowMaterial, (NonNullSupplier<TrackBlock>)CRBlocks.makeTrack(narrowMaterial, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((NarrowGaugeTrackBlockStateGenerator)new NarrowGaugeTrackBlockStateGenerator()).generate(arg_0, arg_1))));
        }
        MONORAIL_TRACK = CRBlocks.makeTrack((NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((MonorailBlockStateGenerator)new MonorailBlockStateGenerator()).generate(arg_0, arg_1)), BlockBehaviour.Properties::m_60977_);
        Railways.registrate().creativeModeTab(() -> CRItems.mainCreativeTab);
        MONO_BOGEY = ((BlockBuilder)REGISTRATE.block("mono_bogey", MonoBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.monobogey())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).lang("Monorail Bogey").register();
        INVISIBLE_BOGEY = ((BlockBuilder)REGISTRATE.block("invisible_bogey", InvisibleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.invisibleBogey())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).lang("Invisible Bogey").register();
        INVISIBLE_MONO_BOGEY = ((BlockBuilder)REGISTRATE.block("invisible_mono_bogey", InvisibleMonoBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.invisibleMonoBogey())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).lang("Invisible Mono Bogey").register();
        SINGLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("singleaxle_bogey", SingleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Single Axle Bogey").register();
        DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("doubleaxle_bogey", DoubleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Double Axle Bogey").register();
        LARGE_PLATFORM_DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("large_platform_doubleaxle_bogey", DoubleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Large Platform Double Axle Bogey").register();
        TRIPLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("tripleaxle_bogey", TripleAxleBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Triple Axle Bogey").register();
        WIDE_DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("wide_doubleaxle_bogey", WideGaugeBogeyBlock.create(false)).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.wideBogey())).lang("Wide Gauge Double Axle Bogey").register();
        WIDE_SCOTCH_BOGEY = ((BlockBuilder)REGISTRATE.block("wide_scotch_bogey", WideGaugeBogeyBlock.create(true)).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.wideBogey())).lang("Wide Gauge Scotch Yoke Bogey").register();
        WIDE_COMICALLY_LARGE_BOGEY = ((BlockBuilder)REGISTRATE.block("wide_comically_large_bogey", WideGaugeComicallyLargeBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.wideBogey())).lang("Wide Gauge Comically Large Bogey").register();
        NARROW_SMALL_BOGEY = ((BlockBuilder)REGISTRATE.block("narrow_small_bogey", NarrowGaugeBogeyBlock.create(NarrowGaugeBogeyBlock.NarrowGaugeStandardStyle.SMALL)).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.narrowBogey())).lang("Narrow Gauge Small Bogey").register();
        NARROW_SCOTCH_BOGEY = ((BlockBuilder)REGISTRATE.block("narrow_scotch_bogey", NarrowGaugeBogeyBlock.create(NarrowGaugeBogeyBlock.NarrowGaugeStandardStyle.SCOTCH_YOKE)).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.narrowBogey())).lang("Narrow Gauge Scotch Yoke Bogey").register();
        NARROW_DOUBLE_SCOTCH_BOGEY = ((BlockBuilder)REGISTRATE.block("narrow_double_scotch_bogey", NarrowGaugeBogeyBlock.create(NarrowGaugeBogeyBlock.NarrowGaugeStandardStyle.DOUBLE_SCOTCH_YOKE)).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.narrowBogey())).lang("Narrow Gauge Double Scotch Yoke Bogey").register();
        HANDCAR = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("handcar", HandcarBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.handcar())).onRegister(AllInteractionBehaviours.interactionBehaviour((MovingInteractionBehaviour)new HandcarControlsInteractionBehaviour()))).item(HandcarItem::new).properties(p -> p.m_41487_(1)).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Railways.asResource("item/" + c.getName())})).build()).lang("Handcar").register();
        MEDIUM_BOGEY = ((BlockBuilder)REGISTRATE.block("medium_bogey", MediumBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Medium Bogey").register();
        MEDIUM_TRIPLE_WHEEL = ((BlockBuilder)REGISTRATE.block("medium_triple_wheel", MediumTripleWheelBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Medium Triple Wheel Bogey").register();
        MEDIUM_QUADRUPLE_WHEEL = ((BlockBuilder)REGISTRATE.block("medium_quadruple_wheel", MediumQuadrupleWheelBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Medium Quadruple Wheel Bogey").register();
        MEDIUM_QUINTUPLE_WHEEL = ((BlockBuilder)REGISTRATE.block("medium_quintuple_wheel", MediumQuintupleWheelBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Medium Quintuple Wheel Bogey").register();
        MEDIUM_2_0_2_TRAILING = ((BlockBuilder)REGISTRATE.block("medium_2_0_2_trailing", Medium202TrailingBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Medium 2-0-2 Trailing Bogey").register();
        MEDIUM_4_0_4_TRAILING = ((BlockBuilder)REGISTRATE.block("medium_4_0_4_trailing", Medium404TrailingBogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Medium 4-0-4 Trailing Bogey").register();
        LARGE_CREATE_STYLE_0_4_0 = ((BlockBuilder)REGISTRATE.block("large_create_styled_0_4_0", LargeCreateStyle040BogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Large Create Styled 0-4-0").register();
        LARGE_CREATE_STYLE_0_6_0 = ((BlockBuilder)REGISTRATE.block("large_create_styled_0_6_0", LargeCreateStyle060BogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Large Create Styled 0-6-0").register();
        LARGE_CREATE_STYLE_0_8_0 = ((BlockBuilder)REGISTRATE.block("large_create_styled_0_8_0", LargeCreateStyle080BogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Large Create Styled 0-8-0").register();
        LARGE_CREATE_STYLE_0_10_0 = ((BlockBuilder)REGISTRATE.block("large_create_styled_0_10_0", LargeCreateStyle0100BogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Large Create Styled 0-10-0").register();
        LARGE_CREATE_STYLE_0_12_0 = ((BlockBuilder)REGISTRATE.block("large_create_styled_0_12_0", LargeCreateStyle0120BogeyBlock::new).properties(p -> p.m_155949_(MaterialColor.f_76370_)).transform(BuilderTransformers.standardBogey())).lang("Large Create Styled 0-12-0").register();
        CONDUCTOR_WHISTLE_FLAG = ((BlockBuilder)REGISTRATE.block("conductor_whistle", ConductorWhistleFlagBlock::new).initialProperties(SharedProperties::wooden).properties(p -> p.m_155949_(MaterialColor.f_76362_).m_60955_().m_60918_(SoundType.f_56736_).m_60966_().m_222994_().m_60910_()).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"pole"})).build())).lang("Conductor Whistle").item(ConductorWhistleItem::new).transform(ModelGen.customItemModel())).register();
        CABOOSESTYLE_STACK = CRBlocks.makeSmokeStack("caboosestyle", new SmokeStackBlock.SmokeStackType(0.5, 0.625, 0.5), "Caboose Smokestack", SmokeStackBlock.RotationType.AXIS, ShapeWrapper.wrapped(CRShapes.CABOOSE_STACK), false, true);
        LONG_STACK = CRBlocks.makeSmokeStack("long", new SmokeStackBlock.SmokeStackType(0.5, 0.625, 0.5), "Double Smokestack", SmokeStackBlock.RotationType.AXIS, ShapeWrapper.wrapped(CRShapes.LONG_STACK), true, true);
        COALBURNER_STACK = CRBlocks.makeSmokeStack("coalburner", new SmokeStackBlock.SmokeStackType(0.5, 1.0, 0.5), "Coalburner Smokestack", CRShapes.COAL_STACK, true);
        OILBURNER_STACK = CRBlocks.makeSmokeStack("oilburner", new SmokeStackBlock.SmokeStackType(new Vec3(0.5, 0.4, 0.5), new Vec3(0.2, 0.2, 0.2)), "Oilburner Smokestack", SmokeStackBlock.RotationType.NONE, ShapeWrapper.wrapped(CRShapes.OIL_STACK), true, true);
        STREAMLINED_STACK = CRBlocks.makeSmokeStack("streamlined", new SmokeStackBlock.SmokeStackType(new Vec3(0.5, 0.2, 0.5), new Vec3(0.25, 0.2, 0.25)), "Streamlined Smokestack", SmokeStackBlock.RotationType.FACING, ShapeWrapper.wrapped(CRShapes.STREAMLINED_STACK), false, true);
        WOODBURNER_STACK = CRBlocks.makeSmokeStack("woodburner", new SmokeStackBlock.SmokeStackType(0.5, 0.75, 0.5), "Woodburner Smokestack", CRShapes.WOOD_STACK, true);
        DIESEL_STACK = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("smokestack_diesel", p -> new DieselSmokeStackBlock((BlockBehaviour.Properties)p, ShapeWrapper.wrapped(CRShapes.DIESEL_STACK))).initialProperties(SharedProperties::softMetal).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/smokestack/block_diesel_case"))).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
        }, new Property[]{DieselSmokeStackBlock.WATERLOGGED, DieselSmokeStackBlock.ENABLED, DieselSmokeStackBlock.POWERED})).properties(p -> p.m_155949_(MaterialColor.f_76419_)).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(BlockBehaviour.Properties::m_60955_).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new SmokeStackMovementBehaviour(true, false, false)))).lang("Radiator Fan").item().model((c, p) -> p.withExistingParent("item/" + c.getName(), Railways.asResource("block/smokestack/block_diesel"))).build()).register();
        CONDUCTOR_VENT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("conductor_vent", VentBlock::create).transform((NonNullFunction)com.simibubi.create.foundation.data.BuilderTransformers.copycat())).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile((Boolean)state.m_61143_((Property)VentBlock.CONDUCTOR_VISIBLE) != false ? Railways.asResource("block/copycat_vent_visible") : new ResourceLocation("block/air"))).build())).properties(p -> p.m_60960_((state, level, pos) -> false)).onRegister(CreateRegistrate.blockModel(() -> CopycatVentModel::create))).lang("Vent Block").recipe((c, p) -> p.stonecutting(DataIngredient.items((NonNullSupplier)AllBlocks.INDUSTRIAL_IRON_BLOCK, (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)c, 2)).item().transform(ModelGen.customItemModel((String[])new String[]{"copycat_vent"}))).register();
        TRACK_BUFFER = ((BlockBuilder)((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("buffer", StandardTrackBufferBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(BlockBehaviour.Properties::m_60955_).properties(BlockBehaviour.Properties::m_60910_).properties(p -> p.m_60918_(SoundType.f_56725_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((StandardTrackBufferBlock.Style)((Object)((Object)((Object)state.m_61143_(StandardTrackBufferBlock.STYLE))))).getModel())).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state)).build(), new Property[]{StandardTrackBufferBlock.WATERLOGGED})).tag(new TagKey[]{AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.tag}).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.variantBuffer())).lang("Track Buffer").item(TrackBufferBlockItem.ofType(CREdgePointTypes.BUFFER)).transform(BuilderTransformers.variantBufferItem())).transform(ModelGen.customItemModel())).onRegisterAfter(Registry.f_122904_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.railways.track_buffer"))).register();
        TRACK_BUFFER_NARROW = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("buffer_narrow", NarrowTrackBufferBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(BlockBehaviour.Properties::m_60955_).properties(BlockBehaviour.Properties::m_60910_).properties(p -> p.m_60918_(SoundType.f_56725_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((NarrowTrackBufferBlock.Style)((Object)((Object)((Object)state.m_61143_(NarrowTrackBufferBlock.STYLE))))).getModel())).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state)).build(), new Property[]{NarrowTrackBufferBlock.WATERLOGGED})).tag(new TagKey[]{AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.tag}).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.variantBuffer())).lang("Narrow Track Buffer").loot((p, b) -> p.m_124147_((Block)b, (ItemLike)TRACK_BUFFER.get())).register();
        TRACK_BUFFER_MONO = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("buffer_mono", MonoTrackBufferBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(BlockBehaviour.Properties::m_60955_).properties(BlockBehaviour.Properties::m_60910_).properties(p -> p.m_60918_(SoundType.f_56725_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> {
            boolean hanging = (Boolean)state.m_61143_((Property)MonoTrackBufferBlock.UPSIDE_DOWN);
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((MonoTrackBufferBlock.Style)((Object)((Object)((Object)state.m_61143_(MonoTrackBufferBlock.STYLE))))).getModel())).rotationX(hanging ? 180 : 0).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state, hanging ? 0 : 180)).build();
        }, new Property[]{MonoTrackBufferBlock.WATERLOGGED})).tag(new TagKey[]{AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.tag}).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.variantBuffer())).lang("Monorail Track Buffer").loot((p, b) -> p.m_124147_((Block)b, (ItemLike)TRACK_BUFFER.get())).register();
        TRACK_BUFFER_WIDE = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("buffer_wide", WideTrackBufferBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_155949_(MaterialColor.f_76370_)).properties(BlockBehaviour.Properties::m_60955_).properties(BlockBehaviour.Properties::m_60910_).properties(p -> p.m_60918_(SoundType.f_56725_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(Railways.asResource("block/buffer/wide_buffer_stop"))).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state)).build(), new Property[]{WideTrackBufferBlock.WATERLOGGED})).tag(new TagKey[]{AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.tag}).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.variantBuffer())).lang("Wide Track Buffer").loot((p, b) -> p.m_124147_((Block)b, (ItemLike)TRACK_BUFFER.get())).register();
        LINK_AND_PIN = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("link_and_pin", LinkPinBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_154663_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((LinkPinBlock.Style)((Object)state.m_61143_(LinkPinBlock.STYLE))).getModel())).rotationY(((int)((Direction)state.m_61143_((Property)LinkPinBlock.f_54117_)).m_122435_() + 180) % 360).build(), new Property[]{LinkPinBlock.WATERLOGGED})).transform(TagGen.pickaxeOnly())).transform(BuilderTransformers.variantBuffer())).lang("Deco Coupler").register();
        LINK_AND_PIN_GROUP = new BlockStateBlockItemGroup(null, LinkPinBlock.STYLE, (BlockStateBlockItemGroup.IStyle[])LinkPinBlock.Style.values(), LINK_AND_PIN, BuilderTransformers.variantBufferItem(), CRTags.AllItemTags.DECO_COUPLERS.tag, "block.railways.headstock");
        BIG_BUFFER = ((BlockBuilder)((ItemBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("big_buffer", GenericDyeableSingleBufferBlock.createFactory(CRShapes.BIG_BUFFER)).initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_154663_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/buffer/single_deco/big_buffer"))).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state)).build(), new Property[]{GenericDyeableSingleBufferBlock.WATERLOGGED})).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.variantBuffer())).lang("Big Buffer").item().transform(BuilderTransformers.variantBufferItem())).model((c, p) -> p.withExistingParent("item/" + c.getName(), Railways.asResource("block/buffer/single_deco/big_buffer"))).onRegisterAfter(Registry.f_122904_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.railways.buffer"))).build()).register();
        SMALL_BUFFER = ((BlockBuilder)((ItemBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("small_buffer", GenericDyeableSingleBufferBlock.createFactory(CRShapes.SMALL_BUFFER)).initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_154663_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/buffer/single_deco/small_buffer"))).rotationY(TrackBufferBlock.getBaseModelYRotationOf(state)).build(), new Property[]{GenericDyeableSingleBufferBlock.WATERLOGGED})).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.variantBuffer())).lang("Small Buffer").item().transform(BuilderTransformers.variantBufferItem())).model((c, p) -> p.withExistingParent("item/" + c.getName(), Railways.asResource("block/buffer/single_deco/small_buffer"))).onRegisterAfter(Registry.f_122904_, v -> ItemDescription.useKey((ItemLike)v, (String)"block.railways.buffer"))).build()).register();
        HEADSTOCK = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("headstock", HeadstockBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_154663_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((HeadstockStyle)((Object)state.m_61143_(HeadstockBlock.STYLE))).getModel(false, (Boolean)state.m_61143_((Property)HeadstockBlock.UPSIDE_DOWN)))).rotationY(((int)((Direction)state.m_61143_((Property)HeadstockBlock.f_54117_)).m_122435_() + 180) % 360).build(), new Property[]{HeadstockBlock.WATERLOGGED})).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.variantBuffer())).lang("Headstock").register();
        HEADSTOCK_GROUP = new BlockStateBlockItemGroup((Object)false, HeadstockBlock.STYLE, (BlockStateBlockItemGroup.IStyle[])HeadstockStyle.values(), HEADSTOCK, BuilderTransformers.variantBufferItem(), CRTags.AllItemTags.WOODEN_HEADSTOCKS.tag, "block.railways.headstock_wood");
        COPYCAT_HEADSTOCK_BARS = ((BlockBuilder)REGISTRATE.block("copycat_headstock_bars", CopycatHeadstockBarsBlock::new).transform(BuilderTransformers.copycatHeadstockBars())).register();
        COPYCAT_HEADSTOCK = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("copycat_headstock", CopycatHeadstockBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.m_60918_(SoundType.f_154663_)).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(((HeadstockStyle)((Object)state.m_61143_(CopycatHeadstockBlock.STYLE))).getModel(true, (Boolean)state.m_61143_((Property)CopycatHeadstockBlock.UPSIDE_DOWN)))).rotationY(((int)((Direction)state.m_61143_((Property)CopycatHeadstockBlock.FACING)).m_122435_() + 180) % 360).build(), new Property[]{CopycatHeadstockBlock.WATERLOGGED})).transform(TagGen.axeOrPickaxe())).transform(BuilderTransformers.copycatHeadstock())).lang("Copycat Headstock").register();
        COPYCAT_HEADSTOCK_GROUP = new BlockStateBlockItemGroup((Object)true, CopycatHeadstockBlock.STYLE, (BlockStateBlockItemGroup.IStyle[])HeadstockStyle.values(), COPYCAT_HEADSTOCK, BuilderTransformers.copycatHeadstockItem(), CRTags.AllItemTags.COPYCAT_HEADSTOCKS.tag, "block.railways.headstock");
        GENERIC_CROSSING = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("generic_crossing", GenericCrossingBlock::new).transform(BuilderTransformers.genericCrossing())).initialProperties(Material.f_76278_).properties(p -> p.m_155949_(MaterialColor.f_76404_).m_60978_(0.8f).m_60918_(SoundType.f_56743_).m_60955_().m_222994_()).tag(new TagKey[]{AllTags.AllBlockTags.TRACKS.tag}).tag(new TagKey[]{AllTags.AllBlockTags.GIRDABLE_TRACKS.tag}).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().withExistingParent(c.getName(), p.modLoc("block/invisible")))).lang("Generic Crossing").register();
    }

    @FunctionalInterface
    private static interface SmokeStackFunction<T extends SmokeStackBlock> {
        public T create(BlockBehaviour.Properties var1, SmokeStackBlock.SmokeStackType var2, ShapeWrapper var3, boolean var4, String var5);
    }
}

