/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum CRGuiTextures implements ScreenElement
{
    TRAIN_HUD_SWITCH_BRASS("widgets", 0, 0, 42, 16),
    TRAIN_HUD_SWITCH_ANDESITE("widgets", 0, 16, 42, 16),
    TRAIN_HUD_SWITCH_LEFT("widgets", 1, 33, 10, 10),
    TRAIN_HUD_SWITCH_STRAIGHT("widgets", 13, 33, 10, 10),
    TRAIN_HUD_SWITCH_RIGHT("widgets", 25, 33, 10, 10),
    TRAIN_HUD_SWITCH_LEFT_WRONG("widgets", 1, 45, 10, 10),
    TRAIN_HUD_SWITCH_STRAIGHT_WRONG("widgets", 13, 45, 10, 10),
    TRAIN_HUD_SWITCH_RIGHT_WRONG("widgets", 25, 45, 10, 10),
    TRAIN_HUD_SWITCH_LOCKED("widgets", 37, 45, 10, 10),
    BOGEY_MENU("bogeymenu", 279, 184),
    BOGEY_MENU_SCROLL_BAR("bogeymenu", 280, 0, 8, 15),
    BOGEY_MENU_SCROLL_BAR_DISABLED("bogeymenu", 288, 0, 8, 15);

    public static final int FONT_COLOR = 5726074;
    public final ResourceLocation location;
    public final int width;
    public final int height;
    public final int startX;
    public final int startY;

    private CRGuiTextures(String location, int width, int height) {
        this(location, 0, 0, width, height);
    }

    private CRGuiTextures(int startX, int startY) {
        this("icons", startX * 16, startY * 16, 16, 16);
    }

    private CRGuiTextures(String location, int startX, int startY, int width, int height) {
        this("railways", location, startX, startY, width, height);
    }

    private CRGuiTextures(String namespace, String location, int startX, int startY, int width, int height) {
        this.location = new ResourceLocation(namespace, "textures/gui/" + location + ".png");
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startY = startY;
    }

    public static CRGuiTextures getForSwitch(TrackSwitchBlock.SwitchState switchState, boolean isWrong) {
        if (isWrong) {
            return switch (switchState) {
                default -> throw new IncompatibleClassChangeError();
                case TrackSwitchBlock.SwitchState.NORMAL -> TRAIN_HUD_SWITCH_STRAIGHT_WRONG;
                case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> TRAIN_HUD_SWITCH_RIGHT_WRONG;
                case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> TRAIN_HUD_SWITCH_LEFT_WRONG;
            };
        }
        return switch (switchState) {
            default -> throw new IncompatibleClassChangeError();
            case TrackSwitchBlock.SwitchState.NORMAL -> TRAIN_HUD_SWITCH_STRAIGHT;
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> TRAIN_HUD_SWITCH_RIGHT;
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> TRAIN_HUD_SWITCH_LEFT;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, int x, int y) {
        this.bind();
        GuiComponent.m_93143_((PoseStack)ms, (int)x, (int)y, (int)0, (float)this.startX, (float)this.startY, (int)this.width, (int)this.height, (int)256, (int)256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, int x, int y, int textureWidth, int textureHeight) {
        this.bind();
        GuiComponent.m_93133_((PoseStack)ms, (int)x, (int)y, (float)this.startX, (float)this.startY, (int)this.width, (int)this.height, (int)textureWidth, (int)textureHeight);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, int x, int y, GuiComponent component) {
        this.bind();
        component.m_93228_(ms, x, y, this.startX, this.startY, this.width, this.height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, int x, int y, Color c) {
        this.bind();
        UIRenderHelper.drawColoredTexture((PoseStack)ms, (Color)c, (int)x, (int)y, (int)this.startX, (int)this.startY, (int)this.width, (int)this.height);
    }
}

