/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.ic2cuumatter.integration.jei;

import com.christofmeg.ic2cuumatter.integration.jei.GuiClickableArea;
import com.christofmeg.ic2cuumatter.integration.jei.MassFabricatorCategory;
import com.christofmeg.ic2cuumatter.integration.jei.PlasmafierCategory;
import ic2.core.block.machines.containers.ev.PlasmafierContainer;
import ic2.core.block.machines.containers.hv.MassFabricatorContainer;
import ic2.core.inventory.gui.IC2Screen;
import ic2.core.platform.registries.IC2Blocks;
import ic2.core.platform.registries.IC2Items;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ic2cuumatter", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MassFabricatorCategory(registration.getJeiHelpers().getGuiHelper(), (ItemLike)IC2Blocks.MASS_FABRICATOR), new PlasmafierCategory(registration.getJeiHelpers().getGuiHelper(), PlasmafierContainer.TEXTURE, (ItemLike)IC2Blocks.PLASMAFIER)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(MassFabricatorCategory.TYPE, MassFabricatorCategory.MassFabricatorRecipe.getMassFabricatorRecipes());
        registration.addRecipes(PlasmafierCategory.TYPE, List.of(new PlasmafierCategory.PlasmafierRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)IC2Items.UUMATTER, 10)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{IC2Items.CELL_EMPTY}), new ItemStack((ItemLike)IC2Items.CELL_PLASMA))));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IC2Blocks.MASS_FABRICATOR), new RecipeType[]{MassFabricatorCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)IC2Blocks.PLASMAFIER), new RecipeType[]{PlasmafierCategory.TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(IC2Screen.class, (IGuiContainerHandler)new GuiClickableArea());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        int mrecipeSlotStart = 0;
        int mrecipeSlotCount = 1;
        int minventorySlotStart = 2;
        int minventorySlotCount = 41;
        registration.addRecipeTransferHandler(MassFabricatorContainer.class, null, MassFabricatorCategory.TYPE, mrecipeSlotStart, mrecipeSlotCount, minventorySlotStart, minventorySlotCount);
        int recipeSlotStart = 0;
        int recipeSlotCount = 2;
        int inventorySlotStart = 2;
        int inventorySlotCount = 42;
        registration.addRecipeTransferHandler(PlasmafierContainer.class, null, PlasmafierCategory.TYPE, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
    }
}

