/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blockentity;

import ic2.api.network.buffer.NetworkInfo;
import ic2.api.recipes.ingridients.recipes.IRecipeOutput;
import ic2.api.recipes.registries.IMachineRecipeList;
import ic2.api.tiles.IInputMachine;
import ic2.api.util.DirectionList;
import ic2.core.inventory.container.IC2Container;
import ic2.core.inventory.filter.IFilter;
import ic2.core.inventory.filter.SpecialFilters;
import ic2.core.inventory.filter.special.ElectricItemFilter;
import ic2.core.inventory.filter.special.MachineFilter;
import ic2.core.inventory.handler.AccessRule;
import ic2.core.inventory.handler.InventoryHandler;
import ic2.core.inventory.handler.SlotType;
import ic2.core.platform.registries.IC2Sounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import trinsdar.ic2c_extras.blockentity.BlockEntityMultiOutput;
import trinsdar.ic2c_extras.container.ContainerThermalCentrifuge;
import trinsdar.ic2c_extras.init.ModBlocks;
import trinsdar.ic2c_extras.recipes.MachineRecipes;

public class BlockEntityThermalCentrifuge
extends BlockEntityMultiOutput {
    @NetworkInfo
    public int maxHeat = 500;
    @NetworkInfo
    public int heat;
    private static final int defaultEu = 48;
    public static final String neededHeat = "minHeat";

    public BlockEntityThermalCentrifuge(BlockPos pos, BlockState state) {
        super(pos, state, 5, 2, 48, 200, 128);
        this.addGuiFields(new String[]{"heat", "maxHeat"});
    }

    public float getHeat() {
        return this.heat;
    }

    public float getMaxHeat() {
        if (this.lastRecipe == null) {
            return 500.0f;
        }
        return BlockEntityThermalCentrifuge.getRequiredHeat(this.lastRecipe.getOutput());
    }

    public ResourceLocation getTexture() {
        return ContainerThermalCentrifuge.GUI_TEXTURE;
    }

    protected void addSlotInfo(InventoryHandler handler) {
        handler.registerBlockSides(DirectionList.ALL);
        handler.registerBlockAccess(DirectionList.ALL, AccessRule.BOTH);
        handler.registerSlotAccess(AccessRule.BOTH, new int[]{0});
        handler.registerSlotAccess(AccessRule.IMPORT, new int[]{1});
        handler.registerSlotAccess(AccessRule.EXPORT, new int[]{2, 3, 4});
        handler.registerSlotsForSide(DirectionList.DOWN.invert(), new int[]{1});
        handler.registerSlotsForSide(DirectionList.UP.invert(), new int[]{0, 2, 3, 4});
        handler.registerInputFilter(SpecialFilters.createChargeFilter(), new int[]{0});
        handler.registerOutputFilter(ElectricItemFilter.NOT_DISCHARGE_FILTER, new int[]{0});
        handler.registerInputFilter((IFilter)new MachineFilter((IInputMachine)this), new int[]{1});
        handler.registerInputFilter(SpecialFilters.ALWAYS_FALSE, new int[]{2, 3, 4});
        handler.registerNamedSlot(SlotType.BATTERY, new int[]{0});
        handler.registerNamedSlot(SlotType.INPUT, new int[]{1});
        handler.registerNamedSlot(SlotType.OUTPUT, new int[]{2, 3, 4});
    }

    public ResourceLocation getWorkingSound() {
        return IC2Sounds.EXTRACTOR_PROCESSING;
    }

    public IC2Container createContainer(Player player, InteractionHand hand, Direction side, int windowID) {
        return new ContainerThermalCentrifuge(this, player, windowID);
    }

    public IMachineRecipeList getRecipeList() {
        return MachineRecipes.THERMAL_CENTRIFUGE;
    }

    public BlockEntityType<?> createType() {
        return ModBlocks.THERMAL_CENTRIFUGE_TYPE;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2, 3, 4};
    }

    public boolean canProcess() {
        return this.heat >= this.maxHeat && super.canProcess();
    }

    public void onTick() {
        super.onTick();
        if ((this.lastRecipe != null && !((ItemStack)this.inventory.get(1)).m_41619_() || this.isRedstonePowered()) && this.energy > 0) {
            int newMaxHeat = (int)this.getMaxHeat();
            if (newMaxHeat != this.maxHeat) {
                this.maxHeat = newMaxHeat;
                this.updateGuiField("maxHeat");
            }
            boolean maxHeatCheck = false;
            if (this.heat < this.maxHeat) {
                ++this.heat;
                maxHeatCheck = true;
                this.updateGuiField("heat");
            }
            if (this.heat == this.maxHeat && maxHeatCheck) {
                this.rebuildCache = true;
                maxHeatCheck = false;
            }
            if (this.heat > this.maxHeat) {
                this.heat = this.maxHeat;
                this.rebuildCache = true;
                this.updateGuiField("heat");
            }
            this.useEnergy(1);
        } else if (this.heat > 0) {
            int newMaxHeat = 500;
            if (newMaxHeat != this.maxHeat) {
                this.maxHeat = newMaxHeat;
                this.updateGuiField("maxHeat");
            }
            this.heat -= Math.min(this.heat, 4);
            this.updateGuiField("heat");
        }
    }

    protected boolean canStopTicking(boolean charging) {
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.heat = compound.m_128451_("heat");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("heat", this.heat);
    }

    public static int getRequiredHeat(IRecipeOutput output) {
        if (output == null) {
            return 1;
        }
        return output.getMetadata().m_128451_("heat");
    }
}

