/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.recipes.recipelists;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ic2.api.recipes.ingridients.inputs.FluidInput;
import ic2.api.recipes.ingridients.inputs.IInput;
import ic2.api.recipes.ingridients.recipes.IFluidRecipeOutput;
import ic2.api.recipes.ingridients.recipes.IRecipeOutput;
import ic2.api.recipes.ingridients.recipes.SimpleFluidOutput;
import ic2.api.recipes.registries.IListenableRegistry;
import ic2.api.recipes.registries.IMachineRecipeList;
import ic2.core.block.machines.recipes.IRecipeList;
import ic2.core.platform.recipes.misc.IngredientRegistry;
import ic2.core.utils.collection.CollectionUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeList
implements IListenableRegistry<FermenterRecipeList>,
IRecipeList {
    Map<ResourceLocation, IMachineRecipeList.RecipeEntry> recipes = CollectionUtils.createLinkedMap();
    Map<Fluid, IMachineRecipeList.RecipeEntry> recipeMap;
    boolean mapped;
    List<Consumer<FermenterRecipeList>> listeners = ObjectLists.synchronize((ObjectList)CollectionUtils.createList());

    public FermenterRecipeList(Consumer<FermenterRecipeList> listener) {
        this.listeners.add(listener);
        this.recipeMap = CollectionUtils.createLinkedMap();
        this.mapped = false;
    }

    public void registerListener(Consumer<FermenterRecipeList> consumer) {
        if (consumer != null) {
            this.listeners.add(consumer);
        }
    }

    public IMachineRecipeList.RecipeEntry removeRecipe(ResourceLocation location) {
        return this.recipes.remove(location);
    }

    private void addRecipe(IMachineRecipeList.RecipeEntry recipeEntry) {
        IInput[] inputs = recipeEntry.getInputs();
        if (!(recipeEntry.getOutput() instanceof IFluidRecipeOutput) || inputs == null || inputs.length != 1 || !(inputs[0] instanceof FluidInput)) {
            throw new RuntimeException("Recipe Is Invalid: " + String.valueOf(recipeEntry.getLocation()));
        }
        this.recipes.put(recipeEntry.getLocation(), recipeEntry);
    }

    public void addRecipe(ResourceLocation id, FluidStack fluidInput, FluidStack fluidOutput, int totalProgress) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("totalProgress", totalProgress);
        this.addRecipe(new IMachineRecipeList.RecipeEntry(id, (IRecipeOutput)new SimpleFluidOutput(Collections.emptyList(), List.of(fluidOutput), data), new IInput[]{new FluidInput(fluidInput)}));
    }

    public void writeRecipes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.recipes.size());
        for (IMachineRecipeList.RecipeEntry entry : this.recipes.values()) {
            buffer.m_130085_(entry.getLocation());
            IngredientRegistry.INSTANCE.writeRecipeOutput(entry.getOutput(), buffer);
            buffer.writeByte(entry.getInputs().length);
            for (IInput input : entry.getInputs()) {
                IngredientRegistry.INSTANCE.writeInput(input, buffer);
            }
        }
    }

    public void readRecipes(FriendlyByteBuf buffer) {
        Object2ObjectSortedMap recipes = CollectionUtils.createLinkedMap();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation location = buffer.m_130281_();
            IRecipeOutput output = IngredientRegistry.INSTANCE.createOutput(buffer);
            IInput[] inputs = new IInput[buffer.readByte()];
            for (int j = 0; j < inputs.length; ++j) {
                inputs[j] = IngredientRegistry.INSTANCE.readInput(buffer);
            }
            recipes.put(location, new IMachineRecipeList.RecipeEntry(location, output, inputs));
        }
        this.mapped = false;
        this.recipes = recipes;
        this.recipeMap = CollectionUtils.createLinkedMap();
    }

    public Map<ResourceLocation, JsonObject> writeRecipes() {
        Object2ObjectSortedMap result = CollectionUtils.createLinkedMap();
        for (IMachineRecipeList.RecipeEntry entry : this.recipes.values()) {
            JsonObject obj = new JsonObject();
            if (entry.getInputs().length <= 1) {
                obj.add("input", (JsonElement)IngredientRegistry.INSTANCE.serializeInput(entry.getInputs()[0]));
            } else {
                JsonArray inputs = new JsonArray();
                for (IInput input : entry.getInputs()) {
                    inputs.add((JsonElement)IngredientRegistry.INSTANCE.serializeInput(input));
                }
                obj.add("input", (JsonElement)inputs);
            }
            obj.add("output", (JsonElement)IngredientRegistry.INSTANCE.serializeOutput(entry.getOutput()));
            result.put(entry.getLocation(), obj);
        }
        return result;
    }

    public void readRecipe(ResourceLocation id, JsonObject data) {
        if (IRecipeList.isRemover((JsonObject)data)) {
            IRecipeList.getEntriesToRemove((JsonObject)data, this::removeRecipe);
        } else {
            ObjectList inputs = CollectionUtils.createList();
            IRecipeList.iterateObject((JsonElement)data.get("input"), arg_0 -> FermenterRecipeList.lambda$readRecipe$0((List)inputs, arg_0));
            if (inputs.isEmpty()) {
                throw new RuntimeException("Inputs are empty");
            }
            IRecipeOutput out = IngredientRegistry.INSTANCE.readOutput(GsonHelper.m_13930_((JsonObject)data, (String)"output"));
            if (out == null) {
                throw new RuntimeException("Output is Empty");
            }
            this.addRecipe(new IMachineRecipeList.RecipeEntry(id, out, (IInput[])inputs.toArray(IInput[]::new)));
        }
    }

    private static /* synthetic */ void lambda$readRecipe$0(List inputs, JsonObject T) {
        inputs.add(IngredientRegistry.INSTANCE.readInput(T));
    }
}

