/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.trade;

import ic2.api.items.ICoinItem;
import ic2.api.items.ItemRegistries;
import ic2.core.block.personal.trade.Trade;
import ic2.core.inventory.filter.StackFilter;
import ic2.core.inventory.inv.SimpleInventory;
import ic2.core.inventory.transporter.IItemTransporter;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemTrade
extends Trade {
    public SimpleInventory offered = new SimpleInventory(4);

    @Override
    public boolean canDoPerPlayer() {
        return true;
    }

    public boolean hasStock(IItemTransporter transporter, int filter, NonNullList<ItemStack> result) {
        int amount = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.offered.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ++amount;
            if (this.infinite) {
                result.add((Object)stack.m_41777_());
                continue;
            }
            if (stack.m_41720_() instanceof ICoinItem) {
                if (this.extractCoinValue(transporter, this.getCoinValue(stack), result)) continue;
                return false;
            }
            ItemStack fetched = transporter.removeItem(new StackFilter(stack, filter), null, stack.m_41613_(), false);
            if (fetched.m_41613_() < stack.m_41613_()) {
                return false;
            }
            result.add((Object)fetched);
        }
        return amount > 0;
    }

    private int getCoinValue(ItemStack stack) {
        int n;
        Item item = stack.m_41720_();
        if (item instanceof ICoinItem) {
            ICoinItem item2 = (ICoinItem)item;
            n = item2.getMoneyValue(stack);
        } else {
            n = 0;
        }
        return n;
    }

    public boolean extractCoinValue(IItemTransporter transporter, int coinValue, NonNullList<ItemStack> extract) {
        Object2IntMap<ItemStack> map = transporter.getAllItems(null, false);
        ItemStack filter = ItemStack.f_41583_;
        int count = 0;
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            ItemStack stack = (ItemStack)entry.getKey();
            Item item = stack.m_41720_();
            if (!(item instanceof ICoinItem)) continue;
            ICoinItem coin = (ICoinItem)item;
            int amount = entry.getIntValue();
            int value = coin.getMoneyValue(stack);
            if (value <= 0) continue;
            int toExtract = Math.max(1, Mth.m_14167_((float)((float)coinValue / (float)value)));
            if (value * amount < coinValue || !filter.m_41619_() && count <= toExtract) continue;
            filter = stack;
            count = toExtract;
        }
        if (count > 0) {
            int totalExtracted = 0;
            for (int iterations = 0; count > 0 && iterations < 100; ++iterations) {
                ItemStack extracted = transporter.removeItem(StackFilter.defaultCompare(filter), null, count, false);
                int amount = this.getCoinValue(extracted);
                count -= extracted.m_41613_();
                totalExtracted += amount * extracted.m_41613_();
            }
            if (totalExtracted > coinValue) {
                NonNullList<ItemStack> result = ItemRegistries.generateCoins(totalExtracted - coinValue, (NonNullList<ItemStack>)NonNullList.m_122779_(), false);
                int m = result.size();
                for (int i = 0; i < m; ++i) {
                    transporter.addItem((ItemStack)result.get(i), null, false);
                }
            }
            ItemRegistries.generateCoins(coinValue, extract, false);
            return count <= 0;
        }
        return false;
    }

    @Override
    public CompoundTag save(CompoundTag nbt) {
        super.save(nbt);
        CompoundTag data = this.offered.save(new CompoundTag());
        if (!data.m_128456_()) {
            nbt.m_128365_("offered", (Tag)data);
        }
        return nbt;
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.offered.load(nbt.m_128469_("offered"));
    }
}

