/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.transport.item;

import ic2.core.item.tool.WikiItem;
import ic2.core.platform.registries.IC2Blocks;
import ic2.core.utils.collection.CollectionUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public final class TubeAction {
    private static final Map<String, TubeAction> MAPPED_ACTIONS = CollectionUtils.createMap();
    private static final List<TubeAction> LISTED_ACTIONS = CollectionUtils.createList();
    public static final TubeAction BLOCK_OUTPUT = new TubeAction("block_output", List.of(IC2Blocks.DIRECTIONAL_TUBE));
    public static final TubeAction EXTRA_EXTRACTION_SIDE = new TubeAction("extra_extraction", List.of(IC2Blocks.EXTRACTOR_TUBE, IC2Blocks.FILTERED_EXTRACTION_TUBE));
    public static final TubeAction REDSTONE_CONTROL = new TubeAction("redstone_control", List.of(IC2Blocks.EXTRACTOR_TUBE, IC2Blocks.FILTERED_EXTRACTION_TUBE, IC2Blocks.REQUEST_TUBE));
    public static final TubeAction OUTPUT_PRIORITY = new TubeAction("out_priority", List.of(IC2Blocks.EXTRACTOR_TUBE, IC2Blocks.FILTERED_EXTRACTION_TUBE, IC2Blocks.PROVIDER_TUBE, IC2Blocks.STICKY_TUBE));
    public static final TubeAction ONLY_EXISTING = new TubeAction("only_existing", List.of(IC2Blocks.INSERTION_TUBE));
    public static final TubeAction SPECIAL_EXTRACTION_CONNECTIVITY = new TubeAction("special_connection", List.of(IC2Blocks.EXTRACTOR_TUBE, IC2Blocks.FILTERED_EXTRACTION_TUBE, IC2Blocks.STICKY_TUBE));
    public static final TubeAction PULSE = new TubeAction("pulse", List.of(IC2Blocks.EXTRACTOR_TUBE, IC2Blocks.FILTERED_EXTRACTION_TUBE));
    public static final TubeAction COMPARATOR = new TubeAction("comparator", List.of(IC2Blocks.EXTRACTOR_TUBE, IC2Blocks.FILTERED_EXTRACTION_TUBE));
    public static final TubeAction LARGE_PICKUP_RADIUS = new TubeAction("pickup_radius", List.of(IC2Blocks.PICKUP_TUBE));
    public static final TubeAction VISIBLE_ITEMS = new TubeAction("visible_items", Collections.emptyList());
    private static final String TOOLTIP_PATH = "tooltip.item.ic2.tube_tool.";
    private static final MutableComponent MODEL_LIST = TubeAction.buildList(Component.m_237115_((String)"tooltip.item.ic2.tube_tool.mode_list.header"), TubeAction.getAll().stream().map(TubeAction::getName).toList(), false).m_130940_(ChatFormatting.GRAY);
    String id;
    List<MutableComponent> applicableItems;
    MutableComponent name;
    MutableComponent desc;
    MutableComponent applicable;

    public TubeAction(String id, List<Block> applicableTubes) {
        this.id = id;
        this.name = Component.m_237115_((String)(TOOLTIP_PATH + id));
        this.desc = Component.m_237115_((String)(TOOLTIP_PATH + id + ".desc")).m_130940_(ChatFormatting.DARK_GRAY);
        this.applicableItems = applicableTubes.stream().map(this::createBlock).collect(Collectors.toList());
        if (this.applicableItems.isEmpty()) {
            this.applicableItems.add(Component.m_237115_((String)"tooltip.item.ic2.tube_tool.tube_list.all"));
        }
        this.applicable = Component.m_237113_((String)"\n").m_7220_((Component)TubeAction.buildList(Component.m_237115_((String)"tooltip.item.ic2.tube_tool.tube_list.header"), this.applicableItems, false)).m_130940_(ChatFormatting.GRAY);
        MAPPED_ACTIONS.put(id, this);
        LISTED_ACTIONS.add(this);
    }

    public String getId() {
        return this.id;
    }

    public MutableComponent getName() {
        return this.name.m_6881_();
    }

    public MutableComponent getDesc() {
        return this.desc.m_6881_();
    }

    public MutableComponent getApplicable() {
        return this.applicable.m_6881_();
    }

    public MutableComponent getWikiApplicable() {
        return Component.m_237113_((String)"\n").m_7220_((Component)TubeAction.buildList(Component.m_237115_((String)"tooltip.item.ic2.tube_tool.tube_list.header"), this.applicableItems, true)).m_130940_(ChatFormatting.BLACK);
    }

    private MutableComponent createBlock(Block block) {
        MutableComponent text = block.m_49954_();
        Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, "redirect;" + WikiItem.getPreviewLocation(ForgeRegistries.ITEMS.getKey((Object)block.m_5456_()))));
        return text.m_130948_(style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"tooltip.ic2.open").m_7220_((Component)text.m_6881_()))));
    }

    private static MutableComponent buildList(MutableComponent headline, List<MutableComponent> items, boolean bold) {
        if (items.isEmpty()) {
            return Component.m_237119_();
        }
        MutableComponent result = Component.m_237119_().m_130940_(bold ? ChatFormatting.BOLD : ChatFormatting.RESET);
        result.m_7220_((Component)headline.m_6879_().m_130940_(ChatFormatting.BOLD));
        items.forEach(i -> result.m_130946_("\n - ").m_7220_((Component)i.m_6881_()));
        return result;
    }

    public static MutableComponent getModeList() {
        return MODEL_LIST;
    }

    public static TubeAction byId(String id) {
        return MAPPED_ACTIONS.get(id);
    }

    public static List<TubeAction> getAll() {
        return ObjectArrayList.wrap((Object[])((TubeAction[])LISTED_ACTIONS.toArray(TubeAction[]::new)));
    }

    public static TubeAction byIdOrDefault(String id) {
        if (id == null || id.trim().isEmpty()) {
            return LISTED_ACTIONS.get(0);
        }
        return MAPPED_ACTIONS.get(id);
    }

    public static TubeAction getNextAction(String id) {
        if (id == null || id.trim().isEmpty()) {
            return LISTED_ACTIONS.get(0);
        }
        TubeAction action = MAPPED_ACTIONS.get(id);
        return LISTED_ACTIONS.get((LISTED_ACTIONS.indexOf(action) + 1) % LISTED_ACTIONS.size());
    }
}

