/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.tiles.ICopyableSettings;
import ic2.core.IC2;
import ic2.core.inventory.handler.IHasInventoryHandler;
import ic2.core.inventory.handler.InventoryHandler;
import ic2.core.item.base.IC2SimpleItem;
import ic2.core.item.base.PropertiesBuilder;
import ic2.core.platform.player.KeyHelper;
import ic2.core.platform.registries.ForgeRegistryWrapper;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.tooltips.ToolTipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CopyTool
extends IC2SimpleItem {
    public CopyTool() {
        super("copy_tool", new PropertiesBuilder().maxStackSize(1), "tools", "copy_tool");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addToolTip(ItemStack stack, Player player, TooltipFlag type, ToolTipHelper helper) {
        super.addToolTip(stack, player, type, helper);
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.MODE_KEY, "tooltip.item.ic2.copy_tool.mode_key", new Object[0]));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.ALT_KEY, "tooltip.item.ic2.copy_tool.toClear", new Object[0]));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.BLOCK_CLICK, "tooltip.item.ic2.copy_tool.toApply", new Object[0]));
        helper.addKeybindingTooltip(this.buildKeyDescription(KeyHelper.BLOCK_CLICK, KeyHelper.SNEAK_KEY, "tooltip.item.ic2.copy_tool.toCopy", new Object[0]));
        helper.addSimpleToolTip("tooltip.item.ic2.copy_tool.mode", this.translate(this.isInvSettings(stack) ? "tooltip.item.ic2.copy_tool.mode.settings" : "tooltip.item.ic2.copy_tool.mode.inv"));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (IC2.KEYBOARD.isAltKeyDown(player)) {
            ItemStack stack = player.m_21120_(hand);
            stack.m_41751_(null);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (IC2.KEYBOARD.isModeSwitchKeyDown(player)) {
            CompoundTag tag;
            ItemStack stack = player.m_21120_(hand);
            tag.m_128379_("inv_mode", !(tag = stack.m_41784_()).m_128471_("inv_mode"));
            if (!level.m_5776_()) {
                player.m_213846_((Component)this.translate("tooltip.item.ic2.copy_tool.mode_switch", new Object[]{this.translate(this.isInvSettings(stack) ? "tooltip.item.ic2.copy_tool.mode.settings" : "tooltip.item.ic2.copy_tool.mode.inv")}));
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean isInvSettings(ItemStack stack) {
        return !StackUtil.getNbtData(stack).m_128471_("inv_mode");
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity entity = level.m_7702_(pos);
        if (this.isInvSettings(stack)) {
            IHasInventoryHandler invHandler;
            if (entity instanceof IHasInventoryHandler && (invHandler = (IHasInventoryHandler)entity).allowsUI() && invHandler.getInventoryHandler() != null) {
                InventoryHandler handler = invHandler.getInventoryHandler();
                if (context.m_7078_()) {
                    CompoundTag tag = new CompoundTag();
                    handler.saveSettings(tag);
                    stack.m_41700_(ForgeRegistryWrapper.getBlockEntityTypeKey(entity.m_58903_()).toString() + ".inv", (Tag)tag);
                    if (!level.m_5776_()) {
                        context.m_43723_().m_213846_((Component)this.translate("tooltip.item.ic2.copy_tool.copied"));
                    }
                    return InteractionResult.SUCCESS;
                }
                String id = ForgeRegistryWrapper.getBlockEntityTypeKey(entity.m_58903_()).toString() + ".inv";
                if (stack.m_41783_() == null || !stack.m_41783_().m_128441_(id)) {
                    if (!level.m_5776_()) {
                        context.m_43723_().m_213846_((Component)this.translate("tooltip.item.ic2.copy_tool.nothing_to_applied"));
                    }
                    return InteractionResult.FAIL;
                }
                handler.loadSettings(stack.m_41737_(id));
                if (!level.m_5776_()) {
                    context.m_43723_().m_213846_((Component)this.translate("tooltip.item.ic2.copy_tool.applied"));
                }
                return InteractionResult.SUCCESS;
            }
            if (context.m_43723_() != null) {
                if (!level.m_5776_()) {
                    context.m_43723_().m_213846_((Component)this.translate(context.m_7078_() ? "tooltip.item.ic2.copy_tool.nothing_to_copy" : "tooltip.item.ic2.copy_tool.nothing_to_applied"));
                }
                return InteractionResult.FAIL;
            }
        } else {
            if (entity instanceof ICopyableSettings) {
                ICopyableSettings settings = (ICopyableSettings)entity;
                if (context.m_7078_()) {
                    CompoundTag tag = new CompoundTag();
                    settings.saveSettings(tag);
                    stack.m_41700_(ForgeRegistryWrapper.getBlockEntityTypeKey(entity.m_58903_()).toString() + ".settings", (Tag)tag);
                    if (!level.m_5776_()) {
                        context.m_43723_().m_213846_((Component)this.translate("tooltip.item.ic2.copy_tool.copied"));
                    }
                    return InteractionResult.SUCCESS;
                }
                String id = ForgeRegistryWrapper.getBlockEntityTypeKey(entity.m_58903_()).toString() + ".settings";
                if (stack.m_41783_() == null || !stack.m_41783_().m_128441_(id)) {
                    if (!level.m_5776_()) {
                        context.m_43723_().m_213846_((Component)this.translate("tooltip.item.ic2.copy_tool.nothing_to_applied"));
                    }
                    return InteractionResult.FAIL;
                }
                settings.loadSettings(stack.m_41737_(id));
                if (!level.m_5776_()) {
                    context.m_43723_().m_213846_((Component)this.translate("tooltip.item.ic2.copy_tool.applied"));
                }
                return InteractionResult.SUCCESS;
            }
            if (context.m_43723_() != null) {
                if (!level.m_5776_()) {
                    context.m_43723_().m_213846_((Component)this.translate(context.m_7078_() ? "tooltip.item.ic2.copy_tool.nothing_to_copy" : "tooltip.item.ic2.copy_tool.nothing_to_applied"));
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }
}

