/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.rendering.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferVertexConsumer;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class VertexCache
implements BufferVertexConsumer {
    VertexFormat format;
    VertexFormatElement element;
    ByteBuffer data;
    int writtenBytes;
    int index;
    int vertecies;
    VertexFormat.Mode mode;

    public VertexCache(int minVertecies, VertexFormat.Mode mode, VertexFormat format) {
        this.format = format;
        this.element = (VertexFormatElement)format.m_86023_().get(0);
        this.mode = mode;
        this.data = ByteBuffer.allocate(minVertecies * format.m_86020_()).order(ByteOrder.nativeOrder());
    }

    public int writtenBytes() {
        return this.writtenBytes;
    }

    public int vertexCount() {
        return this.vertecies;
    }

    public boolean hasVertices() {
        return this.vertecies > 0;
    }

    public VertexFormat format() {
        return this.format;
    }

    public void m_5752_() {
        ++this.vertecies;
        this.ensureCacpacity(this.format.m_86020_());
        if (this.mode == VertexFormat.Mode.LINES || this.mode == VertexFormat.Mode.LINE_STRIP) {
            int i = this.format.m_86020_();
            this.data.put(this.writtenBytes, this.data, this.writtenBytes - i, i);
            this.writtenBytes += i;
            ++this.vertecies;
            this.ensureCacpacity(this.format.m_86020_());
        }
    }

    private void ensureCacpacity(int toAdd) {
        while (this.writtenBytes + toAdd >= this.data.capacity()) {
            this.data = ByteBuffer.allocate(this.data.capacity() * 2).order(ByteOrder.nativeOrder()).put(this.data);
        }
    }

    public void m_7404_(int r, int g, int b, int a) {
    }

    public void m_141991_() {
    }

    public VertexFormatElement m_6297_() {
        return this.element;
    }

    public void m_5751_() {
        this.writtenBytes += this.element.m_86050_();
        ++this.index;
        this.index %= this.format.m_86023_().size();
        this.element = (VertexFormatElement)this.format.m_86023_().get(this.index);
        if (this.element.m_86048_() == VertexFormatElement.Usage.PADDING) {
            this.m_5751_();
        }
    }

    public void m_5672_(int index, byte value) {
        this.data.put(this.writtenBytes + index, value);
    }

    public void m_5586_(int index, short value) {
        this.data.putShort(this.writtenBytes + index, value);
    }

    public void m_5832_(int index, float value) {
        this.data.putFloat(this.writtenBytes + index, value);
    }

    private ByteBuffer prepData() {
        return this.data.position(this.writtenBytes).flip();
    }

    private void cleanupData() {
        this.data.limit(this.data.capacity()).position(0);
    }

    public void copyFrom(VertexCache cache) {
        if (cache.format() != this.format() || cache.writtenBytes < 0) {
            return;
        }
        this.ensureCacpacity(cache.writtenBytes());
        this.data.position(this.writtenBytes).put(cache.prepData());
        this.vertecies += cache.vertecies;
        this.writtenBytes += cache.writtenBytes;
        cache.cleanupData();
    }

    public void copyFrom(VertexCache cache, int start, int width) {
        if (cache.format() != this.format() || cache.writtenBytes < 0 || width < 0) {
            return;
        }
        int size = this.format.m_86020_();
        this.ensureCacpacity((start + width) * size);
        this.data.position(this.writtenBytes).put(cache.prepData().position(start * size).limit((start + width) * size));
        this.vertecies += width;
        this.writtenBytes += width * size;
        cache.cleanupData();
    }

    public void putIntoBuffer(BufferBuilder builder) {
        if (this.writtenBytes == 0) {
            return;
        }
        builder.putBulkData(this.prepData());
        this.cleanupData();
    }

    public void putIntoBuffer(BufferBuilder builder, int offset) {
        if (this.writtenBytes == 0) {
            return;
        }
        builder.putBulkData(this.prepData().position(offset * this.format.m_86020_()));
        this.cleanupData();
    }

    public void clear() {
        this.writtenBytes = 0;
        this.vertecies = 0;
    }

    public boolean isEmpty() {
        return this.vertecies <= 0;
    }

    public static class BufferedVertexCache
    extends VertexCache {
        VertexBuffer buffer;

        public BufferedVertexCache(int minVertecies, VertexFormat.Mode mode, VertexFormat format) {
            super(minVertecies, mode, format);
        }

        public void finish() {
            if (this.buffer == null) {
                this.buffer = new VertexBuffer();
            }
            BufferBuilder builder = Tesselator.m_85913_().m_85915_();
            builder.m_166779_(this.mode, this.format);
            this.putIntoBuffer(builder);
            this.buffer.m_85921_();
            this.buffer.m_231221_(builder.m_231175_());
        }

        public void draw() {
            if (this.buffer == null) {
                return;
            }
            this.buffer.m_85921_();
            this.buffer.m_166867_(RenderSystem.m_157190_(), RenderSystem.m_157192_(), RenderSystem.m_157196_());
            VertexBuffer.m_85931_();
        }

        public void delete() {
            if (this.buffer == null) {
                return;
            }
            this.buffer.close();
            this.buffer = null;
        }
    }
}

