/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.wiki.helper;

import ic2.core.wiki.base.book.WikiChapter;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class PageVisit {
    final WikiChapter chapter;
    final int page;
    boolean wasSearching = false;
    Component cache = null;

    public PageVisit(WikiChapter chapter, int page) {
        this.chapter = chapter;
        this.page = page;
    }

    public PageVisit withSearching(boolean value) {
        this.wasSearching = value;
        return this;
    }

    public boolean wasSearching() {
        return this.wasSearching;
    }

    public WikiChapter getChapter() {
        return this.chapter;
    }

    public int getPage() {
        return this.page;
    }

    public int hashCode() {
        return Objects.hash(this.chapter, this.page);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PageVisit)) return false;
        PageVisit visit = (PageVisit)obj;
        if (visit.chapter != this.chapter) return false;
        if (visit.page != this.page) return false;
        return true;
    }

    public boolean isValid() {
        return this.chapter != null && this.page >= 0 && this.page < this.chapter.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getSearch(Font font) {
        if (this.cache != null) {
            return this.cache;
        }
        MutableComponent comp = this.getHeader().m_6881_().m_130940_(ChatFormatting.BOLD);
        MutableComponent hover = Component.m_237113_((String)"Open: ").m_7220_((Component)this.getHeader().m_6881_().m_6270_(Style.f_131099_)).m_130946_("\n").m_130946_("Chapter: ").m_7220_((Component)this.chapter.getHeader(0).m_6881_().m_6270_(Style.f_131099_)).m_130946_("\nPage: " + this.page);
        this.cache = comp.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Open: ").m_7220_((Component)hover))));
        return this.cache;
    }

    public Component getHeader() {
        return this.chapter.getHeader(this.page);
    }
}

