/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SelectFileAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String VALUE_SEPARATOR = "|||";
    private static final String LIST_SEPARATOR_REGEX = "[;,]";
    private static final String DEFAULT_FILTER_DESCRIPTION = "All Files (*.*)";

    public SelectFileAction() {
        super("select_file_to_game_dir");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        Path sourcePath;
        String selectedFilePath;
        Path targetPath;
        SelectFileConfig config = SelectFileConfig.parse(value);
        if (config == null) {
            LOGGER.error("[FANCYMENU] SelectFileAction: Failed to parse configuration!");
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(null, null, false, false, "invalid_configuration");
            return;
        }
        if (!config.hasValidTargetPath()) {
            LOGGER.error("[FANCYMENU] SelectFileAction: No target path configured!");
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(null, config.targetPath, false, false, "missing_target_path");
            return;
        }
        try {
            targetPath = this.resolveTargetPath(config.targetPath);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] SelectFileAction: Failed to resolve target path '{}'", (Object)config.targetPath, (Object)ex);
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(null, config.targetPath, false, false, ex.getMessage());
            return;
        }
        String dialogTitle = Component.m_237115_((String)"fancymenu.actions.select_file.dialog_title").getString();
        if (dialogTitle.isBlank()) {
            dialogTitle = this.getActionDisplayName().getString();
        }
        List<String> filterPatterns = config.buildFilterPatterns();
        String filterDescription = config.getEffectiveFilterDescription();
        if (filterPatterns.isEmpty()) {
            selectedFilePath = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)dialogTitle, null, null, (CharSequence)filterDescription, (boolean)false);
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filterBuffer = stack.mallocPointer(filterPatterns.size());
                for (String pattern : filterPatterns) {
                    filterBuffer.put(stack.UTF8((CharSequence)pattern));
                }
                filterBuffer.flip();
                selectedFilePath = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)dialogTitle, null, (PointerBuffer)filterBuffer, (CharSequence)filterDescription, (boolean)false);
            }
        }
        if (selectedFilePath == null) {
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(null, targetPath.toString(), false, true, null);
            return;
        }
        try {
            sourcePath = Paths.get(selectedFilePath, new String[0]).toAbsolutePath().normalize();
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] SelectFileAction: Invalid source path returned from dialog: {}", (Object)selectedFilePath, (Object)ex);
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(selectedFilePath, targetPath.toString(), false, false, "invalid_source_path");
            return;
        }
        if (!Files.exists(sourcePath, new LinkOption[0]) || Files.isDirectory(sourcePath, new LinkOption[0])) {
            LOGGER.error("[FANCYMENU] SelectFileAction: Source path does not point to a readable file: {}", (Object)sourcePath);
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(sourcePath.toString(), targetPath.toString(), false, false, "source_not_file");
            return;
        }
        try {
            Path parent = targetPath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (!config.overwriteExisting && Files.exists(targetPath, new LinkOption[0])) {
                throw new FileAlreadyExistsException("Destination exists already: " + targetPath);
            }
            if (config.overwriteExisting) {
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(sourcePath, targetPath, new CopyOption[0]);
            }
            LOGGER.info("[FANCYMENU] SelectFileAction: Copied '{}' to '{}'", (Object)sourcePath, (Object)targetPath);
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(sourcePath.toString(), targetPath.toString(), true, false, null);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] SelectFileAction: Failed to copy '{}' to '{}'", (Object)sourcePath, (Object)targetPath, (Object)ex);
            Listeners.ON_FILE_SELECTED.onFileSelectionResult(sourcePath.toString(), targetPath.toString(), false, false, ex.getMessage());
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.select_file");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.select_file.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.m_237119_();
    }

    @Override
    public String getValueExample() {
        return "/config/fancymenu/assets/background.png|||Image Files (*.png;*.jpg)|||png;jpg|||true";
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        SelectFileActionValueScreen screen = new SelectFileActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), value -> {
            if (value != null) {
                instance.value = value;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    @NotNull
    private Path resolveTargetPath(@NotNull String targetPath) throws IOException {
        String resolved = DotMinecraftUtils.resolveMinecraftPath(targetPath);
        if (!DotMinecraftUtils.isInsideMinecraftDirectory(resolved)) {
            resolved = GameDirectoryUtils.getAbsoluteGameDirectoryPath(resolved);
        }
        Path normalized = Paths.get(resolved, new String[0]).toAbsolutePath().normalize();
        Path minecraftDir = DotMinecraftUtils.getMinecraftDirectory().toAbsolutePath().normalize();
        Path gameDir = GameDirectoryUtils.getGameDirectory().toPath().toAbsolutePath().normalize();
        if (!normalized.startsWith(gameDir) && !normalized.startsWith(minecraftDir)) {
            throw new SecurityException("Target path must stay inside the game directory or default .minecraft directory!");
        }
        return normalized;
    }

    public static class SelectFileConfig {
        public String targetPath = "";
        public String filterDescription = "All Files (*.*)";
        public String extensionsRaw = "";
        public boolean overwriteExisting = true;

        public boolean hasValidTargetPath() {
            return this.targetPath != null && !this.targetPath.isBlank();
        }

        @Nullable
        public static SelectFileConfig parse(@Nullable String value) {
            SelectFileConfig config = new SelectFileConfig();
            if (value == null || value.isEmpty()) {
                return config;
            }
            String[] parts = value.split("\\Q|||\\E", -1);
            try {
                if (parts.length >= 1) {
                    config.targetPath = parts[0];
                }
                if (parts.length >= 2) {
                    String string = config.filterDescription = parts[1].isEmpty() ? SelectFileAction.DEFAULT_FILTER_DESCRIPTION : parts[1];
                }
                if (parts.length >= 3) {
                    config.extensionsRaw = parts[2];
                }
                if (parts.length >= 4) {
                    config.overwriteExisting = Boolean.parseBoolean(parts[3]);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] SelectFileAction: Failed to parse configuration string: {}", (Object)value, (Object)ex);
                return new SelectFileConfig();
            }
            return config;
        }

        @NotNull
        public String serialize() {
            return String.join((CharSequence)SelectFileAction.VALUE_SEPARATOR, Objects.toString(this.targetPath, ""), Objects.toString(this.filterDescription, ""), Objects.toString(this.extensionsRaw, ""), Boolean.toString(this.overwriteExisting));
        }

        @NotNull
        public List<String> buildFilterPatterns() {
            String[] splitted;
            ArrayList<String> patterns = new ArrayList<String>();
            if (this.extensionsRaw == null) {
                return patterns;
            }
            String raw = this.extensionsRaw.trim();
            if (raw.isEmpty()) {
                return patterns;
            }
            for (String ext : splitted = raw.split(SelectFileAction.LIST_SEPARATOR_REGEX)) {
                String trimmed = ext.trim();
                if (trimmed.isEmpty()) continue;
                String normalized = this.normalizeExtension(trimmed);
                if (normalized.equals("*") || normalized.equals("*.*")) {
                    patterns.clear();
                    return patterns;
                }
                patterns.add(normalized);
            }
            return patterns;
        }

        @Nullable
        public String getEffectiveFilterDescription() {
            return this.filterDescription == null || this.filterDescription.isBlank() ? null : this.filterDescription;
        }

        @NotNull
        private String normalizeExtension(@NotNull String input) {
            String normalized = input.trim();
            if (normalized.isEmpty()) {
                return "*.*";
            }
            if (normalized.equals("*") || normalized.equals("*.*")) {
                return "*.*";
            }
            if (normalized.indexOf(42) >= 0 || normalized.indexOf(63) >= 0) {
                return normalized;
            }
            if (normalized.startsWith(".")) {
                normalized = normalized.substring(1);
            }
            if ((normalized = normalized.toLowerCase(Locale.ROOT)).isEmpty()) {
                return "*.*";
            }
            return "*." + normalized;
        }
    }

    public static class SelectFileActionValueScreen
    extends CellScreen {
        protected SelectFileConfig config;
        protected final Consumer<String> callback;

        protected SelectFileActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.actions.select_file.edit_value"));
            this.callback = callback;
            SelectFileConfig parsed = SelectFileConfig.parse(value);
            this.config = Objects.requireNonNullElseGet(parsed, SelectFileConfig::new);
        }

        @Override
        protected void initCells() {
            this.addStartEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.select_file.edit.target_path"));
            CellScreen.TextInputCell targetPathCell = this.addTextInputCell(null, true, true).setEditListener(text -> {
                this.config.targetPath = text;
            }).setText(this.config.targetPath);
            targetPathCell.editBox.setTooltip(() -> Tooltip.of(new Component[]{Component.m_237115_((String)"fancymenu.actions.select_file.edit.target_path.desc")}));
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.select_file.edit.filter_description"));
            CellScreen.TextInputCell filterDescriptionCell = this.addTextInputCell(null, true, true).setEditListener(text -> {
                this.config.filterDescription = text;
            }).setText(this.config.filterDescription);
            filterDescriptionCell.editBox.setTooltip(() -> Tooltip.of(new Component[]{Component.m_237115_((String)"fancymenu.actions.select_file.edit.filter_description.desc")}));
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.select_file.edit.extensions"));
            CellScreen.TextInputCell extensionsCell = this.addTextInputCell(null, true, true).setEditListener(text -> {
                this.config.extensionsRaw = text;
            }).setText(this.config.extensionsRaw);
            extensionsCell.editBox.setTooltip(() -> Tooltip.of(new Component[]{Component.m_237115_((String)"fancymenu.actions.select_file.edit.extensions.desc")}));
            this.addCellGroupEndSpacerCell();
            CycleButton<CommonCycles.CycleEnabledDisabled> overwriteButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, 20, 20, CommonCycles.cycleEnabledDisabled("fancymenu.actions.select_file.edit.overwrite", this.config.overwriteExisting), (cycleValue, button) -> {
                this.config.overwriteExisting = cycleValue.getAsBoolean();
            });
            overwriteButton.setTooltip(Tooltip.of(new Component[]{Component.m_237115_((String)"fancymenu.actions.select_file.edit.overwrite.desc")}));
            this.addWidgetCell((AbstractWidget)overwriteButton, true);
            this.addStartEndSpacerCell();
        }

        @Override
        public boolean allowDone() {
            return this.config.hasValidTargetPath();
        }

        @Override
        protected void onCancel() {
            this.callback.accept(null);
        }

        @Override
        protected void onDone() {
            this.callback.accept(this.config.serialize());
        }
    }
}

