/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendHttpRequestAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String VALUE_SEPARATOR = "|||";
    private static final String HEADER_SEPARATOR = "~~~";
    private static final String HEADER_KEY_VALUE_SEPARATOR = ":::";

    public SendHttpRequestAction() {
        super("send_http_request");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            LOGGER.error("[FANCYMENU] SendHttpRequestAction: No value provided!");
            return;
        }
        HttpRequestConfig config = HttpRequestConfig.parse(value);
        if (config == null) {
            LOGGER.error("[FANCYMENU] SendHttpRequestAction: Failed to parse configuration!");
            return;
        }
        if (!WebUtils.isInternetAvailable()) {
            LOGGER.warn("[FANCYMENU] SendHttpRequestAction: No internet connection available!");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.sendHttpRequest(config);
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] SendHttpRequestAction: Failed to send HTTP request!", (Throwable)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHttpRequest(HttpRequestConfig config) throws Exception {
        block29: {
            URI uri = new URI(config.url);
            URL url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            try {
                connection.setRequestMethod(config.method);
                connection.setConnectTimeout(config.timeout * 1000);
                connection.setReadTimeout(config.timeout * 1000);
                for (HttpHeader header : config.headers) {
                    connection.setRequestProperty(header.key, header.value);
                }
                if (config.authType != AuthType.NONE) {
                    switch (config.authType) {
                        case BASIC: {
                            String basicAuth = "Basic " + Base64.getEncoder().encodeToString((config.authUsername + ":" + config.authPassword).getBytes(StandardCharsets.UTF_8));
                            connection.setRequestProperty("Authorization", basicAuth);
                            break;
                        }
                        case BEARER: {
                            connection.setRequestProperty("Authorization", "Bearer " + config.authToken);
                            break;
                        }
                        case API_KEY: {
                            connection.setRequestProperty(config.authApiKeyHeader, config.authApiKey);
                        }
                    }
                }
                if (config.contentType != null && !config.contentType.isEmpty()) {
                    connection.setRequestProperty("Content-Type", config.contentType);
                }
                if (!(config.method.equals("GET") || config.method.equals("HEAD") || config.body == null || config.body.isEmpty())) {
                    connection.setDoOutput(true);
                    try (OutputStream os = connection.getOutputStream();){
                        byte[] input = config.body.getBytes(StandardCharsets.UTF_8);
                        os.write(input, 0, input.length);
                    }
                }
                int responseCode = connection.getResponseCode();
                if (config.logResponse || !config.responseVariable.isEmpty()) {
                    StringBuilder response = new StringBuilder();
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(responseCode >= 200 && responseCode < 300 ? connection.getInputStream() : connection.getErrorStream()));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            response.append(line).append("\n");
                        }
                    }
                    String responseText = response.toString().trim();
                    if (!config.responseVariable.isEmpty()) {
                        String variableValue = config.singleLineResponse ? responseText.replace("\n", " ").replace("\r", " ").trim() : responseText;
                        MainThreadTaskExecutor.executeInMainThread(() -> VariableHandler.setVariable(config.responseVariable, variableValue), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }
                    if (config.logResponse) {
                        LOGGER.info("[FANCYMENU] HTTP Request completed - Code: {}, Response: {}", (Object)responseCode, (Object)responseText);
                    }
                    break block29;
                }
                LOGGER.info("[FANCYMENU] HTTP Request completed - Code: {}", (Object)responseCode);
            }
            finally {
                connection.disconnect();
            }
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.m_237115_((String)"fancymenu.actions.send_http_request");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.send_http_request.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.m_237119_();
    }

    @Override
    public String getValueExample() {
        return "https://api.example.com|||POST|||{\"key\":\"value\"}|||application/json|||10|||true||||||true|||NONE|||||||||||||";
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        SendHttpRequestActionValueScreen s = new SendHttpRequestActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), value -> {
            if (value != null) {
                instance.value = value;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    public static class HttpRequestConfig {
        public String url = "";
        public String method = "GET";
        public String body = "";
        public String contentType = "application/json";
        public int timeout = 10;
        public boolean logResponse = false;
        public String responseVariable = "";
        public boolean singleLineResponse = true;
        public AuthType authType = AuthType.NONE;
        public String authUsername = "";
        public String authPassword = "";
        public String authToken = "";
        public String authApiKeyHeader = "X-API-Key";
        public String authApiKey = "";
        public List<HttpHeader> headers = new ArrayList<HttpHeader>();

        public String serialize() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.url).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.method).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.body).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.contentType).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.timeout).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.logResponse).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.responseVariable).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.singleLineResponse).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.authType.name()).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.authUsername).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.authPassword).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.authToken).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.authApiKeyHeader).append(SendHttpRequestAction.VALUE_SEPARATOR);
            sb.append(this.authApiKey).append(SendHttpRequestAction.VALUE_SEPARATOR);
            for (HttpHeader header : this.headers) {
                sb.append(header.key).append(SendHttpRequestAction.HEADER_KEY_VALUE_SEPARATOR).append(header.value).append(SendHttpRequestAction.HEADER_SEPARATOR);
            }
            return sb.toString();
        }

        @Nullable
        public static HttpRequestConfig parse(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            HttpRequestConfig config = new HttpRequestConfig();
            String[] parts = value.split("\\|\\|\\|", -1);
            try {
                if (parts.length >= 1) {
                    config.url = parts[0];
                }
                if (parts.length >= 2) {
                    config.method = parts[1];
                }
                if (parts.length >= 3) {
                    config.body = parts[2];
                }
                if (parts.length >= 4) {
                    config.contentType = parts[3];
                }
                if (parts.length >= 5) {
                    config.timeout = Integer.parseInt(parts[4]);
                }
                if (parts.length >= 6) {
                    config.logResponse = Boolean.parseBoolean(parts[5]);
                }
                if (parts.length >= 7) {
                    config.responseVariable = parts[6];
                }
                if (parts.length >= 8) {
                    config.singleLineResponse = Boolean.parseBoolean(parts[7]);
                }
                if (parts.length >= 9) {
                    config.authType = AuthType.valueOf(parts[8]);
                }
                if (parts.length >= 10) {
                    config.authUsername = parts[9];
                }
                if (parts.length >= 11) {
                    config.authPassword = parts[10];
                }
                if (parts.length >= 12) {
                    config.authToken = parts[11];
                }
                if (parts.length >= 13) {
                    config.authApiKeyHeader = parts[12];
                }
                if (parts.length >= 14) {
                    config.authApiKey = parts[13];
                }
                if (parts.length >= 15 && !parts[14].isEmpty()) {
                    String[] headerPairs;
                    for (String headerPair : headerPairs = parts[14].split(SendHttpRequestAction.HEADER_SEPARATOR)) {
                        if (!headerPair.contains(SendHttpRequestAction.HEADER_KEY_VALUE_SEPARATOR)) continue;
                        String[] kv = headerPair.split(SendHttpRequestAction.HEADER_KEY_VALUE_SEPARATOR, 2);
                        config.headers.add(new HttpHeader(kv[0], kv[1]));
                    }
                }
                return config;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to parse HTTP request configuration!", (Throwable)ex);
                return null;
            }
        }
    }

    public static class HttpHeader {
        public String key;
        public String value;

        public HttpHeader(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static enum AuthType {
        NONE("fancymenu.actions.send_http_request.auth.none"),
        BASIC("fancymenu.actions.send_http_request.auth.basic"),
        BEARER("fancymenu.actions.send_http_request.auth.bearer"),
        API_KEY("fancymenu.actions.send_http_request.auth.api_key");

        private final String localizationKey;

        private AuthType(String localizationKey) {
            this.localizationKey = localizationKey;
        }

        public String getLocalizationKey() {
            return this.localizationKey;
        }
    }

    public static class SendHttpRequestActionValueScreen
    extends CellScreen {
        protected HttpRequestConfig config;
        protected Consumer<String> callback;
        protected List<HeaderEditRow> headerRows = new ArrayList<HeaderEditRow>();
        protected boolean authFieldsInitialized = false;
        protected boolean firstInit = true;

        protected SendHttpRequestActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit_value"));
            this.callback = callback;
            this.config = HttpRequestConfig.parse(value);
            if (this.config == null) {
                this.config = new HttpRequestConfig();
            }
        }

        @Override
        protected void initCells() {
            ArrayList<HttpHeader> existingHeaders = new ArrayList<HttpHeader>();
            for (HeaderEditRow row : this.headerRows) {
                existingHeaders.add(new HttpHeader(row.key, row.value));
            }
            this.headerRows.clear();
            this.addStartEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.url"));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.config.url = s;
            }).setText(this.config.url);
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.method.title"));
            List<HttpMethod> methods = Arrays.asList(HttpMethod.values());
            LocalizedGenericValueCycle<HttpMethod> methodCycle = LocalizedGenericValueCycle.of("fancymenu.actions.send_http_request.edit.method", methods.toArray(new HttpMethod[0]));
            methodCycle.setCurrentValue((Object)HttpMethod.valueOf(this.config.method));
            methodCycle.setValueComponentStyleSupplier(consumes -> Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            this.addCycleButtonCell(methodCycle, true, (value, button) -> {
                this.config.method = value.name();
            });
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.content_type"));
            this.addTextInputCell(null, false, false).setEditListener(s -> {
                this.config.contentType = s;
            }).setText(this.config.contentType);
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.body"));
            CellScreen.TextInputCell bodyCell = this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.config.body = s;
            }).setText(this.config.body);
            bodyCell.setEditorCallback((s, cell) -> {
                this.config.body = s;
                cell.editBox.m_94144_((String)s);
            });
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.timeout"));
            this.addTextInputCell(CharacterFilter.buildIntegerFiler(), false, false).setEditListener(s -> {
                try {
                    this.config.timeout = Integer.parseInt(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).setText(String.valueOf(this.config.timeout));
            this.addCellGroupEndSpacerCell();
            this.addWidgetCell((AbstractWidget)new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, 20, 20, CommonCycles.cycleEnabledDisabled("fancymenu.actions.send_http_request.edit.log_response", this.config.logResponse), (value, button) -> {
                this.config.logResponse = value.getAsBoolean();
            }), true);
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.response_variable"));
            this.addTextInputCell((CharacterFilter)CharacterFilter.buildResourceNameFilter(), (boolean)false, (boolean)false).setEditListener((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$initCells$8(java.lang.String ), (Ljava/lang/String;)V)((SendHttpRequestActionValueScreen)this)).setText((String)this.config.responseVariable).editBox.setTooltip(() -> Tooltip.of(new Component[]{Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.response_variable.desc")}));
            this.addCellGroupEndSpacerCell();
            this.addWidgetCell((AbstractWidget)new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, 20, 20, CommonCycles.cycleEnabledDisabled("fancymenu.actions.send_http_request.edit.single_line_response", this.config.singleLineResponse), (value, button) -> {
                this.config.singleLineResponse = value.getAsBoolean();
            }), true);
            this.addCellGroupEndSpacerCell();
            this.addSeparatorCell();
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.auth_type.title"));
            List<AuthType> authTypes = Arrays.asList(AuthType.values());
            LocalizedGenericValueCycle<AuthType> authCycle = LocalizedGenericValueCycle.of("fancymenu.actions.send_http_request.edit.auth_type", authTypes.toArray(new AuthType[0]));
            authCycle.setValueNameSupplier(authType -> Component.m_237115_((String)authType.getLocalizationKey()).getString());
            authCycle.setValueComponentStyleSupplier(consumes -> Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            authCycle.setCurrentValue((Object)this.config.authType);
            this.addCycleButtonCell(authCycle, true, (value, button) -> {
                this.config.authType = value;
                this.rebuildAuthFields();
            });
            this.addCellGroupEndSpacerCell();
            this.addAuthFields();
            this.addCellGroupEndSpacerCell();
            this.addSeparatorCell();
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.headers"));
            if (!existingHeaders.isEmpty()) {
                for (HttpHeader header : existingHeaders) {
                    this.addHeaderRow(header.key, header.value);
                }
            } else if (this.firstInit) {
                for (HttpHeader header : this.config.headers) {
                    this.addHeaderRow(header.key, header.value);
                }
            }
            this.addCellGroupEndSpacerCell();
            this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.add_header"), button -> {
                this.addHeaderRow("", "");
                this.rebuild();
            }), true);
            this.addStartEndSpacerCell();
            this.authFieldsInitialized = true;
            this.firstInit = false;
        }

        private void addAuthFields() {
            if (this.config.authType == AuthType.BASIC) {
                this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.auth_username"));
                this.addTextInputCell(null, false, false).setEditListener(s -> {
                    this.config.authUsername = s;
                }).setText(this.config.authUsername);
                this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.auth_password"));
                this.addTextInputCell(null, false, false).setEditListener(s -> {
                    this.config.authPassword = s;
                }).setText(this.config.authPassword);
            } else if (this.config.authType == AuthType.BEARER) {
                this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.auth_token"));
                this.addTextInputCell(null, false, false).setEditListener(s -> {
                    this.config.authToken = s;
                }).setText(this.config.authToken);
            } else if (this.config.authType == AuthType.API_KEY) {
                this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.auth_api_key_header"));
                this.addTextInputCell(null, false, false).setEditListener(s -> {
                    this.config.authApiKeyHeader = s;
                }).setText(this.config.authApiKeyHeader);
                this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.auth_api_key"));
                this.addTextInputCell(null, false, false).setEditListener(s -> {
                    this.config.authApiKey = s;
                }).setText(this.config.authApiKey);
            }
        }

        private void rebuildAuthFields() {
            if (this.authFieldsInitialized) {
                this.rebuild();
            }
        }

        private void addHeaderRow(String key, String value) {
            HeaderEditRow row = new HeaderEditRow(key, value);
            this.headerRows.add(row);
            if (this.headerRows.size() > 1) {
                this.addSpacerCell(3);
            }
            this.addLabelCell((Component)Component.m_237113_((String)("> Header #" + this.headerRows.size())).m_130938_(s -> s.m_131136_(Boolean.valueOf(true))));
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.header_key"));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                row.key = s;
            }).setText(key);
            row.keyCell = (CellScreen.CellScrollEntry)this.scrollArea.getEntries().get(this.scrollArea.getEntries().size() - 1);
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.header_value"));
            this.addTextInputCell(null, true, true).setEditListener(s -> {
                row.value = s;
            }).setText(value);
            row.valueCell = (CellScreen.CellScrollEntry)this.scrollArea.getEntries().get(this.scrollArea.getEntries().size() - 1);
            this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Component.m_237115_((String)"fancymenu.actions.send_http_request.edit.remove_header"), button -> {
                this.headerRows.remove(row);
                this.rebuild();
            }), true);
            row.removeButtonCell = (CellScreen.CellScrollEntry)this.scrollArea.getEntries().get(this.scrollArea.getEntries().size() - 1);
        }

        @Override
        public boolean allowDone() {
            return !this.config.url.isEmpty();
        }

        @Override
        protected void onCancel() {
            this.callback.accept(null);
        }

        @Override
        protected void onDone() {
            this.config.headers.clear();
            for (HeaderEditRow row : this.headerRows) {
                if (row.key.isEmpty() || row.value.isEmpty()) continue;
                this.config.headers.add(new HttpHeader(row.key, row.value));
            }
            this.callback.accept(this.config.serialize());
        }

        private /* synthetic */ void lambda$initCells$8(String s) {
            this.config.responseVariable = s;
        }

        protected static class HeaderEditRow {
            String key;
            String value;
            CellScreen.CellScrollEntry keyCell;
            CellScreen.CellScrollEntry valueCell;
            CellScreen.CellScrollEntry removeButtonCell;

            HeaderEditRow(String key, String value) {
                this.key = key;
                this.value = value;
            }
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH,
        HEAD,
        OPTIONS;

    }
}

