/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.customization.customgui.BuildCustomGuiScreen;
import de.keksuccino.fancymenu.customization.customgui.CustomGui;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageCustomGuisScreen
extends CellScreen {
    protected Runnable onCloseRunnable;
    protected List<CustomGui> guis = new ArrayList<CustomGui>();
    @Nullable
    protected CustomGui selected;

    public ManageCustomGuisScreen(@NotNull Runnable onClose) {
        super((Component)Component.m_237115_((String)"fancymenu.custom_guis.manage"));
        for (CustomGui g : CustomGuiHandler.getGuis()) {
            this.guis.add(g.copy());
        }
        this.onCloseRunnable = onClose;
    }

    @Override
    protected void initCells() {
        for (CustomGui gui : this.guis) {
            this.addCell(new CustomGuiCell(gui)).setSelectable(true);
        }
        this.addSpacerCell(20);
    }

    @Override
    protected void m_7856_() {
        this.selected = null;
        super.m_7856_();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (Component)Component.m_237115_((String)"fancymenu.custom_guis.manage.add"), var1 -> {
            Screen s = Minecraft.m_91087_().f_91080_;
            Minecraft.m_91087_().m_91152_((Screen)new BuildCustomGuiScreen(null, customGui -> {
                if (customGui != null) {
                    this.guis.add((CustomGui)customGui);
                }
                Minecraft.m_91087_().m_91152_(s);
            }));
        });
        this.addRightSideDefaultSpacer();
        this.addRightSideButton(20, (Component)Component.m_237115_((String)"fancymenu.custom_guis.manage.open"), var1 -> {
            CustomGui selected = this.selected;
            if (selected != null) {
                CustomGuiHandler.CUSTOM_GUI_SCREENS.clear();
                for (CustomGui g : this.guis) {
                    if (g.identifier.replace(" ", "").isEmpty()) continue;
                    CustomGuiHandler.CUSTOM_GUI_SCREENS.put(g.identifier, g);
                }
                CustomGuiHandler.saveChanges();
                Minecraft.m_91087_().m_91152_((Screen)CustomGuiHandler.constructInstance(selected, Minecraft.m_91087_().f_91080_, null));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);
        this.addRightSideButton(20, (Component)Component.m_237115_((String)"fancymenu.custom_guis.manage.edit"), var1 -> {
            Screen s = Minecraft.m_91087_().f_91080_;
            CustomGui selected = this.selected;
            if (selected != null) {
                Minecraft.m_91087_().m_91152_((Screen)new BuildCustomGuiScreen(selected, customGui -> Minecraft.m_91087_().m_91152_(s)));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);
        this.addRightSideButton(20, (Component)Component.m_237115_((String)"fancymenu.custom_guis.manage.remove"), var1 -> {
            Screen s = Minecraft.m_91087_().f_91080_;
            CustomGui selected = this.selected;
            if (selected != null) {
                Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.warning(remove -> {
                    if (remove.booleanValue()) {
                        this.guis.remove(selected);
                    }
                    Minecraft.m_91087_().m_91152_(s);
                }, LocalizationUtils.splitLocalizedLines("fancymenu.custom_guis.manage.remove.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.selected = this.getSelectedGui();
        super.render(graphics, mouseX, mouseY, partial);
    }

    @Override
    protected void onCancel() {
        this.onCloseRunnable.run();
    }

    @Override
    protected void onDone() {
        CustomGuiHandler.CUSTOM_GUI_SCREENS.clear();
        for (CustomGui g : this.guis) {
            if (g.identifier.replace(" ", "").isEmpty()) continue;
            CustomGuiHandler.CUSTOM_GUI_SCREENS.put(g.identifier, g);
        }
        CustomGuiHandler.saveChanges();
        this.onCloseRunnable.run();
    }

    @Nullable
    protected CustomGui getSelectedGui() {
        CellScreen.RenderCell cell = this.getSelectedCell();
        if (cell instanceof CustomGuiCell) {
            CustomGuiCell c = (CustomGuiCell)cell;
            return c.gui;
        }
        return null;
    }

    public class CustomGuiCell
    extends CellScreen.LabelCell {
        protected CustomGui gui;

        public CustomGuiCell(CustomGui gui) {
            super(ManageCustomGuisScreen.this, (Component)Component.m_237113_((String)gui.identifier));
            this.gui = gui;
        }
    }
}

