/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.item;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.item.ItemElement;
import de.keksuccino.fancymenu.customization.element.elements.item.ItemKeyScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class ItemEditorElement
extends AbstractEditorElement {
    public ItemEditorElement(@NotNull AbstractElement element, @NotNull LayoutEditorScreen editor) {
        super(element, editor);
    }

    @Override
    public void init() {
        super.init();
        ConsumingSupplier<ItemEditorElement, String> itemKeyTargetFieldGetter = consumes -> consumes.getElement().itemKey;
        BiConsumer<ItemEditorElement, String> itemKeyTargetFieldSetter = (itemEditorElement, s) -> {
            itemEditorElement.getElement().itemKey = s;
        };
        ContextMenu.ClickableContextMenuEntry itemKeyEntry = (ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addStringInputContextMenuEntryTo(this.rightClickMenu, "item_key", ItemEditorElement.class, itemKeyTargetFieldGetter, itemKeyTargetFieldSetter, null, false, true, (Component)Component.m_237115_((String)"fancymenu.elements.item.key"), true, "" + Registry.f_122827_.m_7981_((Object)Items.f_42127_), null, null).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.item.key.desc", new String[0])))).setStackable(false);
        if (itemKeyEntry instanceof ContextMenu.SubMenuContextMenuEntry) {
            ContextMenu.SubMenuContextMenuEntry subMenuEntry = (ContextMenu.SubMenuContextMenuEntry)itemKeyEntry;
            subMenuEntry.getSubContextMenu().removeEntry("input_value");
            subMenuEntry.getSubContextMenu().addClickableEntryAt(0, "input_value", (Component)Component.m_237115_((String)"fancymenu.common_components.set"), (menu, entry) -> {
                if (entry.getStackMeta().isFirstInStack()) {
                    ItemKeyScreen inputScreen = new ItemKeyScreen((String)itemKeyTargetFieldGetter.get(this), callback -> {
                        if (callback != null) {
                            this.editor.history.saveSnapshot();
                            itemKeyTargetFieldSetter.accept(this, (String)callback);
                        }
                        menu.closeMenu();
                        Minecraft.m_91087_().m_91152_((Screen)this.editor);
                    });
                    Minecraft.m_91087_().m_91152_((Screen)inputScreen);
                }
            }).setStackable(false);
        }
        this.addStringInputContextMenuEntryTo(this.rightClickMenu, "item_name", ItemEditorElement.class, consumes -> consumes.getElement().itemName, (itemEditorElement, s) -> {
            itemEditorElement.getElement().itemName = s;
        }, null, false, true, (Component)Component.m_237115_((String)"fancymenu.elements.item.name"), true, null, null, null);
        this.addStringInputContextMenuEntryTo(this.rightClickMenu, "item_count", ItemEditorElement.class, consumes -> consumes.getElement().itemCount, (itemEditorElement, s) -> {
            itemEditorElement.getElement().itemCount = s;
        }, null, false, true, (Component)Component.m_237115_((String)"fancymenu.elements.item.item_count"), true, "1", null, null);
        this.addStringInputContextMenuEntryTo(this.rightClickMenu, "item_lore", ItemEditorElement.class, consumes -> {
            if (consumes.getElement().lore != null) {
                return consumes.getElement().lore.replace("%n%", "\n");
            }
            return "";
        }, (itemEditorElement, s) -> {
            if (s != null) {
                itemEditorElement.getElement().lore = s.replace("\n", "%n%");
                if (itemEditorElement.getElement().lore.isBlank()) {
                    itemEditorElement.getElement().lore = null;
                }
            } else {
                itemEditorElement.getElement().lore = null;
            }
        }, null, true, true, (Component)Component.m_237115_((String)"fancymenu.elements.item.lore"), true, null, null, null).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.item.lore.desc", new String[0])));
        this.addToggleContextMenuEntryTo(this.rightClickMenu, "enchanted", ItemEditorElement.class, consumes -> consumes.getElement().enchanted, (itemEditorElement, aBoolean) -> {
            itemEditorElement.getElement().enchanted = aBoolean;
        }, "fancymenu.elements.item.enchanted");
        this.addToggleContextMenuEntryTo(this.rightClickMenu, "show_tooltip", ItemEditorElement.class, consumes -> consumes.getElement().showTooltip, (itemEditorElement, aBoolean) -> {
            itemEditorElement.getElement().showTooltip = aBoolean;
        }, "fancymenu.elements.item.show_tooltip");
        this.rightClickMenu.addSeparatorEntry("separator_before_nbt");
        this.addStringInputContextMenuEntryTo(this.rightClickMenu, "nbt_data", ItemEditorElement.class, consumes -> consumes.getElement().nbtData, (itemEditorElement, s) -> {
            itemEditorElement.getElement().nbtData = s;
        }, null, false, true, (Component)Component.m_237115_((String)"fancymenu.elements.item.nbt"), true, null, null, null).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.item.nbt.desc", new String[0])));
    }

    public ItemElement getElement() {
        return (ItemElement)this.element;
    }
}

