/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnInteractedWithBlockListener
extends AbstractListener {
    @Nullable
    private String cachedBlockKey;
    @Nullable
    private String cachedBlockPosX;
    @Nullable
    private String cachedBlockPosY;
    @Nullable
    private String cachedBlockPosZ;

    public OnInteractedWithBlockListener() {
        super("interacted_with_block");
    }

    public void onBlockInteracted(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        ResourceLocation blockLocation = Registry.f_122824_.m_7981_((Object)blockState.m_60734_());
        this.cachedBlockKey = blockLocation != null ? blockLocation.toString() : null;
        this.cachedBlockPosX = Integer.toString(blockPos.m_123341_());
        this.cachedBlockPosY = Integer.toString(blockPos.m_123342_());
        this.cachedBlockPosZ = Integer.toString(blockPos.m_123343_());
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("block_key", () -> this.cachedBlockKey != null ? this.cachedBlockKey : "ERROR"));
        list.add(new AbstractListener.CustomVariable("block_pos_x", () -> this.cachedBlockPosX != null ? this.cachedBlockPosX : "0"));
        list.add(new AbstractListener.CustomVariable("block_pos_y", () -> this.cachedBlockPosY != null ? this.cachedBlockPosY : "0"));
        list.add(new AbstractListener.CustomVariable("block_pos_z", () -> this.cachedBlockPosZ != null ? this.cachedBlockPosZ : "0"));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_interacted_with_block");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_interacted_with_block.desc", new String[0]));
    }
}

