/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.panorama;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import de.keksuccino.fancymenu.util.ScreenUtils;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.Renderable;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalTexturePanoramaRenderer
implements Renderable {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public File propertiesFile;
    @NotNull
    public File panoramaImageDir;
    @Nullable
    public File overlayImageFile;
    protected String name = null;
    public final List<ResourceSupplier<ITexture>> panoramaImageSuppliers = new ArrayList<ResourceSupplier<ITexture>>();
    @Nullable
    public ResourceSupplier<ITexture> overlayTextureSupplier;
    protected float speed = 1.0f;
    protected double fov = 85.0;
    protected float angle = 25.0f;
    public float opacity = 1.0f;
    protected volatile boolean tickerThreadRunning = false;
    protected volatile float currentRotation = 0.0f;
    protected volatile long lastRenderCall = -1L;

    @Nullable
    public static LocalTexturePanoramaRenderer build(@NotNull File propertiesFile, @NotNull File panoramaImageDir, @Nullable File overlayImageFile) {
        LocalTexturePanoramaRenderer renderer = new LocalTexturePanoramaRenderer(propertiesFile, panoramaImageDir, overlayImageFile);
        try {
            if (renderer.propertiesFile.isFile() && renderer.panoramaImageDir.isDirectory()) {
                PropertyContainerSet panoProperties = PropertiesParser.deserializeSetFromFile(renderer.propertiesFile.getAbsolutePath());
                if (panoProperties != null) {
                    PropertyContainer panoMeta = panoProperties.getFirstContainerOfType("panorama-meta");
                    if (panoMeta != null) {
                        String rot;
                        String an;
                        String fo;
                        renderer.name = panoMeta.getValue("name");
                        if (renderer.name == null) {
                            LOGGER.error("[FANCYMENU] Unable to load panorama! Missing 'name' value in panorama meta section: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                            return null;
                        }
                        String sp = panoMeta.getValue("speed");
                        if (sp != null && MathUtils.isFloat((String)sp)) {
                            renderer.speed = Float.parseFloat(sp);
                        }
                        if ((fo = panoMeta.getValue("fov")) != null && MathUtils.isDouble((String)fo)) {
                            renderer.fov = Double.parseDouble(fo);
                        }
                        if ((an = panoMeta.getValue("angle")) != null && MathUtils.isFloat((String)an)) {
                            renderer.angle = Float.parseFloat(an);
                        }
                        if ((rot = panoMeta.getValue("start_rotation")) != null && MathUtils.isFloat((String)rot)) {
                            renderer.currentRotation = Float.parseFloat(rot);
                            if (renderer.currentRotation > 360.0f || renderer.currentRotation < 0.0f) {
                                renderer.currentRotation = 0.0f;
                            }
                        }
                        renderer.prepare();
                        return renderer;
                    }
                    LOGGER.error("[FANCYMENU] Unable to load panorama! Missing 'panorama-meta' section in properties instance: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                } else {
                    LOGGER.error("[FANCYMENU] Unable to load panorama! Parsed properties instance was NULL: " + renderer.propertiesFile.getAbsolutePath(), (Throwable)new NullPointerException());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] An error happened while trying to build a cubic panorama!", (Throwable)ex);
        }
        return null;
    }

    protected LocalTexturePanoramaRenderer(@NotNull File propertiesFile, @NotNull File panoramaImageDir, @Nullable File overlayImageFile) {
        this.propertiesFile = Objects.requireNonNull(propertiesFile);
        this.panoramaImageDir = Objects.requireNonNull(panoramaImageDir);
        this.overlayImageFile = overlayImageFile;
    }

    protected void prepare() {
        this.panoramaImageSuppliers.clear();
        this.overlayTextureSupplier = null;
        for (int i = 0; i < 6; ++i) {
            File panoImage = new File(this.panoramaImageDir, "panorama_" + i + ".png");
            if (!panoImage.isFile()) {
                LOGGER.error("[FANCYMENU] Unable to load panorama! Missing panorama image 'panorama_" + i + ".png': " + this.name);
                return;
            }
            this.panoramaImageSuppliers.add(ResourceSupplier.image(ResourceSource.of(panoImage.getAbsolutePath(), ResourceSourceType.LOCAL).getSourceWithPrefix()));
        }
        if (this.overlayImageFile != null && this.overlayImageFile.isFile()) {
            this.panoramaImageSuppliers.add(ResourceSupplier.image(ResourceSource.of(this.overlayImageFile.getAbsolutePath(), ResourceSourceType.LOCAL).getSourceWithPrefix()));
        }
    }

    protected void startTickerThreadIfNeeded() {
        if (this.tickerThreadRunning) {
            return;
        }
        this.lastRenderCall = System.currentTimeMillis();
        this.tickerThreadRunning = true;
        new Thread(() -> {
            while (this.lastRenderCall + 5000L > System.currentTimeMillis()) {
                try {
                    this.currentRotation += 0.03f;
                    if (this.currentRotation >= 360.0f) {
                        this.currentRotation = 0.0f;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while ticking panorama!", (Throwable)ex);
                }
                try {
                    Thread.sleep(Math.max(2, (int)(20.0f / this.speed)));
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while ticking panorama!", (Throwable)ex);
                }
            }
            this.tickerThreadRunning = false;
        }, "FancyMenu Panorama Ticker Thread").start();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.lastRenderCall = System.currentTimeMillis();
        this.startTickerThreadIfNeeded();
        if (this.panoramaImageSuppliers.size() < 6) {
            RenderSystem.m_69478_();
            RenderingUtils.resetShaderColor(graphics);
            graphics.blit(ITexture.MISSING_TEXTURE_LOCATION, 0, 0, 0.0f, 0.0f, ScreenUtils.getScreenWidth(), ScreenUtils.getScreenHeight(), ScreenUtils.getScreenWidth(), ScreenUtils.getScreenHeight());
            RenderingUtils.resetShaderColor(graphics);
        } else {
            this.renderRaw(graphics.pose(), this.opacity);
        }
    }

    public void renderRaw(@NotNull PoseStack pose, float panoramaAlpha) {
        ResourceLocation location;
        ITexture texture;
        Minecraft mc = Minecraft.m_91087_();
        int screenW = ScreenUtils.getScreenWidth();
        int screenH = ScreenUtils.getScreenHeight();
        float pitch = this.angle;
        float yaw = -this.currentRotation;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        Matrix4f matrix4f = Matrix4f.m_27625_((double)this.fov, (float)((float)mc.m_91268_().m_85441_() / (float)mc.m_91268_().m_85442_()), (float)0.05f, (float)10.0f);
        RenderSystem.m_157183_();
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        modelViewStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        RenderSystem.m_157182_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
        RenderSystem.m_69478_();
        RenderSystem.m_69464_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69465_();
        for (int j = 0; j < 4; ++j) {
            modelViewStack.m_85836_();
            float k = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
            float l = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
            modelViewStack.m_85837_((double)k, (double)l, 0.0);
            modelViewStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
            modelViewStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
            RenderSystem.m_157182_();
            for (int n = 0; n < 6; ++n) {
                ResourceSupplier<ITexture> texSupplier;
                ITexture texture2;
                ResourceLocation location2 = null;
                if (this.panoramaImageSuppliers.size() >= n + 1 && (texture2 = (texSupplier = this.panoramaImageSuppliers.get(n)).get()) != null) {
                    location2 = texture2.getResourceLocation();
                }
                if (location2 == null) {
                    location2 = ITexture.MISSING_TEXTURE_LOCATION;
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)location2);
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                int o = Math.round(255.0f * panoramaAlpha) / (j + 1);
                if (n == 0) {
                    bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                }
                if (n == 1) {
                    bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                }
                if (n == 2) {
                    bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                }
                if (n == 3) {
                    bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                }
                if (n == 4) {
                    bufferBuilder.m_5483_(-1.0, -1.0, -1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, -1.0, 1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, -1.0, 1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, -1.0, -1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                }
                if (n == 5) {
                    bufferBuilder.m_5483_(-1.0, 1.0, 1.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(-1.0, 1.0, -1.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, 1.0, -1.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, o).m_5752_();
                    bufferBuilder.m_5483_(1.0, 1.0, 1.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, o).m_5752_();
                }
                tesselator.m_85914_();
            }
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_157424_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69481_();
        RenderSystem.m_69482_();
        GuiGraphics graphics = GuiGraphics.currentGraphics();
        if (this.overlayTextureSupplier != null && (texture = this.overlayTextureSupplier.get()) != null && (location = texture.getResourceLocation()) != null) {
            graphics.setColor(1.0f, 1.0f, 1.0f, this.opacity);
            RenderSystem.m_69478_();
            graphics.blit(location, 0, 0, 0.0f, 0.0f, screenW, screenH, screenW, screenH);
        }
        RenderingUtils.resetShaderColor(graphics);
    }

    public String getName() {
        return this.name;
    }

    public void setSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.speed = speed;
    }

    public void setFov(double fov) {
        if (fov > 179.0) {
            fov = 179.0;
        }
        this.fov = fov;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }
}

