/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.variables;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.variables.Variable;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.InitialWidgetFocusScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageVariablesScreen
extends ModernScreen
implements InitialWidgetFocusScreen {
    protected Consumer<List<Variable>> callback;
    protected ScrollArea variableListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public ManageVariablesScreen(@NotNull Consumer<List<Variable>> callback) {
        super((Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage"));
        this.callback = callback;
    }

    protected void m_7856_() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        this.searchBar = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 21, 66, this.f_96543_ / 2 - 40 - 2, 18, (Component)Component.m_237119_());
        this.searchBar.setHintFancyMenu(consumes -> Component.m_237115_((String)"fancymenu.variables.manage_variables.screen.search_variable"));
        this.searchBar.m_94144_(oldSearchValue);
        this.searchBar.m_94151_(s -> this.updateVariablesList());
        this.m_142416_((GuiEventListener)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.setupInitialFocusWidget(this, (GuiEventListener)this.searchBar);
        this.variableListScrollArea.setWidth(this.f_96543_ / 2 - 40, true);
        this.variableListScrollArea.setHeight(this.f_96544_ - 85 - 25, true);
        this.variableListScrollArea.setX(20, true);
        this.variableListScrollArea.setY(90, true);
        int buttonWidth = this.f_96543_ - 20 - (this.variableListScrollArea.getXWithBorder() + (this.variableListScrollArea.getWidthWithBorder() + 20));
        if (buttonWidth < 150) {
            buttonWidth = 150;
        }
        if (buttonWidth > 220) {
            buttonWidth = 220;
        }
        int doneButtonX = this.f_96543_ - 20 - buttonWidth;
        int doneButtonY = this.f_96544_ - 20 - 20;
        int toggleResetButtonX = doneButtonX;
        int toggleResetButtonY = doneButtonY - 15 - 20;
        int deleteButtonX = doneButtonX;
        int deleteButtonY = toggleResetButtonY - 5 - 20;
        int setValueButtonX = doneButtonX;
        int setValueButtonY = deleteButtonY - 5 - 20;
        int addButtonX = doneButtonX;
        int addButtonY = setValueButtonY - 15 - 20;
        ExtendedButton addVariableButton = new ExtendedButton(addButtonX, addButtonY, buttonWidth, 20, (Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage.add_variable"), button -> {
            TextInputScreen s = new TextInputScreen((Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage.add_variable.input_name"), CharacterFilter.buildOnlyLowercaseFileNameFilter(), call -> {
                if (call != null && !VariableHandler.variableExists(call)) {
                    VariableHandler.setVariable(call, "");
                    this.updateVariablesList();
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        });
        this.m_142416_((GuiEventListener)addVariableButton);
        UIBase.applyDefaultWidgetSkinTo(addVariableButton);
        ExtendedButton setValueButton = new ExtendedButton(setValueButtonX, setValueButtonY, buttonWidth, 20, (Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage.set_value"), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                TextInputScreen s = new TextInputScreen((Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage.set_value"), null, call -> {
                    if (call != null) {
                        e.variable.setValue((String)call);
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                });
                s.setText(e.variable.getValue());
                Minecraft.m_91087_().m_91152_((Screen)s);
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.m_142416_((GuiEventListener)setValueButton);
        UIBase.applyDefaultWidgetSkinTo(setValueButton);
        ExtendedButton deleteVariableButton = new ExtendedButton(deleteButtonX, deleteButtonY, buttonWidth, 20, (Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage.delete_variable"), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        VariableHandler.removeVariable(e.variable.getName());
                        this.updateVariablesList();
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.overlay.menu_bar.variables.manage.delete_variable.confirm", new String[0])));
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null);
        this.m_142416_((GuiEventListener)deleteVariableButton);
        UIBase.applyDefaultWidgetSkinTo(deleteVariableButton);
        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> resetOnLaunchDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch", false);
        ExtendedButton toggleResetOnLaunchButton = new ExtendedButton(toggleResetButtonX, toggleResetButtonY, buttonWidth, 20, (Component)Component.m_237119_(), button -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.variable.setResetOnLaunch(!e.variable.isResetOnLaunch());
            }
        }).setIsActiveSupplier(consumes -> this.getSelectedEntry() != null).setLabelSupplier(consumes -> {
            VariableScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> enabledDisabled = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.variables.manage.clear_on_launch");
                enabledDisabled.setCurrentValue(CommonCycles.CycleEnabledDisabled.getByBoolean(e.variable.isResetOnLaunch()));
                return enabledDisabled.getCycleComponent();
            }
            return resetOnLaunchDisabled.getCycleComponent();
        });
        this.m_142416_((GuiEventListener)toggleResetOnLaunchButton);
        UIBase.applyDefaultWidgetSkinTo(toggleResetOnLaunchButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, buttonWidth, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.done"), button -> this.callback.accept(VariableHandler.getVariables()));
        this.m_142416_((GuiEventListener)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        this.updateVariablesList();
    }

    public void m_7379_() {
        this.callback.accept(VariableHandler.getVariables());
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.performInitialWidgetFocusActionInRender();
        RenderSystem.m_69478_();
        graphics.fill(0, 0, this.f_96543_, this.f_96544_, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.drawString(this.f_96547_, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage.variables"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.variableListScrollArea.render(graphics, mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    @Nullable
    protected VariableScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.variableListScrollArea.getEntries()) {
            VariableScrollEntry s;
            if (!(e instanceof VariableScrollEntry) || !(s = (VariableScrollEntry)e).isSelected()) continue;
            return s;
        }
        return null;
    }

    protected boolean variableFitsSearchValue(@NotNull Variable variable, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (variable.getName().toLowerCase().contains(s)) {
            return true;
        }
        return variable.getValue().toLowerCase().contains(s);
    }

    protected void updateVariablesList() {
        String searchValue;
        String string = searchValue = this.searchBar != null ? this.searchBar.m_94155_() : "";
        if (searchValue.isBlank()) {
            searchValue = null;
        }
        this.variableListScrollArea.clearEntries();
        List<Variable> variables = VariableHandler.getVariables();
        variables.sort(Comparator.comparing(Variable::getName, String.CASE_INSENSITIVE_ORDER).thenComparing(Variable::getName));
        for (Variable v : variables) {
            if (!this.variableFitsSearchValue(v, searchValue)) continue;
            VariableScrollEntry e = new VariableScrollEntry(this.variableListScrollArea, v, entry -> {});
            this.variableListScrollArea.addEntry(e);
        }
        if (this.variableListScrollArea.getEntries().isEmpty()) {
            this.variableListScrollArea.addEntry(new TextScrollAreaEntry(this.variableListScrollArea, (Component)Component.m_237115_((String)"fancymenu.overlay.menu_bar.variables.manage.no_variables").m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().error_text_color.getColorInt())), entry -> {}));
        }
    }

    public static class VariableScrollEntry
    extends TextListScrollAreaEntry {
        public Variable variable;

        public VariableScrollEntry(ScrollArea parent, @NotNull Variable variable, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, (Component)Component.m_237113_((String)variable.name).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).m_7220_((Component)Component.m_237113_((String)(" (" + variable.getValue() + ")")).m_6270_(Style.f_131099_.m_178520_(UIBase.getUIColorTheme().warning_text_color.getColorInt()))), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.variable = variable;
        }
    }
}

