/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.WidgetWithVanillaTooltip;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationSupplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaTooltip
implements NarrationSupplier {
    private static final int MAX_WIDTH = 170;
    private final Component message;
    @Nullable
    private List<FormattedCharSequence> cachedTooltip;
    @Nullable
    private Language splitWithLanguage;
    @Nullable
    private final Component narration;
    @Nullable
    private List<MutableComponent> cachedTooltipComponents;

    private VanillaTooltip(Component message, @Nullable Component narration) {
        this.message = message;
        this.narration = narration;
    }

    public static VanillaTooltip create(Component message, @Nullable Component narration) {
        return new VanillaTooltip(message, narration);
    }

    public static VanillaTooltip create(Component message) {
        return new VanillaTooltip(message, message);
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
        if (this.narration != null) {
            narrationElementOutput.m_169146_(NarratedElementType.HINT, this.narration);
        }
    }

    public List<MutableComponent> toComponentList(Minecraft minecraft) {
        Language language = Language.m_128107_();
        if (this.cachedTooltipComponents == null || language != this.splitWithLanguage) {
            this.cachedTooltipComponents = TextFormattingUtils.lineWrapComponents(this.message, 170);
            this.splitWithLanguage = language;
        }
        return this.cachedTooltipComponents;
    }

    public List<FormattedCharSequence> toCharSequence(Minecraft minecraft) {
        Language language = Language.m_128107_();
        if (this.cachedTooltip == null || language != this.splitWithLanguage) {
            this.cachedTooltip = VanillaTooltip.splitTooltip(minecraft, this.message);
            this.splitWithLanguage = language;
        }
        return this.cachedTooltip;
    }

    public static List<FormattedCharSequence> splitTooltip(Minecraft minecraft, Component message) {
        return minecraft.f_91062_.m_92923_((FormattedText)message, 170);
    }

    public static void renderScreenTooltips(@NotNull Screen screen, @NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        for (GuiEventListener listener : screen.m_6702_()) {
            VanillaTooltip t;
            if (!(listener instanceof WidgetWithVanillaTooltip)) continue;
            WidgetWithVanillaTooltip l = (WidgetWithVanillaTooltip)listener;
            if (!(listener instanceof AbstractWidget)) continue;
            AbstractWidget w = (AbstractWidget)listener;
            if (!w.f_93624_ || !((IMixinAbstractWidget)w).getIsHoveredFancyMenu() || (t = l.getVanillaTooltip_FancyMenu()) == null) continue;
            screen.m_96617_(pose, t.toCharSequence(Minecraft.m_91087_()), mouseX, mouseY);
            return;
        }
    }
}

