/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinEditBox;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorLine
extends AdvancedTextField {
    private static final Logger LOGGER = LogManager.getLogger();
    public TextEditorScreen parent;
    protected String lastTickValue = "";
    public boolean isInMouseHighlightingMode = false;
    protected final Font font2;
    protected final boolean handleSelf2;
    public int textWidth = 0;
    public int lineIndex = 0;
    protected int currentHighlightPosXStart = 0;
    protected int currentHighlightPosXEnd = 0;
    protected int currentCharacterRenderIndex = 0;
    protected static boolean leftRightArrowWasDown = false;

    public TextEditorLine(Font font, int x, int y, int width, int height, boolean handleSelf, @Nullable CharacterFilter characterFilter, TextEditorScreen parent) {
        super(font, x, y, width, height, handleSelf, characterFilter);
        this.parent = parent;
        this.font2 = font;
        this.handleSelf2 = handleSelf;
        this.m_94182_(false);
    }

    public void m_6305_(@NotNull PoseStack matrix, int mouseX, int mouseY, float partial) {
        if (this.isInEditorArea()) {
            super.m_6305_(matrix, mouseX, mouseY, partial);
        }
        this.lastTickValue = this.m_94155_();
    }

    /*
     * WARNING - void declaration
     */
    protected MutableComponent getFormattedText(String text) {
        void var5_7;
        ArrayList<MutableComponent> chars = new ArrayList<MutableComponent>();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            char c = cArray[var5_7];
            Style style = Style.f_131099_;
            for (TextEditorFormattingRule r : this.parent.formattingRules) {
                Style rs = r.getStyle(c, this.currentCharacterRenderIndex, this.m_94207_(), this, this.parent.currentRenderCharacterIndexTotal, this.parent);
                if (rs == null || rs == Style.f_131099_) continue;
                style = rs.m_131146_(style);
            }
            chars.add(Components.literal(String.valueOf(c)).m_130948_(style));
            ++this.currentCharacterRenderIndex;
            ++this.parent.currentRenderCharacterIndexTotal;
            ++var5_7;
        }
        MutableComponent comp = Components.literal("");
        for (Component component : chars) {
            comp.m_7220_(component);
        }
        return comp;
    }

    public void m_6303_(PoseStack matrix, int mouseX, int mouseY, float partial) {
        this.currentCharacterRenderIndex = 0;
        this.m_94202_(this.parent.textColor.getRGB());
        this.m_94205_(this.parent.textColor.getRGB());
        if (this.m_94213_()) {
            int n;
            int textX;
            if (this.m_93696_()) {
                TextEditorLine.m_93172_((PoseStack)matrix, (int)0, (int)this.getY(), (int)this.parent.f_96543_, (int)(this.getY() + this.f_93619_), (int)this.parent.focusedLineColor.getRGB());
            }
            int textColorInt = this.m_94222_() ? this.getAsAccessor().getTextColorFancyMenu() : this.getAsAccessor().getTextColorUneditableFancyMenu();
            int cursorPos = this.m_94207_() - this.getAsAccessor().getDisplayPosFancyMenu();
            int highlightPos = this.getAsAccessor().getHighlightPosFancyMenu() - this.getAsAccessor().getDisplayPosFancyMenu();
            String text = this.m_94155_();
            boolean isCursorNotAtStartOrEnd = cursorPos >= 0 && cursorPos <= text.length();
            boolean renderCursor = this.m_93696_() && this.getAsAccessor().getFrameFancyMenu() / 6 % 2 == 0 && isCursorNotAtStartOrEnd;
            int n2 = textX = this.getAsAccessor().getBorderedFancyMenu() ? this.getX() + 4 : this.getX() + 1;
            if (this.getAsAccessor().getBorderedFancyMenu()) {
                n = this.getY() + (this.f_93619_ - 8) / 2;
            } else {
                int n3 = this.getY() + Math.max(0, this.m_93694_() / 2);
                Objects.requireNonNull(this.font2);
                n = n3 - 9 / 2;
            }
            int textY = n;
            int textXRender = textX;
            if (highlightPos > text.length()) {
                highlightPos = text.length();
            }
            if (!text.isEmpty()) {
                String textBeforeCursor = isCursorNotAtStartOrEnd ? text.substring(0, cursorPos) : text;
                textXRender = this.font2.m_92889_(matrix, (Component)this.getFormattedText(textBeforeCursor), (float)textX, (float)textY, textColorInt);
            }
            boolean isCursorNotAtEndOfLine = this.m_94207_() < this.m_94155_().length() || this.m_94155_().length() >= this.getAsAccessor().getMaxLengthFancyMenu();
            int cursorPosRender = textXRender;
            if (!isCursorNotAtStartOrEnd) {
                cursorPosRender = cursorPos > 0 ? textX + this.f_93618_ : textX;
            } else if (isCursorNotAtEndOfLine) {
                cursorPosRender = textXRender - 1;
            }
            if (!text.isEmpty() && isCursorNotAtStartOrEnd && cursorPos < text.length()) {
                this.font2.m_92889_(matrix, (Component)this.getFormattedText(text.substring(cursorPos)), (float)textXRender, (float)textY, textColorInt);
            }
            if (!isCursorNotAtEndOfLine && this.getAsAccessor().getSuggestionFancyMenu() != null) {
                this.font2.m_92883_(matrix, this.getAsAccessor().getSuggestionFancyMenu(), (float)(cursorPosRender - 1), (float)textY, -8355712);
            }
            if (renderCursor) {
                if (isCursorNotAtEndOfLine) {
                    TextEditorLine.m_93172_((PoseStack)matrix, (int)cursorPosRender, (int)(textY - 1), (int)(cursorPosRender + 1), (int)(textY + 1 + 9), (int)textColorInt);
                } else {
                    this.font2.m_92883_(matrix, "_", (float)cursorPosRender, (float)textY, textColorInt);
                }
            }
            if (highlightPos != cursorPos) {
                this.currentHighlightPosXStart = cursorPosRender;
                this.currentHighlightPosXEnd = textX + this.font2.m_92895_(text.substring(0, highlightPos)) - 1;
                this.getAsAccessor().invokeRenderHighlightFancyMenu(this.currentHighlightPosXStart, textY - 1, this.currentHighlightPosXEnd, textY + 1 + 9);
            } else {
                this.currentHighlightPosXStart = 0;
                this.currentHighlightPosXEnd = 0;
            }
        }
    }

    public boolean isInEditorArea() {
        return this.getY() + this.m_93694_() >= this.parent.getEditorAreaY() && this.getY() <= this.parent.getEditorAreaY() + this.parent.getEditorAreaHeight();
    }

    public boolean isHighlightedHovered() {
        if (this.isInEditorArea() && this.currentHighlightPosXStart != this.currentHighlightPosXEnd && this.isHovered()) {
            int mouseX = MouseInput.getMouseX();
            return mouseX >= Math.min(this.currentHighlightPosXStart, this.currentHighlightPosXEnd) && mouseX <= Math.max(this.currentHighlightPosXStart, this.currentHighlightPosXEnd);
        }
        return false;
    }

    public int getActualHeight() {
        int h = this.f_93619_;
        if (this.getAsAccessor().getBorderedFancyMenu()) {
            h += 2;
        }
        return h;
    }

    public IMixinEditBox getAsAccessor() {
        return (IMixinEditBox)((Object)this);
    }

    public void m_94196_(int newPos) {
        this.textWidth = this.font2.m_92895_(this.m_94155_());
        super.m_94196_(newPos);
        if (newPos != this.parent.lastCursorPosSetByUser && this.m_93696_()) {
            this.parent.lastCursorPosSetByUser = this.m_94207_();
        }
        this.parent.correctXScroll(this);
    }

    public void m_94120_() {
        if (!MouseInput.isLeftMouseDown() && this.isInMouseHighlightingMode) {
            this.isInMouseHighlightingMode = false;
        }
        super.m_94120_();
        leftRightArrowWasDown = false;
    }

    public boolean m_7933_(int keycode, int i1, int i2) {
        if (Screen.m_96632_((int)keycode) || Screen.m_96630_((int)keycode) || Screen.m_96634_((int)keycode) || Screen.m_96628_((int)keycode)) {
            return false;
        }
        if (keycode == 259) {
            return false;
        }
        if ((keycode == 262 || keycode == 263) && this.parent.isInMouseHighlightingMode()) {
            return false;
        }
        if (keycode == 263) {
            if (!leftRightArrowWasDown) {
                if (this.parent.isLineFocused() && this.parent.getFocusedLine() == this && this.m_94207_() <= 0 && this.parent.getLineIndex(this) > 0) {
                    leftRightArrowWasDown = true;
                    this.parent.goUpLine();
                    this.parent.getFocusedLine().m_94192_(this.parent.getFocusedLine().m_94155_().length());
                    this.parent.correctYScroll(0);
                    return true;
                }
            } else {
                return true;
            }
        }
        if (keycode == 262) {
            if (!leftRightArrowWasDown) {
                if (this.parent.isLineFocused() && this.parent.getFocusedLine() == this && this.m_94207_() >= this.m_94155_().length() && this.parent.getLineIndex(this) < this.parent.getLineCount() - 1) {
                    leftRightArrowWasDown = true;
                    this.parent.goDownLine(false);
                    this.parent.getFocusedLine().m_94192_(0);
                    this.parent.correctYScroll(0);
                    return true;
                }
            } else {
                return true;
            }
        }
        return super.m_7933_(keycode, i1, i2);
    }

    public void m_94180_(int i) {
        if (!this.parent.justSwitchedLineByWordDeletion) {
            if (this.m_94207_() == 0 && this.parent.getFocusedLineIndex() > 0) {
                int lastLineIndex = this.parent.getFocusedLineIndex();
                this.parent.justSwitchedLineByWordDeletion = true;
                this.parent.goUpLine();
                this.parent.getFocusedLine().m_94201_();
                this.parent.getFocusedLine().m_94164_(this.m_94155_());
                this.parent.getFocusedLine().m_94196_(this.parent.getFocusedLine().m_94207_() - this.m_94155_().length());
                this.parent.getFocusedLine().m_94208_(this.parent.getFocusedLine().m_94207_());
                if (lastLineIndex > 0) {
                    this.parent.removeLineAtIndex(this.parent.getFocusedLineIndex() + 1);
                    this.parent.correctYScroll(-1);
                }
            } else {
                super.m_94180_(i);
            }
        }
        this.textWidth = this.font2.m_92895_(this.m_94155_());
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (!this.parent.isMouseInsideEditorArea() || this.parent.rightClickContextMenu.isOpen()) {
            return false;
        }
        if (mouseButton == 0 && this.isHovered() && !this.isInMouseHighlightingMode && this.m_94213_()) {
            if (!this.parent.isAtLeastOneLineInHighlightMode()) {
                this.parent.startHighlightLine = this;
            }
            this.isInMouseHighlightingMode = true;
            this.parent.setFocusedLine(Math.max(0, this.parent.getLineIndex(this)));
            super.m_6375_(mouseX, mouseY, mouseButton);
            this.getAsAccessor().setShiftPressedFancyMenu(false);
            this.m_94208_(this.m_94207_());
        } else if (mouseButton == 0 && !this.isHovered()) {
            this.m_94208_(this.m_94207_());
        }
        if (!this.isInMouseHighlightingMode && mouseButton == 0) {
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public void m_94144_(String p_94145_) {
        super.m_94144_(p_94145_);
        this.textWidth = this.font2.m_92895_(this.m_94155_());
    }

    public void m_94164_(String textToWrite) {
        super.m_94164_(textToWrite);
        this.textWidth = this.font2.m_92895_(this.m_94155_());
    }

    public void m_94199_(int p_94200_) {
        super.m_94199_(p_94200_);
        this.textWidth = this.font2.m_92895_(this.m_94155_());
    }
}

